/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.vampirism.entity.ai.goals;

import de.teamlapen.vampirism.api.VampirismAPI;
import de.teamlapen.vampirism.api.entity.IVillageCaptureEntity;
import de.teamlapen.vampirism.api.entity.factions.IFactionEntity;
import de.teamlapen.vampirism.entity.VampirismEntity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.goal.target.TargetGoal;
import net.minecraft.world.entity.ai.targeting.TargetingConditions;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AttackVillageGoal<T extends VampirismEntity>
extends TargetGoal {
    @NotNull
    private final T attacker;
    @NotNull
    protected final TargetingConditions entityPredicate;
    private final double distance = this.getFollowDistance() * 4.0;

    public AttackVillageGoal(@NotNull T creature) {
        super(creature, false, false);
        this.attacker = creature;
        this.entityPredicate = new TargetingConditions(true){

            public boolean test(@Nullable LivingEntity attackEntity, @NotNull LivingEntity targetEntity) {
                if (((IVillageCaptureEntity)AttackVillageGoal.this.attacker).getCaptureInfo() != null && ((IVillageCaptureEntity)AttackVillageGoal.this.attacker).getCaptureInfo().shouldForceTargets() && AttackVillageGoal.this.getFollowDistance() > 0.0) {
                    this.range(-1.0);
                } else if (AttackVillageGoal.this.getFollowDistance() < 0.0) {
                    this.range(AttackVillageGoal.this.distance);
                }
                return super.test(attackEntity, targetEntity);
            }
        }.selector(VampirismAPI.factionRegistry().getPredicate(((IFactionEntity)this.attacker).getFaction(), false)).ignoreInvisibilityTesting();
    }

    public boolean canUse() {
        if (!((IVillageCaptureEntity)this.attacker).isAttackingVillage()) {
            return false;
        }
        if (((IVillageCaptureEntity)this.attacker).getTargetVillageArea() == null) {
            return false;
        }
        this.targetMob = this.attacker.level().getNearestEntity(LivingEntity.class, this.entityPredicate, (LivingEntity)this.mob, this.mob.getX(), this.mob.getY() + (double)this.mob.getEyeHeight(), this.mob.getZ(), ((IVillageCaptureEntity)this.attacker).getTargetVillageArea());
        return this.targetMob != null;
    }

    public void start() {
        this.attacker.setTarget(this.targetMob);
        super.start();
    }
}

