/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.vampirism.entity;

import de.teamlapen.vampirism.core.ModEntities;
import de.teamlapen.vampirism.core.ModItems;
import de.teamlapen.vampirism.util.Helper;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.tags.FluidTags;
import net.minecraft.util.Mth;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntitySelector;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.MoverType;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.ItemSupplier;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;
import net.neoforged.neoforge.common.NeoForgeMod;
import net.neoforged.neoforge.fluids.FluidType;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SoulOrbEntity
extends Entity
implements ItemSupplier {
    public static final EntityDataAccessor<String> TYPE_PARAMETER = SynchedEntityData.defineId(SoulOrbEntity.class, (EntityDataSerializer)EntityDataSerializers.STRING);
    private int delayBeforePickup;
    @Nullable
    private Player player;
    private int age;
    @Nullable
    private ItemStack soulItemStack;

    public SoulOrbEntity(@NotNull Level worldIn, double x, double y, double z, @NotNull VARIANT type) {
        super((EntityType)ModEntities.SOUL_ORB.get(), worldIn);
        this.setVariant(type);
        this.delayBeforePickup = 10;
        this.setPos(x, y, z);
        this.setYRot((float)(Math.random() * 360.0));
        this.setDeltaMovement((this.random.nextDouble() * (double)0.2f - (double)0.1f) * 2.0, this.random.nextDouble() * 0.2 * 2.0, (this.random.nextDouble() * (double)0.2f - (double)0.1f) * 2.0);
    }

    public SoulOrbEntity(@NotNull EntityType<? extends SoulOrbEntity> type, @NotNull Level worldIn) {
        super(type, worldIn);
    }

    @NotNull
    public VARIANT getVariant() {
        return VARIANT.valueOf((String)this.getEntityData().get(TYPE_PARAMETER));
    }

    private void setVariant(@NotNull VARIANT type) {
        this.getEntityData().set(TYPE_PARAMETER, (Object)type.name());
    }

    @NotNull
    public ItemStack getItem() {
        return this.getSoulItemStack();
    }

    @NotNull
    public ItemStack getSoulItemStack() {
        if (this.soulItemStack == null) {
            this.soulItemStack = this.createSoulItemStack();
        }
        return this.soulItemStack;
    }

    public boolean hurt(@NotNull DamageSource source, float amount) {
        return false;
    }

    public boolean isAttackable() {
        return false;
    }

    public boolean isInvisibleTo(@NotNull Player player) {
        if (this.getVariant() == VARIANT.VAMPIRE) {
            return !Helper.isHunter(player) || player.isSpectator();
        }
        return true;
    }

    public void playerTouch(@NotNull Player entityIn) {
        if (!this.level().isClientSide && this.delayBeforePickup == 0 && Helper.isHunter(entityIn) && entityIn.getInventory().add(this.getSoulItemStack())) {
            entityIn.take((Entity)this, 1);
            this.discard();
        }
    }

    public void tick() {
        double d1;
        Vec3 vec3d;
        super.tick();
        if (this.delayBeforePickup > 0) {
            --this.delayBeforePickup;
        }
        this.xo = this.getX();
        this.yo = this.getY();
        this.zo = this.getZ();
        if (this.isEyeInFluidType((FluidType)NeoForgeMod.WATER_TYPE.value())) {
            vec3d = this.getDeltaMovement();
            this.setDeltaMovement(vec3d.x * (double)0.99f, Math.min(vec3d.y + (double)5.0E-4f, (double)0.06f), vec3d.z * (double)0.99f);
        } else if (!this.isNoGravity()) {
            this.setDeltaMovement(this.getDeltaMovement().add(0.0, -0.03, 0.0));
        }
        if (this.level().getFluidState(this.blockPosition()).is(FluidTags.LAVA)) {
            this.setDeltaMovement((this.random.nextFloat() - this.random.nextFloat()) * 0.2f, 0.2f, (this.random.nextFloat() - this.random.nextFloat()) * 0.2f);
            this.playSound(SoundEvents.GENERIC_BURN, 0.4f, 2.0f + this.random.nextFloat() * 0.4f);
        }
        if (!this.level().noCollision(this.getBoundingBox())) {
            this.moveTowardsClosestSpace(this.getX(), (this.getBoundingBox().minY + this.getBoundingBox().maxY) / 2.0, this.getZ());
        }
        if (this.age % 10 == 5 & (this.player == null || !this.player.isAlive() || this.player.distanceToSqr((Entity)this) > 64.0)) {
            this.player = this.level().getNearestPlayer(this.getX(), this.getY(), this.getZ(), 8.0, EntitySelector.NO_SPECTATORS.and(Helper::isHunter));
        }
        if (this.player != null && (d1 = (vec3d = new Vec3(this.player.getX() - this.getX(), this.player.getY() + (double)this.player.getEyeHeight() / 2.0 - this.getY(), this.player.getZ() - this.getZ())).lengthSqr()) < 64.0) {
            double d2 = 1.0 - Math.sqrt(d1) / 8.0;
            this.setDeltaMovement(this.getDeltaMovement().add(vec3d.normalize().scale(d2 * d2 * 0.1)));
        }
        this.move(MoverType.SELF, this.getDeltaMovement());
        float f = 0.98f;
        if (this.onGround()) {
            BlockPos underPos = new BlockPos(Mth.floor((double)this.getX()), Mth.floor((double)this.getBoundingBox().minY) - 1, Mth.floor((double)this.getZ()));
            BlockState underState = this.level().getBlockState(underPos);
            f = underState.getBlock().getFriction(underState, (LevelReader)this.level(), underPos, (Entity)this) * 0.98f;
        }
        this.setDeltaMovement(this.getDeltaMovement().multiply((double)f, (double)0.98f, (double)f));
        if (this.onGround()) {
            this.setDeltaMovement(this.getDeltaMovement().multiply(1.0, (double)-0.9f, 1.0));
        }
        ++this.age;
        if (this.age >= 6000) {
            this.discard();
        }
    }

    protected void addAdditionalSaveData(@NotNull CompoundTag compound) {
        compound.putString("type", this.getVariant().name());
        compound.putInt("age", this.age);
    }

    protected void defineSynchedData(SynchedEntityData.Builder builder) {
        builder.define(TYPE_PARAMETER, (Object)VARIANT.NONE.name());
    }

    @NotNull
    protected Entity.MovementEmission getMovementEmission() {
        return Entity.MovementEmission.NONE;
    }

    protected void readAdditionalSaveData(@NotNull CompoundTag compound) {
        this.setVariant(VARIANT.valueOf(compound.getString("type")));
        this.age = compound.getInt("age");
        this.soulItemStack = null;
    }

    @NotNull
    private ItemStack createSoulItemStack() {
        if (this.getVariant() == VARIANT.VAMPIRE) {
            return new ItemStack((ItemLike)ModItems.SOUL_ORB_VAMPIRE.get());
        }
        return new ItemStack((ItemLike)ModItems.SOUL_ORB_VAMPIRE.get());
    }

    public static enum VARIANT {
        NONE,
        VAMPIRE;

    }
}

