/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.vampirism.data.recipebuilder;

import com.mojang.datafixers.util.Either;
import de.teamlapen.vampirism.api.entity.player.skills.ISkill;
import de.teamlapen.vampirism.recipes.AlchemicalCauldronRecipe;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import net.minecraft.advancements.Advancement;
import net.minecraft.advancements.AdvancementRequirements;
import net.minecraft.advancements.AdvancementRewards;
import net.minecraft.advancements.Criterion;
import net.minecraft.advancements.critereon.RecipeUnlockedTrigger;
import net.minecraft.data.recipes.RecipeBuilder;
import net.minecraft.data.recipes.RecipeOutput;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.level.ItemLike;
import net.neoforged.neoforge.fluids.FluidStack;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AlchemicalCauldronRecipeBuilder
implements RecipeBuilder {
    @NotNull
    protected final ItemStack result;
    protected String group;
    protected Ingredient ingredient;
    protected Either<Ingredient, FluidStack> fluid;
    protected List<ISkill<?>> skills = new LinkedList();
    protected int reqLevel = 1;
    protected int cookTime = 200;
    protected float exp = 0.2f;
    protected final Map<String, Criterion<?>> criteria = new LinkedHashMap();

    @NotNull
    public static AlchemicalCauldronRecipeBuilder cauldronRecipe(@NotNull Item item) {
        return AlchemicalCauldronRecipeBuilder.cauldronRecipe(item, 1);
    }

    @NotNull
    public static AlchemicalCauldronRecipeBuilder cauldronRecipe(@NotNull Item item, int count) {
        return new AlchemicalCauldronRecipeBuilder(item, count);
    }

    public AlchemicalCauldronRecipeBuilder(@NotNull Item result, int count) {
        this.result = new ItemStack((ItemLike)result, count);
    }

    public void save(RecipeOutput recipeOutput, @NotNull ResourceLocation resourceLocation) {
        Advancement.Builder builder = recipeOutput.advancement().addCriterion("has_the_recipe", RecipeUnlockedTrigger.unlocked((ResourceLocation)resourceLocation)).rewards(AdvancementRewards.Builder.recipe((ResourceLocation)resourceLocation)).requirements(AdvancementRequirements.Strategy.OR);
        this.criteria.forEach((arg_0, arg_1) -> ((Advancement.Builder)builder).addCriterion(arg_0, arg_1));
        AlchemicalCauldronRecipe recipe = new AlchemicalCauldronRecipe(Objects.requireNonNullElse(this.group, ""), this.ingredient, this.fluid, this.result, this.skills, this.reqLevel, this.cookTime, this.exp);
        recipeOutput.accept(resourceLocation, (Recipe)recipe, builder.build(resourceLocation.withPrefix("recipes/alchemical_cauldron/")));
    }

    @NotNull
    public RecipeBuilder unlockedBy(@NotNull String name, @NotNull Criterion<?> criterion) {
        this.criteria.put(name, criterion);
        return this;
    }

    @NotNull
    public Item getResult() {
        return this.result.getItem();
    }

    @NotNull
    public AlchemicalCauldronRecipeBuilder cookTime(int cookTime) {
        this.cookTime = cookTime;
        return this;
    }

    @NotNull
    public AlchemicalCauldronRecipeBuilder experience(float exp) {
        this.exp = exp;
        return this;
    }

    @NotNull
    public AlchemicalCauldronRecipeBuilder group(@Nullable String group) {
        this.group = group;
        return this;
    }

    @NotNull
    public AlchemicalCauldronRecipeBuilder requireLevel(int level) {
        this.reqLevel = level;
        return this;
    }

    @NotNull
    public AlchemicalCauldronRecipeBuilder withFluid(@NotNull TagKey<Item> tag) {
        this.fluid = Either.left((Object)Ingredient.of(tag));
        return this;
    }

    @NotNull
    public AlchemicalCauldronRecipeBuilder withFluid(@NotNull FluidStack fluid) {
        this.fluid = Either.right((Object)fluid);
        return this;
    }

    @NotNull
    public AlchemicalCauldronRecipeBuilder withFluid(ItemLike ... item) {
        this.fluid = Either.left((Object)Ingredient.of((ItemLike[])item));
        return this;
    }

    @NotNull
    public AlchemicalCauldronRecipeBuilder withFluid(ItemStack ... stacks) {
        this.fluid = Either.left((Object)Ingredient.of((ItemStack[])stacks));
        return this;
    }

    @NotNull
    public AlchemicalCauldronRecipeBuilder withIngredient(ItemLike ... items) {
        this.ingredient = Ingredient.of((ItemLike[])items);
        return this;
    }

    @NotNull
    public AlchemicalCauldronRecipeBuilder withIngredient(ItemStack ... stacks) {
        this.ingredient = Ingredient.of((ItemStack[])stacks);
        return this;
    }

    @NotNull
    public AlchemicalCauldronRecipeBuilder withIngredient(@NotNull TagKey<Item> tag) {
        this.ingredient = Ingredient.of(tag);
        return this;
    }

    @NotNull
    public AlchemicalCauldronRecipeBuilder withSkills(ISkill<?> ... skills) {
        this.skills.addAll(Arrays.asList(skills));
        return this;
    }
}

