/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.vampirism.core;

import de.teamlapen.vampirism.api.VampirismAPI;
import de.teamlapen.vampirism.api.items.ExtendedPotionMix;
import de.teamlapen.vampirism.blocks.GarlicBlock;
import de.teamlapen.vampirism.core.ModBlocks;
import de.teamlapen.vampirism.core.ModEffects;
import de.teamlapen.vampirism.effects.VampirismPotion;
import java.util.function.Supplier;
import net.minecraft.core.Holder;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.tags.TagKey;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.alchemy.Potion;
import net.minecraft.world.item.alchemy.Potions;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.neoforge.common.Tags;
import net.neoforged.neoforge.event.brewing.RegisterBrewingRecipesEvent;
import net.neoforged.neoforge.registries.DeferredHolder;
import net.neoforged.neoforge.registries.DeferredRegister;

public class ModPotions {
    public static final DeferredRegister<Potion> POTIONS = DeferredRegister.create((ResourceKey)Registries.POTION, (String)"vampirism");
    public static final DeferredHolder<Potion, VampirismPotion.HunterPotion> VERY_LONG_SLOW_FALLING = POTIONS.register("very_long_slow_falling", () -> new VampirismPotion.HunterPotion("slow_falling", new MobEffectInstance(MobEffects.SLOW_FALLING, 48000)));
    public static final DeferredHolder<Potion, VampirismPotion.HunterPotion> LONG_LUCK = POTIONS.register("long_luck", () -> new VampirismPotion.HunterPotion("luck", new MobEffectInstance(MobEffects.LUCK, 60000)));
    public static final DeferredHolder<Potion, VampirismPotion.HunterPotion> VERY_LONG_WEAKNESS = POTIONS.register("very_long_weakness", () -> new VampirismPotion.HunterPotion("weakness", new MobEffectInstance(MobEffects.WEAKNESS, 48000)));
    public static final DeferredHolder<Potion, VampirismPotion.HunterPotion> VERY_STRONG_STRENGTH = POTIONS.register("very_strong_strength", () -> new VampirismPotion.HunterPotion("strength", new MobEffectInstance(MobEffects.DAMAGE_BOOST, 600, 2)));
    public static final DeferredHolder<Potion, VampirismPotion.HunterPotion> VERY_LONG_STRENGTH = POTIONS.register("very_long_strength", () -> new VampirismPotion.HunterPotion("strength", new MobEffectInstance(MobEffects.DAMAGE_BOOST, 96000)));
    public static final DeferredHolder<Potion, VampirismPotion.HunterPotion> LONG_STRONG_STRENGTH = POTIONS.register("long_strong_strength", () -> new VampirismPotion.HunterPotion("strength", new MobEffectInstance(MobEffects.DAMAGE_BOOST, 4800, 1)));
    public static final DeferredHolder<Potion, VampirismPotion.HunterPotion> VERY_STRONG_REGENERATION = POTIONS.register("very_strong_regeneration", () -> new VampirismPotion.HunterPotion("regeneration", new MobEffectInstance(MobEffects.REGENERATION, 450, 2)));
    public static final DeferredHolder<Potion, VampirismPotion.HunterPotion> VERY_LONG_REGENERATION = POTIONS.register("very_long_regeneration", () -> new VampirismPotion.HunterPotion("regeneration", new MobEffectInstance(MobEffects.REGENERATION, 18000)));
    public static final DeferredHolder<Potion, VampirismPotion.HunterPotion> LONG_STRONG_REGENERATION = POTIONS.register("long_strong_regeneration", () -> new VampirismPotion.HunterPotion("regeneration", new MobEffectInstance(MobEffects.REGENERATION, 1200, 1)));
    public static final DeferredHolder<Potion, VampirismPotion.HunterPotion> VERY_STRONG_POISON = POTIONS.register("very_strong_poison", () -> new VampirismPotion.HunterPotion("poison", new MobEffectInstance(MobEffects.POISON, 432, 2)));
    public static final DeferredHolder<Potion, VampirismPotion.HunterPotion> LONG_STRONG_POISON = POTIONS.register("long_strong_poison", () -> new VampirismPotion.HunterPotion("poison", new MobEffectInstance(MobEffects.POISON, 1200, 1)));
    public static final DeferredHolder<Potion, VampirismPotion.HunterPotion> VERY_LONG_POISON = POTIONS.register("very_long_poison", () -> new VampirismPotion.HunterPotion("poison", new MobEffectInstance(MobEffects.POISON, 18000)));
    public static final DeferredHolder<Potion, VampirismPotion.HunterPotion> VERY_STRONG_HEALING = POTIONS.register("very_strong_healing", () -> new VampirismPotion.HunterPotion("healing", new MobEffectInstance(MobEffects.HEAL, 1, 2)));
    public static final DeferredHolder<Potion, VampirismPotion.HunterPotion> VERY_LONG_WATER_BREATHING = POTIONS.register("very_long_water_breathing", () -> new VampirismPotion.HunterPotion("water_breathing", new MobEffectInstance(MobEffects.WATER_BREATHING, 96000)));
    public static final DeferredHolder<Potion, VampirismPotion.HunterPotion> VERY_STRONG_SLOWNESS = POTIONS.register("very_strong_slowness", () -> new VampirismPotion.HunterPotion("slowness", new MobEffectInstance(MobEffects.MOVEMENT_SLOWDOWN, 400, 5)));
    public static final DeferredHolder<Potion, VampirismPotion.HunterPotion> VERY_LONG_SLOWNESS = POTIONS.register("very_long_slowness", () -> new VampirismPotion.HunterPotion("slowness", new MobEffectInstance(MobEffects.MOVEMENT_SLOWDOWN, 48000)));
    public static final DeferredHolder<Potion, VampirismPotion.HunterPotion> LONG_STRONG_SLOWNESS = POTIONS.register("long_strong_slowness", () -> new VampirismPotion.HunterPotion("slowness", new MobEffectInstance(MobEffects.MOVEMENT_SLOWDOWN, 4800, 3)));
    public static final DeferredHolder<Potion, VampirismPotion.HunterPotion> VERY_STRONG_SWIFTNESS = POTIONS.register("very_strong_swiftness", () -> new VampirismPotion.HunterPotion("swiftness", new MobEffectInstance(MobEffects.MOVEMENT_SPEED, 1200, 2)));
    public static final DeferredHolder<Potion, VampirismPotion.HunterPotion> VERY_LONG_SWIFTNESS = POTIONS.register("very_long_swiftness", () -> new VampirismPotion.HunterPotion("swiftness", new MobEffectInstance(MobEffects.MOVEMENT_SPEED, 48000)));
    public static final DeferredHolder<Potion, VampirismPotion.HunterPotion> LONG_STRONG_SWIFTNESS = POTIONS.register("long_strong_swiftness", () -> new VampirismPotion.HunterPotion("swiftness", new MobEffectInstance(MobEffects.MOVEMENT_SPEED, 4800, 1)));
    public static final DeferredHolder<Potion, VampirismPotion.HunterPotion> VERY_LONG_FIRE_RESISTANCE = POTIONS.register("very_long_fire_resistance", () -> new VampirismPotion.HunterPotion("fire_resistance", new MobEffectInstance(MobEffects.FIRE_RESISTANCE, 96000)));
    public static final DeferredHolder<Potion, VampirismPotion.HunterPotion> VERY_STRONG_LEAPING = POTIONS.register("very_strong_leaping", () -> new VampirismPotion.HunterPotion("leaping", new MobEffectInstance(MobEffects.JUMP, 1800, 2)));
    public static final DeferredHolder<Potion, VampirismPotion.HunterPotion> VERY_LONG_LEAPING = POTIONS.register("very_long_leaping", () -> new VampirismPotion.HunterPotion("leaping", new MobEffectInstance(MobEffects.JUMP, 96000)));
    public static final DeferredHolder<Potion, VampirismPotion.HunterPotion> LONG_STRONG_LEAPING = POTIONS.register("long_strong_leaping", () -> new VampirismPotion.HunterPotion("leaping", new MobEffectInstance(MobEffects.JUMP, 9600, 1)));
    public static final DeferredHolder<Potion, VampirismPotion.HunterPotion> VERY_LONG_INVISIBILITY = POTIONS.register("very_long_invisibility", () -> new VampirismPotion.HunterPotion("invisibility", new MobEffectInstance(MobEffects.INVISIBILITY, 96000)));
    public static final DeferredHolder<Potion, VampirismPotion.HunterPotion> VERY_LONG_NIGHT_VISION = POTIONS.register("very_long_night_vision", () -> new VampirismPotion.HunterPotion("night_vision", new MobEffectInstance(MobEffects.NIGHT_VISION, 96000)));
    public static final DeferredHolder<Potion, VampirismPotion.HunterPotion> NAUSEA = POTIONS.register("nausea", () -> new VampirismPotion.HunterPotion(null, new MobEffectInstance(MobEffects.CONFUSION, 1200)));
    public static final DeferredHolder<Potion, VampirismPotion.HunterPotion> LONG_NAUSEA = POTIONS.register("long_nausea", () -> new VampirismPotion.HunterPotion("nausea", new MobEffectInstance(MobEffects.CONFUSION, 2400)));
    public static final DeferredHolder<Potion, VampirismPotion.HunterPotion> VERY_LONG_NAUSEA = POTIONS.register("very_long_nausea", () -> new VampirismPotion.HunterPotion("nausea", new MobEffectInstance(MobEffects.CONFUSION, 24000)));
    public static final DeferredHolder<Potion, VampirismPotion.HunterPotion> BLINDNESS = POTIONS.register("blindness", () -> new VampirismPotion.HunterPotion(null, new MobEffectInstance(MobEffects.BLINDNESS, 1200)));
    public static final DeferredHolder<Potion, VampirismPotion.HunterPotion> LONG_BLINDNESS = POTIONS.register("long_blindness", () -> new VampirismPotion.HunterPotion("blindness", new MobEffectInstance(MobEffects.BLINDNESS, 4800)));
    public static final DeferredHolder<Potion, VampirismPotion.HunterPotion> VERY_LONG_BLINDNESS = POTIONS.register("very_long_blindness", () -> new VampirismPotion.HunterPotion("blindness", new MobEffectInstance(MobEffects.BLINDNESS, 24000)));
    public static final DeferredHolder<Potion, VampirismPotion.HunterPotion> HEALTH_BOOST = POTIONS.register("health_boost", () -> new VampirismPotion.HunterPotion(null, new MobEffectInstance(MobEffects.HEALTH_BOOST, 1200)));
    public static final DeferredHolder<Potion, VampirismPotion.HunterPotion> LONG_HEALTH_BOOST = POTIONS.register("long_health_boost", () -> new VampirismPotion.HunterPotion("health_boost", new MobEffectInstance(MobEffects.HEALTH_BOOST, 4800)));
    public static final DeferredHolder<Potion, VampirismPotion.HunterPotion> STRONG_HEALTH_BOOST = POTIONS.register("strong_health_boost", () -> new VampirismPotion.HunterPotion("health_boost", new MobEffectInstance(MobEffects.HEALTH_BOOST, 400, 1)));
    public static final DeferredHolder<Potion, VampirismPotion.HunterPotion> VERY_LONG_HEALTH_BOOST = POTIONS.register("very_long_health_boost", () -> new VampirismPotion.HunterPotion("health_boost", new MobEffectInstance(MobEffects.HEALTH_BOOST, 48000)));
    public static final DeferredHolder<Potion, VampirismPotion.HunterPotion> VERY_STRONG_HEALTH_BOOST = POTIONS.register("very_strong_health_boost", () -> new VampirismPotion.HunterPotion("health_boost", new MobEffectInstance(MobEffects.HEALTH_BOOST, 400, 2)));
    public static final DeferredHolder<Potion, VampirismPotion.HunterPotion> LONG_STRONG_HEALTH_BOOST = POTIONS.register("long_strong_health_boost", () -> new VampirismPotion.HunterPotion("health_boost", new MobEffectInstance(MobEffects.HEALTH_BOOST, 1200, 1)));
    public static final DeferredHolder<Potion, Potion> GARLIC = POTIONS.register("garlic", () -> new Potion(new MobEffectInstance[]{new MobEffectInstance(ModEffects.GARLIC, 1200)}));
    public static final DeferredHolder<Potion, VampirismPotion> VAMPIRE_FIRE_RESISTANCE = POTIONS.register("vampire_fire_resistance", () -> new VampirismPotion(null, new MobEffectInstance(ModEffects.FIRE_PROTECTION, 3600, 5)));
    public static final DeferredHolder<Potion, VampirismPotion> LONG_VAMPIRE_FIRE_RESISTANCE = POTIONS.register("long_vampire_fire_resistance", () -> new VampirismPotion("vampire_fire_resistance", new MobEffectInstance(ModEffects.FIRE_PROTECTION, 9600, 5)));

    static void register(IEventBus bus) {
        POTIONS.register(bus);
    }

    static void registerPotionMixes(RegisterBrewingRecipesEvent event) {
        ModPotions.registerPotionMixes();
        event.getBuilder().addMix(Potions.WATER, ((GarlicBlock)((Object)ModBlocks.GARLIC.get())).asItem(), GARLIC);
    }

    private static void registerPotionMixes() {
        ModPotions.veryDurable((Holder<Potion>)Potions.LUCK, LONG_LUCK);
        ModPotions.veryDurable((Holder<Potion>)Potions.LONG_SLOW_FALLING, VERY_LONG_SLOW_FALLING);
        ModPotions.veryDurable((Holder<Potion>)Potions.LONG_WEAKNESS, VERY_LONG_WEAKNESS);
        ModPotions.veryStrong((Holder<Potion>)Potions.STRONG_STRENGTH, VERY_STRONG_STRENGTH);
        ModPotions.veryDurable((Holder<Potion>)Potions.LONG_STRENGTH, VERY_LONG_STRENGTH);
        ModPotions.veryDurable(VERY_STRONG_STRENGTH, LONG_STRONG_STRENGTH);
        ModPotions.veryStrong(VERY_LONG_STRENGTH, LONG_STRONG_STRENGTH);
        ModPotions.veryDurable((Holder<Potion>)Potions.LONG_REGENERATION, VERY_LONG_REGENERATION);
        ModPotions.veryStrong((Holder<Potion>)Potions.STRONG_REGENERATION, VERY_STRONG_REGENERATION);
        ModPotions.veryDurable(VERY_STRONG_REGENERATION, LONG_STRONG_REGENERATION);
        ModPotions.veryStrong(VERY_LONG_REGENERATION, LONG_STRONG_REGENERATION);
        ModPotions.veryDurable((Holder<Potion>)Potions.LONG_POISON, VERY_LONG_POISON);
        ModPotions.veryStrong((Holder<Potion>)Potions.STRONG_POISON, VERY_STRONG_POISON);
        ModPotions.veryDurable(VERY_STRONG_POISON, LONG_STRONG_POISON);
        ModPotions.veryStrong(VERY_LONG_POISON, LONG_STRONG_POISON);
        ModPotions.veryStrong((Holder<Potion>)Potions.STRONG_HEALING, VERY_STRONG_HEALING);
        ModPotions.veryDurable((Holder<Potion>)Potions.LONG_WATER_BREATHING, VERY_LONG_WATER_BREATHING);
        ModPotions.veryDurable((Holder<Potion>)Potions.LONG_SLOWNESS, VERY_LONG_SLOWNESS);
        ModPotions.veryStrong((Holder<Potion>)Potions.STRONG_SLOWNESS, VERY_STRONG_SLOWNESS);
        ModPotions.veryDurable(VERY_STRONG_SLOWNESS, LONG_STRONG_SLOWNESS);
        ModPotions.veryStrong(VERY_LONG_SLOWNESS, LONG_STRONG_SLOWNESS);
        ModPotions.veryDurable((Holder<Potion>)Potions.LONG_SWIFTNESS, VERY_LONG_SWIFTNESS);
        ModPotions.veryStrong((Holder<Potion>)Potions.STRONG_SWIFTNESS, VERY_STRONG_SWIFTNESS);
        ModPotions.veryDurable(VERY_STRONG_SWIFTNESS, LONG_STRONG_SWIFTNESS);
        ModPotions.veryStrong(VERY_LONG_SWIFTNESS, LONG_STRONG_SWIFTNESS);
        ModPotions.veryDurable((Holder<Potion>)Potions.LONG_FIRE_RESISTANCE, VERY_LONG_FIRE_RESISTANCE);
        ModPotions.veryStrong((Holder<Potion>)Potions.STRONG_LEAPING, VERY_STRONG_LEAPING);
        ModPotions.veryDurable((Holder<Potion>)Potions.LONG_LEAPING, VERY_LONG_LEAPING);
        ModPotions.veryDurable(VERY_STRONG_LEAPING, LONG_STRONG_LEAPING);
        ModPotions.veryStrong(VERY_LONG_LEAPING, LONG_STRONG_LEAPING);
        ModPotions.veryDurable((Holder<Potion>)Potions.LONG_INVISIBILITY, VERY_LONG_INVISIBILITY);
        ModPotions.veryDurable((Holder<Potion>)Potions.LONG_NIGHT_VISION, VERY_LONG_NIGHT_VISION);
        ModPotions.master(NAUSEA, () -> Ingredient.of((TagKey)Tags.Items.MUSHROOMS), 32, 16);
        ModPotions.durable(NAUSEA, LONG_NAUSEA);
        ModPotions.veryDurable(LONG_NAUSEA, VERY_LONG_NAUSEA);
        ModPotions.master(BLINDNESS, () -> Ingredient.of((ItemLike[])new ItemLike[]{Items.INK_SAC}), 64, 32);
        ModPotions.durable(BLINDNESS, LONG_BLINDNESS);
        ModPotions.veryDurable(LONG_BLINDNESS, VERY_LONG_BLINDNESS);
        ModPotions.master(HEALTH_BOOST, () -> Ingredient.of((ItemLike[])new ItemLike[]{Items.APPLE}), 64, 32);
        ModPotions.durable(HEALTH_BOOST, LONG_HEALTH_BOOST);
        ModPotions.strong(HEALTH_BOOST, STRONG_HEALTH_BOOST);
        ModPotions.veryDurable(LONG_HEALTH_BOOST, VERY_LONG_HEALTH_BOOST);
        ModPotions.veryStrong(STRONG_HEALTH_BOOST, VERY_STRONG_HEALTH_BOOST);
        ModPotions.veryDurable(VERY_STRONG_HEALTH_BOOST, LONG_STRONG_HEALTH_BOOST);
        ModPotions.veryStrong(VERY_LONG_HEALTH_BOOST, LONG_STRONG_HEALTH_BOOST);
    }

    private static void durable(Holder<Potion> in, Holder<Potion> out) {
        VampirismAPI.extendedBrewingRecipeRegistry().addMix(new ExtendedPotionMix.Builder(in, out).ingredient(() -> Ingredient.of((ItemLike[])new ItemLike[]{Items.REDSTONE}), 1).blood().build());
    }

    private static void strong(Holder<Potion> in, Holder<Potion> out) {
        VampirismAPI.extendedBrewingRecipeRegistry().addMix(new ExtendedPotionMix.Builder(in, out).ingredient(() -> Ingredient.of((ItemLike[])new ItemLike[]{Items.GLOWSTONE_DUST}), 1).blood().build());
    }

    private static void veryDurable(Holder<Potion> in, Holder<Potion> out) {
        VampirismAPI.extendedBrewingRecipeRegistry().addMix(new ExtendedPotionMix.Builder(in, out).ingredient(() -> Ingredient.of((ItemLike[])new ItemLike[]{Items.REDSTONE_BLOCK}), 32, 16).blood().durable().build());
    }

    private static void veryStrong(Holder<Potion> in, Holder<Potion> out) {
        VampirismAPI.extendedBrewingRecipeRegistry().addMix(new ExtendedPotionMix.Builder(in, out).ingredient(() -> Ingredient.of((ItemLike[])new ItemLike[]{Items.GLOWSTONE}), 64, 32).blood().concentrated().build());
    }

    private static void master(Holder<Potion> out, Supplier<Ingredient> in, int count, int countReduced) {
        VampirismAPI.extendedBrewingRecipeRegistry().addMix(new ExtendedPotionMix.Builder((Holder<Potion>)Potions.AWKWARD, out).master().ingredient(in, count, countReduced).blood().build());
    }
}

