/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.vampirism.core;

import de.teamlapen.vampirism.api.util.VResourceLocation;
import net.minecraft.core.registries.Registries;
import net.minecraft.data.worldgen.BootstrapContext;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.damagesource.DamageEffects;
import net.minecraft.world.damagesource.DamageScaling;
import net.minecraft.world.damagesource.DamageType;
import net.minecraft.world.damagesource.DeathMessageType;

public class ModDamageTypes {
    public static final ResourceKey<DamageType> SUN_DAMAGE = ModDamageTypes.createKey("sun_damage");
    public static final ResourceKey<DamageType> VAMPIRE_ON_FIRE = ModDamageTypes.createKey("vampire_on_fire");
    public static final ResourceKey<DamageType> VAMPIRE_IN_FIRE = ModDamageTypes.createKey("vampire_in_fire");
    public static final ResourceKey<DamageType> HOLY_WATER = ModDamageTypes.createKey("holy_water");
    public static final ResourceKey<DamageType> NO_BLOOD = ModDamageTypes.createKey("blood_loss");
    public static final ResourceKey<DamageType> MINION = ModDamageTypes.createKey("minion");
    public static final ResourceKey<DamageType> DBNO = ModDamageTypes.createKey("dbno");
    public static final ResourceKey<DamageType> MOTHER = ModDamageTypes.createKey("mother");
    public static final ResourceKey<DamageType> STAKE = ModDamageTypes.createKey("stake");

    private static ResourceKey<DamageType> createKey(String name) {
        return ResourceKey.create((ResourceKey)Registries.DAMAGE_TYPE, (ResourceLocation)VResourceLocation.mod(name));
    }

    static void createDamageTypes(BootstrapContext<DamageType> context) {
        context.register(SUN_DAMAGE, (Object)new DamageType("sun", 0.1f));
        context.register(VAMPIRE_ON_FIRE, (Object)new DamageType("vampire_on_fire", 0.1f, DamageEffects.BURNING));
        context.register(VAMPIRE_IN_FIRE, (Object)new DamageType("vampire_in_fire", 0.1f, DamageEffects.BURNING));
        context.register(HOLY_WATER, (Object)new DamageType("holy_water", 0.1f));
        context.register(NO_BLOOD, (Object)new DamageType("blood_loss", 0.0f));
        context.register(MINION, (Object)new DamageType("minion", DamageScaling.NEVER, 0.1f, DamageEffects.HURT, DeathMessageType.DEFAULT));
        context.register(DBNO, (Object)new DamageType("vampirism.dbno", DamageScaling.NEVER, 0.0f, DamageEffects.HURT, DeathMessageType.DEFAULT));
        context.register(MOTHER, (Object)new DamageType("vampirism.mother", DamageScaling.NEVER, 0.0f, DamageEffects.THORNS, DeathMessageType.DEFAULT));
        context.register(STAKE, (Object)new DamageType("vampirism.stake", DamageScaling.NEVER, 0.0f, DamageEffects.HURT, DeathMessageType.DEFAULT));
    }
}

