/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.vampirism.config;

import de.teamlapen.vampirism.VampirismMod;
import de.teamlapen.vampirism.api.VampirismAPI;
import de.teamlapen.vampirism.config.BalanceBuilder;
import de.teamlapen.vampirism.config.BalanceConfig;
import de.teamlapen.vampirism.config.ClientConfig;
import de.teamlapen.vampirism.config.CommonConfig;
import de.teamlapen.vampirism.config.ServerConfig;
import de.teamlapen.vampirism.entity.SundamageRegistry;
import java.util.function.Consumer;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.ModContainer;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.fml.config.IConfigSpec;
import net.neoforged.fml.config.ModConfig;
import net.neoforged.neoforge.common.ModConfigSpec;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@EventBusSubscriber(modid="vampirism", bus=EventBusSubscriber.Bus.MOD)
public class VampirismConfig {
    public static final Logger LOGGER = LogManager.getLogger();
    public static final ClientConfig CLIENT;
    public static final ServerConfig SERVER;
    public static final CommonConfig COMMON;
    @NotNull
    public static final BalanceConfig BALANCE;
    private static final ModConfigSpec clientSpec;
    private static final ModConfigSpec serverSpec;
    private static final ModConfigSpec commonSpec;
    private static ModConfigSpec balanceSpec;
    @Nullable
    private static BalanceBuilder balanceBuilder;

    public static boolean isClientConfigSpec(IConfigSpec specs) {
        return specs == clientSpec;
    }

    public static <T extends BalanceBuilder.Conf> void addBalanceModification(@NotNull String key, @NotNull Consumer<T> modifier) {
        if (balanceBuilder == null) {
            throw new IllegalStateException("Must add balance modifications during mod construction");
        }
        balanceBuilder.addBalanceModifier(key, modifier);
    }

    public static void buildBalanceConfig() {
        if (balanceBuilder == null) {
            return;
        }
        Pair specPair = new ModConfigSpec.Builder().configure(builder -> {
            builder.comment("A ton of options which allow you to balance the mod to your desire");
            builder.push("balance");
            balanceBuilder.build(BALANCE, (ModConfigSpec.Builder)builder);
            builder.pop();
            return BALANCE;
        });
        balanceSpec = (ModConfigSpec)specPair.getRight();
        if (VampirismMod.inDev) {
            balanceBuilder.checkFields(BALANCE);
        }
        balanceBuilder = null;
    }

    public static void register(ModContainer modContainer) {
        modContainer.registerConfig(ModConfig.Type.COMMON, (IConfigSpec)commonSpec);
        modContainer.registerConfig(ModConfig.Type.CLIENT, (IConfigSpec)clientSpec);
        modContainer.registerConfig(ModConfig.Type.SERVER, (IConfigSpec)serverSpec);
        modContainer.registerConfig(ModConfig.Type.SERVER, (IConfigSpec)balanceSpec, "vampirism-balance.toml");
    }

    @SubscribeEvent
    public static void onLoad(// Could not load outer class - annotation placement on inner may be incorrect
     @NotNull ModConfigEvent.Loading configEvent) {
        if (configEvent.getConfig().getType() == ModConfig.Type.SERVER) {
            ((SundamageRegistry)VampirismAPI.sundamageRegistry()).reloadConfiguration();
        } else if (configEvent.getConfig().getType() == ModConfig.Type.CLIENT && (Integer)VampirismConfig.CLIENT.guiLevelOffsetY.get() == 0) {
            VampirismConfig.CLIENT.guiLevelOffsetY.set((Object)47);
        }
    }

    @SubscribeEvent
    public static void onReload(// Could not load outer class - annotation placement on inner may be incorrect
     @NotNull ModConfigEvent.Reloading configEvent) {
        if (configEvent.getConfig().getType() == ModConfig.Type.SERVER) {
            ((SundamageRegistry)VampirismAPI.sundamageRegistry()).reloadConfiguration();
        }
    }

    public static boolean isBalanceSpec(ModConfigSpec spec) {
        return spec == balanceSpec;
    }

    static {
        Pair specPair = new ModConfigSpec.Builder().configure(ClientConfig::new);
        clientSpec = (ModConfigSpec)specPair.getRight();
        CLIENT = (ClientConfig)specPair.getLeft();
        specPair = new ModConfigSpec.Builder().configure(ServerConfig::new);
        serverSpec = (ModConfigSpec)specPair.getRight();
        SERVER = (ServerConfig)specPair.getLeft();
        specPair = new ModConfigSpec.Builder().configure(CommonConfig::new);
        commonSpec = (ModConfigSpec)specPair.getRight();
        COMMON = (CommonConfig)specPair.getLeft();
        balanceBuilder = new BalanceBuilder();
        BALANCE = new BalanceConfig(balanceBuilder);
    }
}

