/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.vampirism.command.test;

import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.builder.ArgumentBuilder;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import de.teamlapen.lib.lib.util.BasicCommand;
import de.teamlapen.vampirism.entity.factions.FactionPlayerHandler;
import java.util.Collection;
import java.util.Collections;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.arguments.EntityArgument;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import org.jetbrains.annotations.NotNull;

public class TaskCommand
extends BasicCommand {
    public static ArgumentBuilder<CommandSourceStack, ?> register() {
        return ((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal((String)"tasks").then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal((String)"clear").requires(context -> context.hasPermission(3))).executes(context -> TaskCommand.clearTasks(Collections.singleton(((CommandSourceStack)context.getSource()).getPlayerOrException())))).then(Commands.argument((String)"players", (ArgumentType)EntityArgument.players()).executes(context -> TaskCommand.clearTasks(EntityArgument.getPlayers((CommandContext)context, (String)"players")))))).then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal((String)"refreshTaskList").requires(context -> context.hasPermission(3))).executes(context -> TaskCommand.refreshTasksList(Collections.singleton(((CommandSourceStack)context.getSource()).getPlayerOrException())))).then(Commands.argument((String)"players", (ArgumentType)EntityArgument.players()).executes(context -> TaskCommand.refreshTasksList(EntityArgument.getPlayers((CommandContext)context, (String)"players")))))).then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal((String)"resetTaskList").requires(context -> context.hasPermission(3))).executes(context -> TaskCommand.resetTasksList(Collections.singleton(((CommandSourceStack)context.getSource()).getPlayerOrException())))).then(Commands.argument((String)"players", (ArgumentType)EntityArgument.players()).executes(context -> TaskCommand.resetTasksList(EntityArgument.getPlayers((CommandContext)context, (String)"players")))))).then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal((String)"resetLordTasks").requires(context -> context.hasPermission(3))).executes(context -> TaskCommand.resetLordTasks(Collections.singleton(((CommandSourceStack)context.getSource()).getPlayerOrException())))).then(Commands.argument((String)"players", (ArgumentType)EntityArgument.players()).executes(context -> TaskCommand.resetLordTasks(EntityArgument.getPlayers((CommandContext)context, (String)"players")))));
    }

    private static int refreshTasksList(@NotNull Collection<ServerPlayer> players) {
        for (ServerPlayer player : players) {
            FactionPlayerHandler.getCurrentFactionPlayer((Player)player).ifPresent(factionPlayer -> factionPlayer.getTaskManager().updateTaskLists());
        }
        return 0;
    }

    private static int resetTasksList(@NotNull Collection<ServerPlayer> players) {
        for (ServerPlayer player : players) {
            FactionPlayerHandler.getCurrentFactionPlayer((Player)player).ifPresent(factionPlayer -> factionPlayer.getTaskManager().resetTaskLists());
        }
        return 0;
    }

    private static int clearTasks(@NotNull Collection<ServerPlayer> players) {
        for (ServerPlayer player : players) {
            FactionPlayerHandler.getCurrentFactionPlayer((Player)player).ifPresent(factionPlayer -> factionPlayer.getTaskManager().reset());
        }
        return 0;
    }

    private static int resetLordTasks(@NotNull Collection<ServerPlayer> players) {
        for (ServerPlayer player : players) {
            FactionPlayerHandler handler = FactionPlayerHandler.get((Player)player);
            handler.resetLordTasks(handler.getLordLevel());
        }
        return 0;
    }
}

