/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.vampirism.command.test;

import com.google.common.collect.Lists;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.builder.ArgumentBuilder;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import de.teamlapen.lib.lib.util.BasicCommand;
import de.teamlapen.vampirism.api.entity.player.actions.IActionHandler;
import de.teamlapen.vampirism.entity.factions.FactionPlayerHandler;
import java.util.List;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.arguments.EntityArgument;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import org.jetbrains.annotations.NotNull;

public class ResetActionsCommand
extends BasicCommand {
    public static ArgumentBuilder<CommandSourceStack, ?> register() {
        return ((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal((String)"resetActions").requires(context -> context.hasPermission(3))).executes(context -> ResetActionsCommand.resetActions((CommandSourceStack)context.getSource(), Lists.newArrayList((Object[])new ServerPlayer[]{((CommandSourceStack)context.getSource()).getPlayerOrException()})))).then(Commands.argument((String)"players", (ArgumentType)EntityArgument.entities()).executes(context -> ResetActionsCommand.resetActions((CommandSourceStack)context.getSource(), Lists.newArrayList((Iterable)EntityArgument.getPlayers((CommandContext)context, (String)"players")))));
    }

    private static int resetActions(@NotNull CommandSourceStack commandSource, @NotNull List<ServerPlayer> players) {
        for (ServerPlayer player : players) {
            if (!player.isAlive()) continue;
            FactionPlayerHandler.getCurrentFactionPlayer((Player)player).ifPresent(factionPlayer -> {
                IActionHandler handler = factionPlayer.getActionHandler();
                if (handler != null) {
                    handler.resetTimers();
                    commandSource.sendSuccess(() -> Component.translatable((String)"command.vampirism.test.resetactions"), false);
                }
            });
        }
        return 0;
    }
}

