/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.vampirism.client.renderer.entity.layers;

import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.mojang.blaze3d.vertex.PoseStack;
import de.teamlapen.vampirism.client.renderer.entity.DualBipedRenderer;
import de.teamlapen.vampirism.entity.minion.MinionEntity;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import net.minecraft.client.Minecraft;
import net.minecraft.client.model.PlayerModel;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.layers.RenderLayer;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.client.resources.PlayerSkin;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.FastColor;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PlayerBodyOverlayLayer<T extends MinionEntity<?>, M extends VisibilityPlayerModel<T>>
extends RenderLayer<T, M> {
    public PlayerBodyOverlayLayer(@NotNull DualBipedRenderer<T, M> entityRendererIn) {
        super(entityRendererIn);
    }

    public void render(@NotNull PoseStack matrixStackIn, @NotNull MultiBufferSource bufferIn, int packedLightIn, @NotNull T entitylivingbaseIn, float limbSwing, float limbSwingAmount, float partialTicks, float ageInTicks, float netHeadYaw, float headPitch) {
        ResourceLocation texture = this.getTextureLocation((Entity)entitylivingbaseIn);
        RenderType type = ((VisibilityPlayerModel)this.getParentModel()).getRenderType((PlayerModel)this.getParentModel(), texture, entitylivingbaseIn);
        if (((MinionEntity)entitylivingbaseIn).shouldRenderLordSkin()) {
            if (type != null) {
                ((VisibilityPlayerModel)this.getParentModel()).setVisibility(VisibilityPlayerModel.Visibility.HEAD);
                ((VisibilityPlayerModel)this.getParentModel()).renderToBuffer(matrixStackIn, bufferIn.getBuffer(type), packedLightIn, OverlayTexture.NO_OVERLAY, FastColor.ARGB32.color((int)255, (int)255, (int)255, (int)255));
            }
            texture = ((MinionEntity)entitylivingbaseIn).getPlayerOverlay().map(s -> Minecraft.getInstance().getSkinManager().getInsecureSkin(s)).map(PlayerSkin::texture).orElse(texture);
            RenderType bodyType = ((VisibilityPlayerModel)this.getParentModel()).getRenderType((PlayerModel)this.getParentModel(), texture, entitylivingbaseIn);
            if (bodyType != null) {
                ((VisibilityPlayerModel)this.getParentModel()).setVisibility(VisibilityPlayerModel.Visibility.BODY);
                ((VisibilityPlayerModel)this.getParentModel()).renderToBuffer(matrixStackIn, bufferIn.getBuffer(bodyType), packedLightIn, OverlayTexture.NO_OVERLAY, FastColor.ARGB32.color((int)255, (int)255, (int)255, (int)255));
            }
        } else if (type != null) {
            ((VisibilityPlayerModel)this.getParentModel()).setVisibility(VisibilityPlayerModel.Visibility.ALL);
            ((VisibilityPlayerModel)this.getParentModel()).renderToBuffer(matrixStackIn, bufferIn.getBuffer(type), packedLightIn, OverlayTexture.NO_OVERLAY, FastColor.ARGB32.color((int)255, (int)255, (int)255, (int)255));
        }
        ((VisibilityPlayerModel)this.getParentModel()).setVisibility(VisibilityPlayerModel.Visibility.NONE);
    }

    public static class VisibilityPlayerModel<T extends MinionEntity<?>>
    extends PlayerModel<T> {
        @NotNull
        private Visibility visibility = Visibility.NONE;
        @NotNull
        private final Collection<ModelPart> hatList = Collections.singleton(this.hat);

        public VisibilityPlayerModel(ModelPart pRoot, boolean pSlim) {
            super(pRoot, pSlim);
        }

        @NotNull
        protected Iterable<ModelPart> headParts() {
            if (this.visibility.head) {
                return Iterables.concat((Iterable)super.headParts(), this.hatList);
            }
            return Collections.emptyList();
        }

        @NotNull
        protected Iterable<ModelPart> bodyParts() {
            if (this.visibility.body) {
                ArrayList parts = Lists.newArrayList((Iterable)super.bodyParts());
                parts.remove(this.hat);
                return parts;
            }
            return Collections.emptyList();
        }

        public void setVisibility(@NotNull Visibility type) {
            this.visibility = type;
        }

        @Nullable
        public RenderType getRenderType(PlayerModel<T> model, ResourceLocation location, T entity) {
            Minecraft minecraft = Minecraft.getInstance();
            boolean pBodyVisible = !entity.isInvisible();
            boolean translucent = !pBodyVisible && !entity.isInvisibleTo((Player)minecraft.player);
            boolean flag2 = minecraft.shouldEntityAppearGlowing(entity);
            if (translucent) {
                return RenderType.itemEntityTranslucentCull((ResourceLocation)location);
            }
            if (pBodyVisible) {
                return model.renderType(location);
            }
            return flag2 ? RenderType.outline((ResourceLocation)location) : null;
        }

        public static enum Visibility {
            HEAD(true, false),
            BODY(false, true),
            NONE(false, false),
            ALL(true, true);

            private final boolean head;
            private final boolean body;

            private Visibility(boolean head, boolean body) {
                this.head = head;
                this.body = body;
            }
        }
    }
}

