/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.vampirism.client.renderer.entity;

import com.mojang.blaze3d.vertex.PoseStack;
import de.teamlapen.vampirism.api.util.VResourceLocation;
import de.teamlapen.vampirism.client.core.ModEntitiesRender;
import de.teamlapen.vampirism.client.renderer.entity.layers.TaskMasterTypeLayer;
import de.teamlapen.vampirism.client.renderer.entity.layers.VampireEntityLayer;
import de.teamlapen.vampirism.entity.vampire.VampireTaskMasterEntity;
import de.teamlapen.vampirism.util.Helper;
import net.minecraft.client.Minecraft;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.model.VillagerModel;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.entity.MobRenderer;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.player.Player;
import org.jetbrains.annotations.NotNull;

public class VampireTaskMasterRenderer
extends MobRenderer<VampireTaskMasterEntity, VillagerModel<VampireTaskMasterEntity>> {
    private static final ResourceLocation texture = VResourceLocation.mc("textures/entity/villager/villager.png");
    private static final ResourceLocation vampireOverlay = VResourceLocation.mod("textures/entity/vanilla/villager_overlay.png");
    private static final ResourceLocation overlay = VResourceLocation.mod("textures/entity/vampire_task_master_overlay.png");

    public VampireTaskMasterRenderer(// Could not load outer class - annotation placement on inner may be incorrect
     @NotNull EntityRendererProvider.Context context) {
        super(context, (EntityModel)new VillagerModel(context.bakeLayer(ModEntitiesRender.TASK_MASTER)), 0.5f);
        this.addLayer(new VampireEntityLayer(this, vampireOverlay));
        this.addLayer(new TaskMasterTypeLayer(this, overlay));
    }

    @NotNull
    public ResourceLocation getTextureLocation(@NotNull VampireTaskMasterEntity entity) {
        return texture;
    }

    protected void renderNameTag(@NotNull VampireTaskMasterEntity entityIn, @NotNull Component displayNameIn, @NotNull PoseStack matrixStackIn, @NotNull MultiBufferSource bufferIn, int packedLightIn, float partialTicks) {
        double dist = this.entityRenderDispatcher.distanceToSqr((Entity)entityIn);
        if (dist <= 128.0) {
            super.renderNameTag((Entity)entityIn, displayNameIn, matrixStackIn, bufferIn, packedLightIn, (float)packedLightIn);
        }
    }

    protected boolean shouldShowName(@NotNull VampireTaskMasterEntity pEntity) {
        return Helper.isVampire((Player)Minecraft.getInstance().player) && super.shouldShowName((Mob)pEntity);
    }
}

