/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.vampirism.client.renderer.entity;

import com.mojang.blaze3d.vertex.PoseStack;
import de.teamlapen.vampirism.client.core.ModEntitiesRender;
import de.teamlapen.vampirism.client.renderer.entity.DualBipedRenderer;
import de.teamlapen.vampirism.client.renderer.entity.layers.PlayerBodyOverlayLayer;
import de.teamlapen.vampirism.entity.minion.VampireMinionEntity;
import net.minecraft.client.model.HumanoidModel;
import net.minecraft.client.renderer.entity.RenderLayerParent;
import net.minecraft.client.renderer.entity.layers.HumanoidArmorLayer;
import net.minecraft.client.renderer.entity.layers.RenderLayer;
import net.minecraft.client.resources.PlayerSkin;
import org.jetbrains.annotations.NotNull;

public class VampireMinionRenderer
extends DualBipedRenderer<VampireMinionEntity, PlayerBodyOverlayLayer.VisibilityPlayerModel<VampireMinionEntity>> {
    private final PlayerSkin @NotNull [] textures = this.gatherTextures("textures/entity/vampire", true);
    private final PlayerSkin @NotNull [] minionSpecificTextures = this.gatherTextures("textures/entity/minion/vampire", false);

    public VampireMinionRenderer(// Could not load outer class - annotation placement on inner may be incorrect
     @NotNull EntityRendererProvider.Context context) {
        super(context, new PlayerBodyOverlayLayer.VisibilityPlayerModel(context.bakeLayer(ModEntitiesRender.GENERIC_BIPED), false), new PlayerBodyOverlayLayer.VisibilityPlayerModel(context.bakeLayer(ModEntitiesRender.GENERIC_BIPED_SLIM), true), 0.5f);
        this.addLayer(new PlayerBodyOverlayLayer<VampireMinionEntity, PlayerBodyOverlayLayer.VisibilityPlayerModel<VampireMinionEntity>>(this));
        this.addLayer((RenderLayer)new HumanoidArmorLayer((RenderLayerParent)this, new HumanoidModel(context.bakeLayer(ModEntitiesRender.GENERIC_BIPED_ARMOR_INNER)), new HumanoidModel(context.bakeLayer(ModEntitiesRender.GENERIC_BIPED_ARMOR_OUTER)), context.getModelManager()));
    }

    public int getMinionSpecificTextureCount() {
        return this.minionSpecificTextures.length;
    }

    public int getVampireTextureCount() {
        return this.textures.length;
    }

    @Override
    protected PlayerSkin determineTextureAndModel(@NotNull VampireMinionEntity entity) {
        return entity.hasMinionSpecificSkin() && this.minionSpecificTextures.length > 0 ? this.minionSpecificTextures[entity.getVampireType() % this.minionSpecificTextures.length] : this.textures[entity.getVampireType() % this.textures.length];
    }

    protected void scale(@NotNull VampireMinionEntity entityIn, @NotNull PoseStack matrixStackIn, float partialTickTime) {
        float s = entityIn.getScale();
        matrixStackIn.scale(s, s, s);
    }
}

