/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.vampirism.client.particle;

import de.teamlapen.vampirism.mixin.client.accessor.ParticleEngineAccessor;
import de.teamlapen.vampirism.particle.GenericParticleOptions;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.particle.ParticleProvider;
import net.minecraft.client.particle.ParticleRenderType;
import net.minecraft.client.particle.TextureSheetParticle;
import net.minecraft.resources.ResourceLocation;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GenericParticle
extends TextureSheetParticle {
    private GenericParticle(@NotNull ClientLevel world, double posX, double posY, double posZ, double speedX, double speedY, double speedZ, @NotNull ResourceLocation texture, int maxAge, int color, float speedModifier) {
        super(world, posX, posY, posZ, speedX, speedY, speedZ);
        this.lifetime = maxAge;
        this.xd *= (double)speedModifier;
        this.yd *= (double)speedModifier;
        this.zd *= (double)speedModifier;
        this.rCol = (float)(color >> 16 & 0xFF) / 255.0f;
        this.bCol = (float)(color & 0xFF) / 255.0f;
        this.gCol = (float)(color >> 8 & 0xFF) / 255.0f;
        if ((color >> 24 & 0xFF) != 0) {
            this.alpha = (float)(color >> 24 & 0xFF) / 255.0f;
        }
        this.setSprite(((ParticleEngineAccessor)Minecraft.getInstance().particleEngine).getTextureAtlas().getSprite(texture));
    }

    @NotNull
    public ParticleRenderType getRenderType() {
        return ParticleRenderType.PARTICLE_SHEET_OPAQUE;
    }

    @OnlyIn(value=Dist.CLIENT)
    public static class Factory
    implements ParticleProvider<GenericParticleOptions> {
        @Nullable
        public Particle createParticle(@NotNull GenericParticleOptions typeIn, @NotNull ClientLevel worldIn, double x, double y, double z, double xSpeed, double ySpeed, double zSpeed) {
            return new GenericParticle(worldIn, x, y, z, xSpeed, ySpeed, zSpeed, typeIn.texture(), typeIn.maxAge(), typeIn.color(), typeIn.speed());
        }
    }
}

