/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.vampirism.client.model.blocks;

import de.teamlapen.vampirism.blockentity.AltarInspirationBlockEntity;
import java.util.LinkedList;
import java.util.List;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.block.model.ItemOverrides;
import net.minecraft.client.renderer.block.model.ItemTransforms;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.core.Direction;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.neoforge.client.ChunkRenderTypeSet;
import net.neoforged.neoforge.client.model.IDynamicBakedModel;
import net.neoforged.neoforge.client.model.data.ModelData;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class BakedAltarInspirationModel
implements IDynamicBakedModel {
    public static final int FLUID_LEVELS = 10;
    public static final BakedModel[] FLUID_MODELS = new BakedModel[10];
    private final BakedModel baseModel;

    public BakedAltarInspirationModel(BakedModel baseModel) {
        this.baseModel = baseModel;
    }

    @NotNull
    public TextureAtlasSprite getParticleIcon() {
        return this.baseModel.getParticleIcon();
    }

    @NotNull
    public ItemOverrides getOverrides() {
        return this.baseModel.getOverrides();
    }

    @NotNull
    public ItemTransforms getTransforms() {
        return this.baseModel.getTransforms();
    }

    @NotNull
    public List<BakedQuad> getQuads(@Nullable BlockState state, @Nullable Direction side, @NotNull RandomSource rand, @NotNull ModelData extraData, @Nullable RenderType renderType) {
        LinkedList<BakedQuad> quads = new LinkedList<BakedQuad>(this.baseModel.getQuads(state, side, rand, ModelData.EMPTY, renderType));
        Integer level = (Integer)extraData.get(AltarInspirationBlockEntity.FLUID_LEVEL_PROP);
        if (level != null && level > 0 && level <= 10) {
            quads.addAll(FLUID_MODELS[level - 1].getQuads(state, side, rand, ModelData.EMPTY, renderType));
        }
        return quads;
    }

    public boolean isCustomRenderer() {
        return this.baseModel.isCustomRenderer();
    }

    public boolean useAmbientOcclusion() {
        return this.baseModel.useAmbientOcclusion();
    }

    public boolean isGui3d() {
        return this.baseModel.isGui3d();
    }

    public boolean usesBlockLight() {
        return this.baseModel.usesBlockLight();
    }

    @NotNull
    public ChunkRenderTypeSet getRenderTypes(@NotNull BlockState state, @NotNull RandomSource rand, @NotNull ModelData data) {
        return this.baseModel.getRenderTypes(state, rand, data);
    }
}

