/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.vampirism.client.model;

import com.mojang.blaze3d.vertex.PoseStack;
import net.minecraft.client.model.ArmedModel;
import net.minecraft.client.model.VillagerModel;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.HumanoidArm;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import org.jetbrains.annotations.NotNull;

public class VillagerWithArmsModel<T extends Mob>
extends VillagerModel<T>
implements ArmedModel {
    private static final String RIGHT_ARM = "right_arm";
    private static final String LEFT_ARM = "left_arm";
    @NotNull
    private final ModelPart leftArm;
    @NotNull
    private final ModelPart rightArm;

    @NotNull
    public static LayerDefinition createLayer(float scale) {
        MeshDefinition mesh = VillagerModel.createBodyModel();
        PartDefinition root = mesh.getRoot();
        CubeDeformation def = new CubeDeformation(scale);
        root.addOrReplaceChild(RIGHT_ARM, CubeListBuilder.create().texOffs(44, 22).addBox(-4.0f, -2.0f, -2.0f, 4.0f, 8.0f, 4.0f, def).addBox(-4.0f, 6.0f, -2.0f, 4.0f, 3.0f, 4.0f, def), PartPose.offset((float)0.0f, (float)2.0f, (float)0.0f));
        root.addOrReplaceChild(LEFT_ARM, CubeListBuilder.create().texOffs(44, 22).mirror().addBox(0.0f, -2.0f, -2.0f, 4.0f, 8.0f, 4.0f, def).addBox(0.0f, 6.0f, -2.0f, 4.0f, 3.0f, 4.0f, def), PartPose.offset((float)-5.0f, (float)2.0f, (float)0.0f));
        return LayerDefinition.create((MeshDefinition)mesh, (int)64, (int)64);
    }

    public VillagerWithArmsModel(@NotNull ModelPart part) {
        super(part);
        this.leftArm = part.getChild(LEFT_ARM);
        this.rightArm = part.getChild(RIGHT_ARM);
    }

    public void setupAnim(@NotNull T entityIn, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
        super.setupAnim(entityIn, limbSwing, limbSwingAmount, ageInTicks, netHeadYaw, headPitch);
        this.leftArm.setPos(4.0f, 3.0f, -1.0f);
        this.rightArm.setPos(-4.0f, 3.0f, -1.0f);
        this.leftArm.xRot = -0.75f;
        this.rightArm.xRot = -0.75f;
        if (this.attackTime > 0.0f) {
            HumanoidArm enumhandside = this.getMainHand((Entity)entityIn);
            ModelPart modelrenderer = this.getArmForSide(enumhandside);
            float f1 = 1.0f - this.attackTime;
            f1 *= f1;
            f1 *= f1;
            f1 = 1.0f - f1;
            float f2 = Mth.sin((float)(f1 * (float)Math.PI));
            float f3 = Mth.sin((float)(this.attackTime * (float)Math.PI)) * -(this.getHead().xRot - 0.7f) * 0.75f;
            modelrenderer.xRot = (float)((double)modelrenderer.xRot - ((double)f2 * 1.2 + (double)f3));
        }
    }

    public void translateToHand(@NotNull HumanoidArm handSide, @NotNull PoseStack matrixStack) {
        float f = handSide == HumanoidArm.RIGHT ? 1.0f : -1.0f;
        ModelPart arm = this.getArmForSide(handSide);
        arm.x += f;
        arm.translateAndRotate(matrixStack);
        arm.x -= f;
    }

    protected ModelPart getArmForSide(HumanoidArm side) {
        return side == HumanoidArm.LEFT ? this.leftArm : this.rightArm;
    }

    @NotNull
    protected HumanoidArm getMainHand(Entity entityIn) {
        return entityIn instanceof LivingEntity ? ((LivingEntity)entityIn).getMainArm() : HumanoidArm.RIGHT;
    }
}

