/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.vampirism.client.model;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import de.teamlapen.vampirism.entity.GhostEntity;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.util.FastColor;
import net.minecraft.util.Mth;
import org.jetbrains.annotations.NotNull;

public class GhostModel
extends EntityModel<GhostEntity> {
    private static final String HEAD = "head";
    private static final String BODY = "body";
    private static final String RIGHT_ARM = "right_arm";
    private static final String LEFT_ARM = "left_arm";
    private final ModelPart head;
    private final ModelPart body;
    private final ModelPart right_arm;
    private final ModelPart left_arm;
    private boolean isAggressive;

    public static LayerDefinition createMesh() {
        MeshDefinition meshdefinition = new MeshDefinition();
        PartDefinition partdefinition = meshdefinition.getRoot();
        PartDefinition body = partdefinition.addOrReplaceChild(BODY, CubeListBuilder.create().texOffs(0, 12).addBox(-2.0f, -3.0f, -2.0f, 4.0f, 10.0f, 4.0f, new CubeDeformation(0.0f)), PartPose.offset((float)0.0f, (float)17.0f, (float)0.0f));
        PartDefinition head = body.addOrReplaceChild(HEAD, CubeListBuilder.create().texOffs(0, 0).addBox(-3.0f, -6.0f, -3.0f, 6.0f, 6.0f, 6.0f, new CubeDeformation(0.0f)), PartPose.offset((float)0.0f, (float)-4.0f, (float)0.0f));
        PartDefinition arm_left = body.addOrReplaceChild(LEFT_ARM, CubeListBuilder.create().texOffs(16, 12).addBox(-2.0f, 0.0f, -1.0f, 2.0f, 9.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)-2.0f, (float)-3.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)0.1745f));
        PartDefinition arm_right = body.addOrReplaceChild(RIGHT_ARM, CubeListBuilder.create().texOffs(24, 12).addBox(0.0f, 0.0f, -1.0f, 2.0f, 9.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)2.0f, (float)-3.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)-0.1745f));
        return LayerDefinition.create((MeshDefinition)meshdefinition, (int)64, (int)64);
    }

    public GhostModel(@NotNull ModelPart part) {
        this.body = part.getChild(BODY);
        this.head = this.body.getChild(HEAD);
        this.right_arm = this.body.getChild(RIGHT_ARM);
        this.left_arm = this.body.getChild(LEFT_ARM);
    }

    public void setupAnim(@NotNull GhostEntity pEntity, float pLimbSwing, float pLimbSwingAmount, float pAgeInTicks, float pNetHeadYaw, float pHeadPitch) {
        this.body.getAllParts().forEach(ModelPart::resetPose);
        this.head.yRot = pNetHeadYaw / 57.295776f;
        this.head.xRot = pHeadPitch / 57.295776f;
        this.isAggressive = pEntity.isAggressive();
        if (pEntity.isAggressive()) {
            float f6 = Mth.sin((float)(pLimbSwingAmount * (float)Math.PI));
            float f7 = Mth.sin((float)((1.0f - (1.0f - pLimbSwingAmount) * (1.0f - pLimbSwingAmount)) * (float)Math.PI));
            this.right_arm.yRot = -(0.1f - f6 * 0.6f);
            this.left_arm.yRot = 0.1f - f6 * 0.6f;
            this.right_arm.xRot = -1.5707964f;
            this.left_arm.xRot = -1.5707964f;
            this.right_arm.xRot -= f6 * 1.2f - f7 * 0.4f;
            this.left_arm.xRot -= f6 * 1.2f - f7 * 0.4f;
            this.right_arm.zRot += Mth.cos((float)(pLimbSwing * 0.09f)) * 0.05f + 0.05f;
            this.left_arm.zRot -= Mth.cos((float)(pLimbSwing * 0.09f)) * 0.05f + 0.05f;
            this.right_arm.xRot += Mth.sin((float)(pLimbSwing * 0.067f)) * 0.05f;
            this.left_arm.xRot -= Mth.sin((float)(pLimbSwing * 0.067f)) * 0.05f;
        }
        float f3 = pAgeInTicks * 5.0f * ((float)Math.PI / 180);
        float f4 = Math.min(pLimbSwingAmount / 0.3f, 1.0f);
        float f5 = 1.0f - f4;
        this.body.y += (float)Math.cos(f3) * 0.25f * f5;
    }

    public void setupAnim2(float pAgeInTicks) {
        this.body.getAllParts().forEach(ModelPart::resetPose);
        float f3 = pAgeInTicks * 5.0f * ((float)Math.PI / 180);
        this.body.y += (float)Math.cos(f3) * 0.25f;
    }

    public void renderToBuffer(@NotNull PoseStack pPoseStack, @NotNull VertexConsumer pBuffer, int pPackedLight, int pPackedOverlay, int color) {
        if (!this.isAggressive) {
            int pAlpha = (int)((float)FastColor.ARGB32.alpha((int)color) * 0.5f);
            color = pAlpha << 24 | color;
        }
        pPoseStack.pushPose();
        pPoseStack.scale(0.5f, 0.5f, 0.5f);
        pPoseStack.translate(0.0f, 1.5f, 0.0f);
        this.body.render(pPoseStack, pBuffer, pPackedLight, pPackedOverlay, color);
        pPoseStack.popPose();
    }
}

