/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.vampirism.client.model;

import de.teamlapen.vampirism.client.model.BipedCloakedModel;
import net.minecraft.client.model.HumanoidModel;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.HumanoidArm;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.CrossbowItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.UseAnim;
import net.neoforged.neoforge.client.extensions.common.IClientItemExtensions;
import org.jetbrains.annotations.NotNull;

public class BasicHunterModel<T extends LivingEntity>
extends BipedCloakedModel<T> {
    @NotNull
    public static LayerDefinition createBodyLayer() {
        return LayerDefinition.create((MeshDefinition)BipedCloakedModel.createMesh(false), (int)64, (int)64);
    }

    @NotNull
    public static LayerDefinition createSlimBodyLayer() {
        return LayerDefinition.create((MeshDefinition)BipedCloakedModel.createMesh(true), (int)64, (int)64);
    }

    public BasicHunterModel(ModelPart part, boolean smallArms) {
        super(part, smallArms);
    }

    @Override
    public void setupAnim(@NotNull T entityIn, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
        super.setupAnim(entityIn, limbSwing, limbSwingAmount, ageInTicks, netHeadYaw, headPitch);
        HumanoidModel.ArmPose mainPose = BasicHunterModel.getArmPose(entityIn, InteractionHand.MAIN_HAND);
        HumanoidModel.ArmPose offPose = BasicHunterModel.getArmPose(entityIn, InteractionHand.OFF_HAND);
        if (entityIn.getMainArm() == HumanoidArm.RIGHT) {
            this.rightArmPose = mainPose;
            this.leftArmPose = offPose;
        }
        if (entityIn.getMainArm() == HumanoidArm.LEFT) {
            this.rightArmPose = offPose;
            this.leftArmPose = mainPose;
        }
    }

    private static HumanoidModel.ArmPose getArmPose(LivingEntity entity, InteractionHand pHand) {
        HumanoidModel.ArmPose forgeArmPose;
        ItemStack itemstack = entity.getItemInHand(pHand);
        if (itemstack.isEmpty()) {
            return HumanoidModel.ArmPose.EMPTY;
        }
        if (entity.getUsedItemHand() == pHand && entity.getUseItemRemainingTicks() > 0) {
            UseAnim useanim = itemstack.getUseAnimation();
            if (useanim == UseAnim.CROSSBOW && pHand == entity.getUsedItemHand()) {
                return HumanoidModel.ArmPose.CROSSBOW_CHARGE;
            }
        } else if (!entity.swinging && itemstack.getItem() instanceof CrossbowItem && CrossbowItem.isCharged((ItemStack)itemstack)) {
            return HumanoidModel.ArmPose.CROSSBOW_HOLD;
        }
        if ((forgeArmPose = IClientItemExtensions.of((ItemStack)itemstack).getArmPose(entity, pHand, itemstack)) != null) {
            return forgeArmPose;
        }
        return HumanoidModel.ArmPose.ITEM;
    }
}

