/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.vampirism.client.gui.screens;

import de.teamlapen.vampirism.api.util.VResourceLocation;
import java.awt.Color;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.inventory.PageButton;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.FormattedCharSequence;
import net.minecraft.util.Mth;
import org.jetbrains.annotations.NotNull;

public class VampireBookScreen
extends Screen {
    private static final ResourceLocation pageTexture = VResourceLocation.mod("textures/gui/vampire_book.png");
    private final int xSize = 245;
    private final int ySize = 192;
    private int guiLeft;
    private int guiTop;
    private PageButton buttonNext;
    private PageButton buttonPrev;
    private int pageNumber;
    private final  @NotNull VampireBookManager.BookInfo info;
    private List<FormattedText> content;

    public VampireBookScreen( @NotNull VampireBookManager.BookInfo info) {
        super((Component)Component.literal((String)info.title()));
        this.info = info;
    }

    public void render(GuiGraphics graphics, int mouseX, int mouseY, float partialTicks) {
        super.render(graphics, mouseX, mouseY, partialTicks);
        this.pageNumber = Mth.clamp((int)this.pageNumber, (int)0, (int)(this.content.size() - 1));
        if (this.pageNumber < this.content.size()) {
            FormattedText toDraw = this.content.get(this.pageNumber);
            Font fontRenderer = Minecraft.getInstance().font;
            List cutLines = fontRenderer.split(toDraw, 170);
            int y = this.guiTop + 12 + 5;
            for (FormattedCharSequence cut : cutLines) {
                graphics.drawString(fontRenderer, cut, this.guiLeft + 44, y, 0, false);
                y += 10;
            }
        }
        VampireBookScreen.drawCenteredStringWithoutShadow(graphics, this.font, String.format("%d/%d", this.pageNumber + 1, this.content.size()), this.guiLeft + 122, this.guiTop + 160, 0);
        graphics.drawCenteredString(this.font, this.title, this.guiLeft + 122, this.guiTop - 10, Color.WHITE.getRGB());
        this.buttonPrev.visible = this.pageNumber != 0;
        this.buttonNext.visible = this.pageNumber != this.content.size() - 1 && !this.content.isEmpty();
    }

    public void renderBackground(GuiGraphics pGuiGraphics, int pMouseX, int pMouseY, float pPartialTick) {
        super.renderBackground(pGuiGraphics, pMouseX, pMouseY, pPartialTick);
        pGuiGraphics.blit(pageTexture, this.guiLeft, this.guiTop, 0, 0, 245, 192);
    }

    protected void init() {
        super.init();
        this.guiLeft = (this.width - this.xSize) / 2;
        this.guiTop = (this.height - this.ySize) / 2;
        this.buttonNext = new PageButton(this.guiLeft + 163, this.guiTop + 160, true, btn -> {
            if (this.pageNumber + 1 < this.content.size()) {
                this.nextPage();
            }
        }, true);
        this.addRenderableWidget((GuiEventListener)this.buttonNext);
        this.buttonPrev = new PageButton(this.guiLeft + 49, this.guiTop + 160, false, btn -> {
            if (this.pageNumber > 0) {
                this.prevPage();
            }
        }, true);
        this.addRenderableWidget((GuiEventListener)this.buttonPrev);
        this.content = Arrays.stream(this.info.content()).map(Component::literal).flatMap(v -> VampireBookScreen.prepareForLongText((Component)v, 164, 120, 120).stream()).collect(Collectors.toList());
    }

    public static void drawCenteredStringWithoutShadow(@NotNull GuiGraphics graphics, @NotNull Font p_238471_1_, @NotNull String p_238471_2_, int p_238471_3_, int p_238471_4_, int p_238471_5_) {
        graphics.drawString(p_238471_1_, p_238471_2_, p_238471_3_ - p_238471_1_.width(p_238471_2_) / 2, p_238471_4_, p_238471_5_, false);
    }

    public boolean keyPressed(int keyCode, int p_keyPressed_2_, int p_keyPressed_3_) {
        if (keyCode == 259 || keyCode == this.minecraft.options.keyUse.getKey().getValue()) {
            this.minecraft.setScreen(null);
            return true;
        }
        if ((keyCode == 265 || keyCode == 262) && this.pageNumber + 1 < this.content.size()) {
            this.nextPage();
            return true;
        }
        if ((keyCode == 264 || keyCode == 263) && this.pageNumber > 0) {
            this.prevPage();
            return true;
        }
        return super.keyPressed(keyCode, p_keyPressed_2_, p_keyPressed_3_);
    }

    public boolean mouseScrolled(double pMouseX, double pMouseY, double pScrollX, double pScrollY) {
        if (pScrollY < 0.0) {
            this.nextPage();
        } else if (pScrollY > 0.0) {
            this.prevPage();
        }
        if (pScrollX < 0.0) {
            this.nextPage();
        } else if (pScrollX > 0.0) {
            this.prevPage();
        }
        return pScrollX != 0.0 || pScrollY != 0.0 || super.mouseScrolled(pMouseX, pMouseY, pScrollX, pScrollY);
    }

    public void nextPage() {
        if (this.pageNumber != this.content.size() - 1 && !this.content.isEmpty()) {
            ++this.pageNumber;
        }
    }

    public void prevPage() {
        if (this.pageNumber != 0) {
            --this.pageNumber;
        }
    }

    @NotNull
    private static List<FormattedText> prepareForLongText(@NotNull Component text, int lineWidth, int firstHeight, int subsequentHeight) {
        Font fontRenderer = Minecraft.getInstance().font;
        Objects.requireNonNull(fontRenderer);
        int firstCount = firstHeight / 9;
        Objects.requireNonNull(fontRenderer);
        int count = subsequentHeight / 9;
        ArrayList<FormattedText> lines = new ArrayList<FormattedText>(fontRenderer.getSplitter().splitLines((FormattedText)text, lineWidth, Style.EMPTY));
        ArrayList<FormattedText> pages = new ArrayList<FormattedText>();
        ArrayList<FormattedText> pageLines = lines.size() > firstCount ? lines.subList(0, firstCount) : lines;
        pages.add(VampireBookScreen.combineWithNewLine(pageLines));
        pageLines.clear();
        while (!lines.isEmpty()) {
            pageLines = lines.size() > count ? lines.subList(0, count) : lines;
            pages.add(VampireBookScreen.combineWithNewLine(pageLines));
            pageLines.clear();
        }
        return pages;
    }

    @NotNull
    private static FormattedText combineWithNewLine(@NotNull List<FormattedText> elements) {
        MutableComponent newLine = Component.literal((String)"\n");
        ArrayList<Object> copy = new ArrayList<Object>(elements.size() * 2);
        for (int i = 0; i < elements.size() - 1; ++i) {
            copy.add(elements.get(i));
            copy.add(newLine);
        }
        copy.add(elements.getLast());
        return FormattedText.composite(copy);
    }
}

