/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.vampirism.client.gui.screens;

import de.teamlapen.lib.lib.client.gui.components.SimpleList;
import de.teamlapen.vampirism.api.entity.minion.IMinionTask;
import de.teamlapen.vampirism.api.util.VResourceLocation;
import de.teamlapen.vampirism.inventory.MinionContainer;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.ImageButton;
import net.minecraft.client.gui.components.LockIconButton;
import net.minecraft.client.gui.components.WidgetSprites;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.neoforged.neoforge.client.gui.widget.ExtendedButton;
import org.jetbrains.annotations.NotNull;

public class MinionScreen
extends AbstractContainerScreen<MinionContainer> {
    private static final ResourceLocation BACKGROUND = VResourceLocation.mod("textures/gui/container/minion_inventory.png");
    private static final ResourceLocation LOCKED_SPRITE = VResourceLocation.mod("container/minion_inventory/locked");
    private static final WidgetSprites APPEARANCE_SPRITES = new WidgetSprites(VResourceLocation.mod("widget/settings"), VResourceLocation.mod("widget/settings_highlighted"));
    private static final WidgetSprites STATS_SPRITES = new WidgetSprites(VResourceLocation.mod("widget/skill_points"), VResourceLocation.mod("widget/skill_points_highlighted"));
    private final int extraSlots;
    private SimpleList<?> taskList;
    private Button taskButton;
    private Button appearanceButton;
    private Button statButton;
    private LockIconButton lockActionButton;

    public MinionScreen(@NotNull MinionContainer screenContainer, @NotNull Inventory inv, @NotNull Component titleIn) {
        super((AbstractContainerMenu)Objects.requireNonNull(screenContainer), inv, titleIn);
        this.imageWidth = 214;
        this.imageHeight = 185;
        this.extraSlots = screenContainer.getExtraSlots();
    }

    public boolean mouseDragged(double p_mouseDragged_1_, double p_mouseDragged_3_, int p_mouseDragged_5_, double p_mouseDragged_6_, double p_mouseDragged_8_) {
        this.taskList.mouseDragged(p_mouseDragged_1_, p_mouseDragged_3_, p_mouseDragged_5_, p_mouseDragged_6_, p_mouseDragged_8_);
        return super.mouseDragged(p_mouseDragged_1_, p_mouseDragged_3_, p_mouseDragged_5_, p_mouseDragged_6_, p_mouseDragged_8_);
    }

    public void render(@NotNull GuiGraphics graphics, int mouseX, int mouseY, float partialTicks) {
        super.render(graphics, mouseX, mouseY, partialTicks);
        this.renderTooltip(graphics, mouseX, mouseY);
    }

    protected void init() {
        super.init();
        this.appearanceButton = (Button)this.addRenderableWidget((GuiEventListener)new ImageButton(this.leftPos + 6, this.topPos + 21, 18, 18, APPEARANCE_SPRITES, this::onConfigurePressed));
        this.lockActionButton = (LockIconButton)this.addRenderableWidget((GuiEventListener)new LockIconButton(this.leftPos + 99, this.topPos + 19, this::toggleActionLock));
        this.statButton = (Button)this.addRenderableWidget((GuiEventListener)new ImageButton(this.leftPos + 6, this.topPos + 40, 18, 18, STATS_SPRITES, this::onStatsPressed));
        this.lockActionButton.setLocked(((MinionContainer)this.menu).isTaskLocked());
        List<Component> taskNames = Arrays.stream(((MinionContainer)this.menu).getAvailableTasks()).map(IMinionTask::getName).toList();
        this.taskList = (SimpleList)this.addRenderableWidget((GuiEventListener)SimpleList.builder(this.leftPos + 119, this.topPos + 19 + 19, 88, Math.min(54, taskNames.size() * 18) + 2).componentsWithClick(taskNames, this::selectTask).build());
        this.taskButton = (Button)this.addRenderableWidget((GuiEventListener)new ExtendedButton(this.leftPos + 119, this.topPos + 19, 88, 20, this.getActiveTaskName(), button -> {
            this.taskList.visible = !this.taskList.visible;
        }));
        this.taskList.visible = false;
    }

    protected void renderBg(@NotNull GuiGraphics graphics, float partialTicks, int mouseX, int mouseY) {
        graphics.setColor(1.0f, 1.0f, 1.0f, 1.0f);
        int i = (this.width - this.imageWidth) / 2;
        int j = (this.height - this.imageHeight) / 2;
        graphics.blit(BACKGROUND, i, j, 0, 0, this.imageWidth, this.imageHeight);
        for (int k = this.extraSlots; k < 15; ++k) {
            graphics.blitSprite(LOCKED_SPRITE, i + 29 + 18 * (k / 3), j + 44 + 18 * (k % 3), 13, 13);
        }
    }

    protected void renderLabels(@NotNull GuiGraphics graphics, int mouseX, int mouseY) {
        graphics.drawString(this.font, this.title, 5, 6, 0x404040, false);
        graphics.drawString(this.font, (Component)Component.translatable((String)"gui.vampirism.minion.active_task"), 120, 10, 0x404040, false);
    }

    protected void renderTooltip(@NotNull GuiGraphics graphics, int mouseX, int mouseY) {
        if (this.lockActionButton.isMouseOver((double)mouseX, (double)mouseY)) {
            this.drawButtonTip(graphics, (Component)Component.translatable((String)"gui.vampirism.minion.lock_action"), mouseX, mouseY);
        } else if (this.appearanceButton.isMouseOver((double)mouseX, (double)mouseY)) {
            this.drawButtonTip(graphics, (Component)Component.translatable((String)"gui.vampirism.minion.appearance"), mouseX, mouseY);
        } else if (this.statButton.isMouseOver((double)mouseX, (double)mouseY)) {
            this.drawButtonTip(graphics, (Component)Component.translatable((String)"gui.vampirism.minion_stats"), mouseX, mouseY);
        } else {
            super.renderTooltip(graphics, mouseX, mouseY);
        }
    }

    private void drawButtonTip(@NotNull GuiGraphics graphics, Component text, int mouseX, int mouseY) {
        graphics.renderTooltip(this.font, Collections.singletonList(text), Optional.empty(), mouseX, mouseY);
    }

    private Component getActiveTaskName() {
        return ((MinionContainer)this.menu).getSelectedTask().getName();
    }

    private void onConfigurePressed(Button b) {
        ((MinionContainer)this.menu).openConfigurationScreen();
    }

    private void onStatsPressed(Button b) {
        ((MinionContainer)this.menu).openStatsScreen();
    }

    private void selectTask(int id) {
        this.taskList.visible = false;
        ((MinionContainer)this.menu).setTaskToActivate(id);
        this.taskButton.setMessage(this.getActiveTaskName());
    }

    private void toggleActionLock(Button b) {
        this.lockActionButton.setLocked(!this.lockActionButton.isLocked());
        ((MinionContainer)this.menu).setTaskLocked(this.lockActionButton.isLocked());
    }
}

