/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.vampirism.client.core;

import com.google.common.collect.Lists;
import de.teamlapen.vampirism.api.VReference;
import de.teamlapen.vampirism.api.items.IFactionExclusiveItem;
import de.teamlapen.vampirism.api.items.oil.IApplicableOil;
import de.teamlapen.vampirism.api.util.VResourceLocation;
import de.teamlapen.vampirism.client.VampirismModClient;
import de.teamlapen.vampirism.client.model.blocks.BakedAltarInspirationModel;
import de.teamlapen.vampirism.client.model.blocks.BakedBloodContainerModel;
import de.teamlapen.vampirism.config.VampirismConfig;
import de.teamlapen.vampirism.core.ModBlocks;
import de.teamlapen.vampirism.data.ClientSkillTreeData;
import de.teamlapen.vampirism.effects.VampirismPotion;
import de.teamlapen.vampirism.entity.player.LevelAttributeModifier;
import de.teamlapen.vampirism.items.component.AppliedOilContent;
import de.teamlapen.vampirism.proxy.ClientProxy;
import de.teamlapen.vampirism.util.Helper;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.client.resources.model.ModelResourceLocation;
import net.minecraft.core.component.DataComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.PreparableReloadListener;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.alchemy.Potion;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.neoforge.client.event.ClientPlayerNetworkEvent;
import net.neoforged.neoforge.client.event.ComputeFovModifierEvent;
import net.neoforged.neoforge.client.event.ModelEvent;
import net.neoforged.neoforge.client.event.RegisterClientReloadListenersEvent;
import net.neoforged.neoforge.client.event.RenderLevelStageEvent;
import net.neoforged.neoforge.event.entity.player.ItemTooltipEvent;
import net.neoforged.neoforge.event.level.LevelEvent;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.NotNull;

@OnlyIn(value=Dist.CLIENT)
public class ClientEventHandler {
    private static final Logger LOGGER = LogManager.getLogger();

    static void onModelBakeRequest(ModelEvent.RegisterAdditional event) {
        int x;
        for (x = 0; x < 14; ++x) {
            event.register(ModelResourceLocation.standalone((ResourceLocation)VResourceLocation.mod("block/blood_container/blood_" + (x + 1))));
            event.register(ModelResourceLocation.standalone((ResourceLocation)VResourceLocation.mod("block/blood_container/impure_blood_" + (x + 1))));
        }
        for (x = 0; x < 10; ++x) {
            event.register(ModelResourceLocation.standalone((ResourceLocation)VResourceLocation.mod("block/altar_inspiration/blood" + (x + 1))));
        }
    }

    static void onModelBakeEvent(@NotNull ModelEvent.ModifyBakingResult event) {
        Object newModel;
        BakedModel registeredModel;
        ArrayList modelLocations;
        ModelResourceLocation loc;
        try {
            for (int x = 0; x < 14; ++x) {
                loc = ModelResourceLocation.standalone((ResourceLocation)VResourceLocation.mod("block/blood_container/blood_" + (x + 1)));
                ModelResourceLocation locImpure = ModelResourceLocation.standalone((ResourceLocation)VResourceLocation.mod("block/blood_container/impure_blood_" + (x + 1)));
                BakedBloodContainerModel.BLOOD_FLUID_MODELS[x] = (BakedModel)event.getModels().get(loc);
                BakedBloodContainerModel.IMPURE_BLOOD_FLUID_MODELS[x] = (BakedModel)event.getModels().get(locImpure);
            }
            Map registry = event.getModels();
            modelLocations = Lists.newArrayList();
            for (ModelResourceLocation modelLoc : registry.keySet()) {
                if (!modelLoc.id().getNamespace().equals("vampirism") || !modelLoc.id().getPath().equals(ModBlocks.BLOOD_CONTAINER.getId().getPath())) continue;
                modelLocations.add(modelLoc);
            }
            for (ModelResourceLocation loc2 : modelLocations) {
                registeredModel = (BakedModel)event.getModels().get(loc2);
                newModel = new BakedBloodContainerModel(registeredModel);
                event.getModels().put(loc2, newModel);
            }
        }
        catch (Exception e) {
            LOGGER.error("Failed to load fluid models for blood container", (Throwable)e);
        }
        try {
            for (int x = 0; x < 10; ++x) {
                loc = ModelResourceLocation.standalone((ResourceLocation)VResourceLocation.mod("block/altar_inspiration/blood" + (x + 1)));
                BakedAltarInspirationModel.FLUID_MODELS[x] = (BakedModel)event.getModels().get(loc);
            }
            Map registry = event.getModels();
            modelLocations = Lists.newArrayList();
            for (ModelResourceLocation modelLoc : registry.keySet()) {
                if (!modelLoc.id().getNamespace().equals("vampirism") || !modelLoc.id().getPath().equals(ModBlocks.ALTAR_INSPIRATION.getId().getPath())) continue;
                modelLocations.add(modelLoc);
            }
            for (ModelResourceLocation loc2 : modelLocations) {
                registeredModel = (BakedModel)event.getModels().get(loc2);
                newModel = new BakedAltarInspirationModel(registeredModel);
                event.getModels().put(loc2, newModel);
            }
        }
        catch (Exception e) {
            LOGGER.error("Failed to load fluid models for altar inspiration", (Throwable)e);
        }
    }

    @SubscribeEvent
    public void onFovOffsetUpdate(@NotNull ComputeFovModifierEvent event) {
        if (((Boolean)VampirismConfig.CLIENT.disableFovChange.get()).booleanValue() && Helper.isVampire(event.getPlayer())) {
            AttributeInstance speed = event.getPlayer().getAttribute(Attributes.MOVEMENT_SPEED);
            AttributeModifier vampirespeed = speed.getModifier(LevelAttributeModifier.ID);
            if (vampirespeed == null) {
                return;
            }
            event.setNewFovModifier((float)((double)event.getFovModifier() * ((vampirespeed.amount() + 1.0) * (double)event.getPlayer().getAbilities().getWalkingSpeed() + speed.getValue()) / ((vampirespeed.amount() + 1.0) * ((double)event.getPlayer().getAbilities().getWalkingSpeed() + speed.getValue()))));
        }
    }

    @SubscribeEvent
    public void onToolTip(@NotNull ItemTooltipEvent event) {
        if (VampirismPotion.isHunterPotion(event.getItemStack(), true).map(Potion::getEffects).map(effectInstances -> effectInstances.stream().map(MobEffectInstance::getEffect).anyMatch(s -> ((MobEffect)s.value()).isBeneficial())).orElse(false).booleanValue() && (event.getEntity() == null || !Helper.isHunter(event.getEntity()))) {
            event.getToolTip().add(Component.translatable((String)"text.vampirism.hunter_potion.deadly").withStyle(ChatFormatting.DARK_RED));
        }
    }

    @SubscribeEvent
    public void onWorldClosed(LevelEvent.Unload event) {
        VampirismModClient.getINSTANCE().clearBossBarOverlay();
    }

    static void onModelRegistry(@NotNull ModelEvent.RegisterAdditional event) {
        for (DyeColor dye : DyeColor.values()) {
            event.register(ModelResourceLocation.standalone((ResourceLocation)VResourceLocation.mod("block/coffin/coffin_bottom_" + dye.getName())));
            event.register(ModelResourceLocation.standalone((ResourceLocation)VResourceLocation.mod("block/coffin/coffin_top_" + dye.getName())));
            event.register(ModelResourceLocation.standalone((ResourceLocation)VResourceLocation.mod("block/coffin/coffin_" + dye.getName())));
        }
    }

    @SubscribeEvent
    public void onItemToolTip(@NotNull ItemTooltipEvent event) {
        if (event.getItemStack().getItem() instanceof IFactionExclusiveItem) {
            return;
        }
        AppliedOilContent.getAppliedOil(event.getItemStack()).ifPresent(oil -> {
            List toolTips = event.getToolTip();
            int position = 1;
            if (!event.getItemStack().has(DataComponents.HIDE_ADDITIONAL_TOOLTIP)) {
                ArrayList additionalComponents = new ArrayList();
                event.getItemStack().getItem().appendHoverText(event.getItemStack(), event.getContext(), additionalComponents, event.getFlags());
                position += additionalComponents.size();
                Optional<Component> oilTooltip = ((IApplicableOil)oil.oil().value()).getToolTipLine(event.getItemStack(), (IApplicableOil)oil.oil().value(), oil.duration(), event.getFlags());
                if (oilTooltip.isPresent()) {
                    toolTips.add(position++, oilTooltip.get());
                }
            }
            ArrayList<MutableComponent> factionToolTips = new ArrayList<MutableComponent>();
            factionToolTips.add(Component.empty());
            Object[] objectArray = new Object[1];
            objectArray[0] = VReference.HUNTER_FACTION.getName().copy().withStyle(Minecraft.getInstance().player != null ? (Helper.isHunter((Player)Minecraft.getInstance().player) ? ChatFormatting.DARK_GREEN : ChatFormatting.DARK_RED) : ChatFormatting.GRAY);
            factionToolTips.add(Component.translatable((String)"text.vampirism.faction_exclusive", (Object[])objectArray));
            toolTips.addAll(Math.min(event.getToolTip().size(), position), factionToolTips);
        });
    }

    public static void registerReloadListener(RegisterClientReloadListenersEvent event) {
        event.registerReloadListener((PreparableReloadListener)ClientProxy.get().getBlockEntityItemRenderer());
    }

    public static void registerStageEvent(RenderLevelStageEvent.RegisterStageEvent event) {
        ClientProxy.get().registerBlockEntityItemRenderer();
    }

    @SubscribeEvent
    public void onJoined(ClientPlayerNetworkEvent.LoggingOut event) {
        ClientSkillTreeData.reset();
    }
}

