/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.vampirism.blocks;

import de.teamlapen.vampirism.api.entity.player.skills.ISkill;
import de.teamlapen.vampirism.blocks.VampirismHorizontalBlock;
import de.teamlapen.vampirism.entity.player.hunter.HunterPlayer;
import de.teamlapen.vampirism.entity.player.hunter.skills.HunterSkills;
import de.teamlapen.vampirism.inventory.WeaponTableMenu;
import de.teamlapen.vampirism.util.Helper;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.ItemInteractionResult;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.SimpleMenuProvider;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.ContainerLevelAccess;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.level.material.MapColor;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.neoforged.neoforge.fluids.FluidStack;
import net.neoforged.neoforge.fluids.FluidUtil;
import net.neoforged.neoforge.fluids.capability.IFluidHandler;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class WeaponTableBlock
extends VampirismHorizontalBlock {
    public static final int MAX_LAVA = 5;
    public static final int MB_PER_META = 200;
    public static final IntegerProperty LAVA = IntegerProperty.create((String)"lava", (int)0, (int)5);
    private static final Component name = Component.translatable((String)"gui.vampirism.hunter_weapon_table");

    @NotNull
    private static VoxelShape makeShape() {
        VoxelShape a = Block.box((double)3.0, (double)0.0, (double)0.0, (double)13.0, (double)2.0, (double)8.0);
        VoxelShape b = Block.box((double)4.0, (double)2.0, (double)1.0, (double)12.0, (double)3.0, (double)7.0);
        VoxelShape c = Block.box((double)5.0, (double)3.0, (double)2.0, (double)11.0, (double)6.0, (double)6.0);
        VoxelShape d = Block.box((double)3.0, (double)6.0, (double)0.0, (double)13.0, (double)9.5, (double)8.0);
        VoxelShape e = Block.box((double)0.0, (double)1.0, (double)9.0, (double)7.0, (double)2.0, (double)16.0);
        VoxelShape e1 = Block.box((double)0.0, (double)0.0, (double)9.0, (double)2.0, (double)1.0, (double)11.0);
        VoxelShape e2 = Block.box((double)5.0, (double)0.0, (double)9.0, (double)7.0, (double)1.0, (double)11.0);
        VoxelShape e3 = Block.box((double)0.0, (double)0.0, (double)14.0, (double)2.0, (double)1.0, (double)16.0);
        VoxelShape e4 = Block.box((double)5.0, (double)0.0, (double)14.0, (double)7.0, (double)1.0, (double)16.0);
        VoxelShape e5 = Block.box((double)0.0, (double)1.0, (double)9.0, (double)1.0, (double)7.0, (double)16.0);
        VoxelShape e6 = Block.box((double)0.0, (double)1.0, (double)9.0, (double)7.0, (double)7.0, (double)10.0);
        VoxelShape e7 = Block.box((double)0.0, (double)1.0, (double)15.0, (double)7.0, (double)7.0, (double)16.0);
        VoxelShape e8 = Block.box((double)6.0, (double)1.0, (double)9.0, (double)7.0, (double)7.0, (double)16.0);
        VoxelShape f = Block.box((double)10.0, (double)0.0, (double)11.0, (double)15.0, (double)3.0, (double)14.0);
        VoxelShape g = Block.box((double)12.0, (double)3.0, (double)12.0, (double)13.0, (double)10.0, (double)13.0);
        return Shapes.or((VoxelShape)a, (VoxelShape[])new VoxelShape[]{b, c, d, e, e1, e2, e3, e4, e5, e6, e7, e8, f, g});
    }

    public WeaponTableBlock() {
        super(BlockBehaviour.Properties.of().mapColor(MapColor.METAL).strength(3.0f).noOcclusion(), WeaponTableBlock.makeShape());
        this.registerDefaultState((BlockState)((BlockState)((BlockState)this.getStateDefinition().any()).setValue((Property)LAVA, (Comparable)Integer.valueOf(0))).setValue((Property)FACING, (Comparable)Direction.NORTH));
    }

    @Nullable
    public MenuProvider getMenuProvider(@NotNull BlockState state, @NotNull Level worldIn, @NotNull BlockPos pos) {
        return new SimpleMenuProvider((id, playerInventory, playerEntity) -> new WeaponTableMenu(id, playerInventory, ContainerLevelAccess.create((Level)worldIn, (BlockPos)pos)), name);
    }

    protected ItemInteractionResult useItemOn(ItemStack stack, BlockState state, Level world, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hit) {
        if (!world.isClientSide) {
            if (!Helper.isHunter(player)) {
                player.displayClientMessage((Component)Component.translatable((String)"text.vampirism.unfamiliar"), true);
                return ItemInteractionResult.CONSUME;
            }
            int fluid = (Integer)world.getBlockState(pos).getValue((Property)LAVA);
            boolean flag = false;
            ItemStack heldItem = player.getItemInHand(hand);
            if (fluid < 5) {
                Optional opt = FluidUtil.getFluidHandler((ItemStack)heldItem);
                flag = opt.map(fluidHandler -> {
                    FluidStack drained;
                    FluidStack missing = new FluidStack((Fluid)Fluids.LAVA, (5 - fluid) * 200);
                    FluidStack drainable = fluidHandler.drain(missing, IFluidHandler.FluidAction.SIMULATE);
                    if (drainable.isEmpty()) {
                        missing.setAmount(1000);
                        drainable = fluidHandler.drain(missing, IFluidHandler.FluidAction.SIMULATE);
                    }
                    if (drainable.getAmount() >= 200 && (drained = fluidHandler.drain(missing, IFluidHandler.FluidAction.EXECUTE)).getAmount() > 0) {
                        world.setBlockAndUpdate(pos, (BlockState)state.setValue((Property)LAVA, (Comparable)Integer.valueOf(Math.min(5, fluid + drained.getAmount() / 200))));
                        player.setItemInHand(hand, fluidHandler.getContainer());
                        return true;
                    }
                    return false;
                }).orElse(false);
            }
            if (flag) {
                return ItemInteractionResult.SUCCESS;
            }
        }
        return ItemInteractionResult.PASS_TO_DEFAULT_BLOCK_INTERACTION;
    }

    protected InteractionResult useWithoutItem(BlockState state, Level level, BlockPos pos, Player player, BlockHitResult hit) {
        if (!level.isClientSide) {
            if (this.canUse(player)) {
                player.openMenu((MenuProvider)new SimpleMenuProvider((id, playerInventory, playerIn) -> new WeaponTableMenu(id, playerInventory, ContainerLevelAccess.create((Level)playerIn.level(), (BlockPos)pos)), name), pos);
            } else {
                player.displayClientMessage((Component)Component.translatable((String)"text.vampirism.not_learned"), true);
            }
        }
        return InteractionResult.sidedSuccess((boolean)level.isClientSide);
    }

    @Override
    protected void createBlockStateDefinition(// Could not load outer class - annotation placement on inner may be incorrect
     @NotNull StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{LAVA, FACING});
    }

    private boolean canUse(@NotNull Player player) {
        if (Helper.isHunter(player)) {
            return HunterPlayer.get(player).getSkillHandler().isSkillEnabled((ISkill)HunterSkills.WEAPON_TABLE.get());
        }
        return false;
    }
}

