/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.vampirism.blocks;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import de.teamlapen.vampirism.blockentity.TotemBlockEntity;
import de.teamlapen.vampirism.core.ModBlocks;
import de.teamlapen.vampirism.core.ModStats;
import de.teamlapen.vampirism.core.ModTiles;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.BaseEntityBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.MapColor;
import net.minecraft.world.level.material.PushReaction;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TotemTopBlock
extends BaseEntityBlock {
    public static final MapCodec<TotemTopBlock> CODEC = RecordCodecBuilder.mapCodec(inst -> inst.group((App)Codec.BOOL.fieldOf("crafted").forGetter(TotemTopBlock::isCrafted), (App)ResourceLocation.CODEC.fieldOf("faction").forGetter(inst2 -> inst2.faction), (App)TotemTopBlock.propertiesCodec()).apply((Applicative)inst, TotemTopBlock::new));
    private static final List<TotemTopBlock> blocks = new ArrayList<TotemTopBlock>();
    private static final VoxelShape shape = TotemTopBlock.makeShape();
    public final ResourceLocation faction;
    private final boolean crafted;

    @NotNull
    public static List<TotemTopBlock> getBlocks() {
        return Collections.unmodifiableList(blocks);
    }

    @NotNull
    private static VoxelShape makeShape() {
        VoxelShape a = Block.box((double)3.0, (double)0.0, (double)3.0, (double)13.0, (double)10.0, (double)13.0);
        VoxelShape b = Block.box((double)1.0, (double)1.0, (double)1.0, (double)15.0, (double)9.0, (double)15.0);
        return Shapes.or((VoxelShape)a, (VoxelShape)b);
    }

    public TotemTopBlock(boolean crafted, ResourceLocation faction) {
        this(crafted, faction, BlockBehaviour.Properties.of().mapColor(MapColor.STONE).strength(12.0f, 2000.0f).sound(SoundType.STONE).pushReaction(PushReaction.BLOCK));
    }

    public TotemTopBlock(boolean crafted, ResourceLocation faction, BlockBehaviour.Properties properties) {
        super(properties);
        this.faction = faction;
        this.crafted = crafted;
        blocks.add(this);
    }

    public boolean canEntityDestroy(BlockState state, BlockGetter world, BlockPos pos, Entity entity) {
        return false;
    }

    @NotNull
    protected MapCodec<? extends BaseEntityBlock> codec() {
        return CODEC;
    }

    @NotNull
    public RenderShape getRenderShape(@NotNull BlockState state) {
        return RenderShape.MODEL;
    }

    public float getExplosionResistance() {
        return Float.MAX_VALUE;
    }

    public void neighborChanged(@NotNull BlockState state, @NotNull Level worldIn, @NotNull BlockPos pos, @NotNull Block blockIn, @NotNull BlockPos fromPos, boolean isMoving) {
        if (worldIn.isClientSide) {
            return;
        }
        BlockEntity tile = worldIn.getBlockEntity(pos);
        if (tile instanceof TotemBlockEntity) {
            ((TotemBlockEntity)tile).updateTileStatus();
            worldIn.blockEvent(pos, (Block)this, 1, 0);
        }
    }

    @NotNull
    public VoxelShape getShape(@NotNull BlockState state, @NotNull BlockGetter worldIn, @NotNull BlockPos pos, @NotNull CollisionContext context) {
        return shape;
    }

    public boolean isCrafted() {
        return this.crafted;
    }

    @Nullable
    public BlockEntity newBlockEntity(@NotNull BlockPos pos, @NotNull BlockState state) {
        return ((BlockEntityType)ModTiles.TOTEM.get()).create(pos, state);
    }

    public void onRemove(@NotNull BlockState state, @NotNull Level worldIn, @NotNull BlockPos pos, @NotNull BlockState newState, boolean isMoving) {
        if (!(newState.getBlock() instanceof TotemTopBlock)) {
            worldIn.removeBlockEntity(pos);
        }
    }

    @NotNull
    public InteractionResult useWithoutItem(@NotNull BlockState state, @NotNull Level world, @NotNull BlockPos pos, @NotNull Player player, @NotNull BlockHitResult hit) {
        if (world.isClientSide) {
            return InteractionResult.SUCCESS;
        }
        TotemBlockEntity t = this.getTile(world, pos);
        if (t != null && world.getBlockState(pos.below()).getBlock().equals(ModBlocks.TOTEM_BASE.get())) {
            player.awardStat((ResourceLocation)ModStats.INTERACT_WITH_TOTEM.get());
            t.initiateCapture(player);
            return InteractionResult.SUCCESS;
        }
        return InteractionResult.PASS;
    }

    public boolean onDestroyedByPlayer(BlockState state, @NotNull Level world, @NotNull BlockPos pos, @NotNull Player player, boolean willHarvest, FluidState fluid) {
        TotemBlockEntity tile = this.getTile(world, pos);
        if (tile != null && !tile.canPlayerRemoveBlock(player)) {
            return false;
        }
        if (super.onDestroyedByPlayer(state, world, pos, player, willHarvest, fluid)) {
            if (tile != null && tile.getControllingFaction() != null) {
                tile.notifyNearbyPlayers((Component)Component.translatable((String)"text.vampirism.village.village_abandoned"));
            }
            return true;
        }
        return false;
    }

    @Nullable
    private TotemBlockEntity getTile(@NotNull Level world, @NotNull BlockPos pos) {
        BlockEntity tile = world.getBlockEntity(pos);
        if (tile instanceof TotemBlockEntity) {
            return (TotemBlockEntity)tile;
        }
        return null;
    }

    @Nullable
    public <T extends BlockEntity> BlockEntityTicker<T> getTicker(@NotNull Level level, @NotNull BlockState state, @NotNull BlockEntityType<T> type) {
        return TotemTopBlock.createTickerHelper(type, (BlockEntityType)((BlockEntityType)ModTiles.TOTEM.get()), (BlockEntityTicker)(level.isClientSide() ? TotemBlockEntity::clientTick : TotemBlockEntity::serverTick));
    }
}

