/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.vampirism.blocks;

import com.mojang.serialization.MapCodec;
import de.teamlapen.vampirism.blockentity.PedestalBlockEntity;
import de.teamlapen.vampirism.blocks.VampirismBlockContainer;
import de.teamlapen.vampirism.core.ModStats;
import de.teamlapen.vampirism.core.ModTiles;
import de.teamlapen.vampirism.items.VampireSwordItem;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.ItemInteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.BaseEntityBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PedestalBlock
extends VampirismBlockContainer {
    public static final MapCodec<PedestalBlock> CODEC = PedestalBlock.simpleCodec(PedestalBlock::new);
    private static final VoxelShape pedestalShape = PedestalBlock.makeShape();

    private static void takeItemPlayer(@NotNull Player player, @NotNull InteractionHand hand, @NotNull ItemStack stack) {
        player.setItemInHand(hand, stack);
        if (stack.getItem() instanceof VampireSwordItem && ((VampireSwordItem)stack.getItem()).isFullyCharged(stack)) {
            ((VampireSwordItem)stack.getItem()).tryName(stack, player);
        }
    }

    @NotNull
    private static VoxelShape makeShape() {
        VoxelShape a = Block.box((double)1.0, (double)0.0, (double)1.0, (double)15.0, (double)1.0, (double)15.0);
        VoxelShape b = Block.box((double)2.0, (double)1.0, (double)2.0, (double)14.0, (double)2.0, (double)14.0);
        VoxelShape c = Block.box((double)5.0, (double)2.0, (double)5.0, (double)11.0, (double)3.0, (double)11.0);
        VoxelShape d = Block.box((double)6.0, (double)3.0, (double)6.0, (double)10.0, (double)7.0, (double)10.0);
        VoxelShape e = Block.box((double)5.0, (double)7.0, (double)5.0, (double)11.0, (double)8.0, (double)11.0);
        VoxelShape f = Block.box((double)3.0, (double)8.0, (double)3.0, (double)13.0, (double)9.0, (double)13.0);
        VoxelShape g1 = Block.box((double)4.0, (double)9.0, (double)4.0, (double)5.0, (double)11.0, (double)5.0);
        VoxelShape g2 = Block.box((double)11.0, (double)9.0, (double)4.0, (double)12.0, (double)11.0, (double)5.0);
        VoxelShape g3 = Block.box((double)4.0, (double)9.0, (double)11.0, (double)5.0, (double)11.0, (double)12.0);
        VoxelShape g4 = Block.box((double)11.0, (double)9.0, (double)11.0, (double)12.0, (double)11.0, (double)12.0);
        return Shapes.or((VoxelShape)a, (VoxelShape[])new VoxelShape[]{b, c, d, e, f, g1, g2, g3, g4});
    }

    public PedestalBlock(BlockBehaviour.Properties properties) {
        super(properties);
    }

    @NotNull
    protected MapCodec<? extends BaseEntityBlock> codec() {
        return CODEC;
    }

    @NotNull
    public RenderShape getRenderShape(@NotNull BlockState state) {
        return RenderShape.MODEL;
    }

    @Nullable
    public BlockEntity newBlockEntity(@NotNull BlockPos pos, @NotNull BlockState state) {
        return new PedestalBlockEntity(pos, state);
    }

    @NotNull
    public VoxelShape getShape(@NotNull BlockState state, @NotNull BlockGetter worldIn, @NotNull BlockPos pos, @NotNull CollisionContext context) {
        return pedestalShape;
    }

    protected InteractionResult useWithoutItem(BlockState state, Level world, BlockPos pos, Player player, BlockHitResult hit) {
        return this.getTile((BlockGetter)world, pos).filter(s -> player.getMainHandItem().isEmpty()).map(pedestal -> {
            ItemStack stack2 = pedestal.extractItem(0, 1, false);
            player.awardStat((ResourceLocation)ModStats.ITEMS_FILLED_ON_BLOOD_PEDESTAL.get());
            PedestalBlock.takeItemPlayer(player, InteractionHand.MAIN_HAND, stack2);
            return InteractionResult.sidedSuccess((boolean)world.isClientSide);
        }).orElse(InteractionResult.PASS);
    }

    protected ItemInteractionResult useItemOn(ItemStack stack, BlockState state, Level world, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hit) {
        return this.getTile((BlockGetter)world, pos).filter(s -> !s.hasStack()).map(pedestal -> {
            ItemStack stack2 = ItemStack.EMPTY;
            if (!pedestal.extractItem(0, 1, true).isEmpty()) {
                stack2 = pedestal.extractItem(0, 1, false);
            }
            if (pedestal.insertItem(0, stack, false).isEmpty()) {
                if (!stack.isEmpty()) {
                    PedestalBlock.takeItemPlayer(player, hand, stack2);
                }
            } else {
                pedestal.insertItem(0, stack2, false);
            }
            return ItemInteractionResult.sidedSuccess((boolean)world.isClientSide);
        }).orElse(ItemInteractionResult.PASS_TO_DEFAULT_BLOCK_INTERACTION);
    }

    @Override
    protected void clearContainer(BlockState state, @NotNull Level worldIn, @NotNull BlockPos pos) {
        PedestalBlockEntity tile = this.getTileEntity((BlockGetter)worldIn, pos);
        if (tile != null && tile.hasStack()) {
            this.dropItem(worldIn, pos, tile.removeStack());
        }
    }

    @Nullable
    private PedestalBlockEntity getTileEntity(@NotNull BlockGetter world, @NotNull BlockPos pos) {
        BlockEntity tile = world.getBlockEntity(pos);
        if (tile instanceof PedestalBlockEntity) {
            return (PedestalBlockEntity)tile;
        }
        return null;
    }

    @NotNull
    private Optional<PedestalBlockEntity> getTile(@NotNull BlockGetter world, @NotNull BlockPos pos) {
        BlockEntity tile = world.getBlockEntity(pos);
        if (tile instanceof PedestalBlockEntity) {
            return Optional.of((PedestalBlockEntity)tile);
        }
        return Optional.empty();
    }

    @Nullable
    public <T extends BlockEntity> BlockEntityTicker<T> getTicker(@NotNull Level level, @NotNull BlockState state, @NotNull BlockEntityType<T> type) {
        return PedestalBlock.createTickerHelper(type, (BlockEntityType)((BlockEntityType)ModTiles.BLOOD_PEDESTAL.get()), (BlockEntityTicker)(level.isClientSide() ? PedestalBlockEntity::clientTick : PedestalBlockEntity::serverTick));
    }

    public boolean hasAnalogOutputSignal(@NotNull BlockState pState) {
        return true;
    }

    public int getAnalogOutputSignal(@NotNull BlockState pState, @NotNull Level pLevel, @NotNull BlockPos pPos) {
        PedestalBlockEntity tile = this.getTileEntity((BlockGetter)pLevel, pPos);
        if (tile != null) {
            return tile.getChargedProgress();
        }
        return 0;
    }
}

