/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.vampirism.blocks;

import de.teamlapen.vampirism.blocks.VampirismBlock;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.LevelWriter;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.MapColor;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.NotNull;

public class FirePlaceBlock
extends VampirismBlock {
    private static final VoxelShape shape = FirePlaceBlock.makeShape();

    @NotNull
    private static VoxelShape makeShape() {
        return Block.box((double)0.0, (double)0.01, (double)0.0, (double)16.0, (double)4.0, (double)16.0);
    }

    public FirePlaceBlock() {
        super(BlockBehaviour.Properties.of().mapColor(MapColor.WOOD).lightLevel(s -> 15).strength(1.0f).ignitedByLava().noOcclusion());
    }

    public void animateTick(@NotNull BlockState stateIn, @NotNull Level worldIn, @NotNull BlockPos pos, @NotNull RandomSource rand) {
        if (rand.nextInt(24) == 0) {
            worldIn.playLocalSound((double)((float)pos.getX() + 0.5f), (double)((float)pos.getY() + 0.5f), (double)((float)pos.getZ() + 0.5f), SoundEvents.FIRE_AMBIENT, SoundSource.BLOCKS, 1.0f + rand.nextFloat(), rand.nextFloat() * 0.7f + 0.3f, false);
        }
        for (int i = 0; i < 2; ++i) {
            double d0 = (double)pos.getX() + rand.nextDouble();
            double d1 = (double)pos.getY() + rand.nextDouble() * 0.5 + 0.5;
            double d2 = (double)pos.getZ() + rand.nextDouble();
            worldIn.addParticle((ParticleOptions)ParticleTypes.LARGE_SMOKE, d0, d1, d2, 0.0, 0.0, 0.0);
        }
    }

    @NotNull
    public VoxelShape getShape(@NotNull BlockState state, @NotNull BlockGetter worldIn, @NotNull BlockPos pos, @NotNull CollisionContext context) {
        return shape;
    }

    public boolean canSurvive(@NotNull BlockState state, @NotNull LevelReader worldIn, @NotNull BlockPos pos) {
        return worldIn.getBlockState(pos.below()).isFaceSturdy((BlockGetter)worldIn, pos.below(), Direction.UP);
    }

    public void onNeighborChange(@NotNull BlockState state, @NotNull LevelReader world, @NotNull BlockPos pos, BlockPos neighbor) {
        if (!this.canSurvive(state, world, pos) && world instanceof LevelWriter) {
            ((LevelWriter)world).destroyBlock(pos, true);
        }
    }
}

