/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.vampirism.blockentity;

import de.teamlapen.vampirism.api.items.IBloodChargeable;
import de.teamlapen.vampirism.api.util.VResourceLocation;
import de.teamlapen.vampirism.core.ModFluids;
import de.teamlapen.vampirism.core.ModParticles;
import de.teamlapen.vampirism.core.ModTiles;
import de.teamlapen.vampirism.particle.FlyingBloodParticleOptions;
import java.util.Random;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.Connection;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.phys.Vec3;
import net.neoforged.neoforge.fluids.FluidStack;
import net.neoforged.neoforge.fluids.FluidUtil;
import net.neoforged.neoforge.fluids.capability.IFluidHandler;
import net.neoforged.neoforge.items.IItemHandler;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PedestalBlockEntity
extends BlockEntity
implements IItemHandler {
    private final Random rand = new Random();
    private final int chargeRate = 30;
    private int ticksExistedClient;
    private int chargingTicks;
    private int bloodStored = 0;
    @NotNull
    private ItemStack internalStack = ItemStack.EMPTY;

    public PedestalBlockEntity(@NotNull BlockPos pos, @NotNull BlockState state) {
        super((BlockEntityType)ModTiles.BLOOD_PEDESTAL.get(), pos, state);
    }

    @NotNull
    public ItemStack extractItem(int slot, int amount, boolean simulate) {
        ItemStack stack = this.internalStack;
        if (slot == 0 && !stack.isEmpty()) {
            if (!simulate) {
                this.removeStack();
                this.markDirtyAndUpdateClient();
            }
            return simulate ? stack.copy() : stack;
        }
        return ItemStack.EMPTY;
    }

    public int getSlotLimit(int slot) {
        return 1;
    }

    public int getSlots() {
        return 1;
    }

    @NotNull
    public ItemStack getStackForRender() {
        return this.internalStack;
    }

    @NotNull
    public ItemStack getStackInSlot(int slot) {
        return slot == 0 ? this.internalStack : ItemStack.EMPTY;
    }

    public int getTickForRender() {
        return this.ticksExistedClient;
    }

    @Nullable
    public ClientboundBlockEntityDataPacket getUpdatePacket() {
        return ClientboundBlockEntityDataPacket.create((BlockEntity)this);
    }

    @NotNull
    public CompoundTag getUpdateTag(HolderLookup.Provider provider) {
        return this.saveWithoutMetadata(provider);
    }

    public boolean hasStack() {
        return !this.internalStack.isEmpty();
    }

    @NotNull
    public ItemStack insertItem(int slot, @NotNull ItemStack stack, boolean simulate) {
        if (slot == 0 && this.internalStack.isEmpty()) {
            if (!simulate) {
                this.setStack(stack);
                this.markDirtyAndUpdateClient();
            }
            return ItemStack.EMPTY;
        }
        return stack;
    }

    public boolean isItemValid(int slot, @NotNull ItemStack stack) {
        return true;
    }

    public void loadAdditional(@NotNull CompoundTag compound, HolderLookup.Provider provider) {
        super.loadAdditional(compound, provider);
        this.internalStack = compound.contains("item") ? ItemStack.parseOptional((HolderLookup.Provider)provider, (CompoundTag)compound.getCompound("item")) : ItemStack.EMPTY;
        this.bloodStored = compound.getInt("blood_stored");
        this.chargingTicks = compound.getInt("charging_ticks");
    }

    public void onDataPacket(Connection net, @NotNull ClientboundBlockEntityDataPacket pkt, HolderLookup.Provider provider) {
        if (this.hasLevel()) {
            this.handleUpdateTag(pkt.getTag(), provider);
        }
    }

    @NotNull
    public ItemStack removeStack() {
        ItemStack stack = this.internalStack;
        this.internalStack = ItemStack.EMPTY;
        return stack;
    }

    public void saveAdditional(@NotNull CompoundTag compound, HolderLookup.Provider provider) {
        super.saveAdditional(compound, provider);
        if (this.hasStack()) {
            compound.put("item", this.internalStack.save(provider, (Tag)new CompoundTag()));
        }
        compound.putInt("blood_stored", this.bloodStored);
        compound.putInt("charging_ticks", this.chargingTicks);
    }

    public static void serverTick(Level level, BlockPos pos, BlockState state, @NotNull PedestalBlockEntity blockEntity) {
        if (blockEntity.chargingTicks > 0) {
            --blockEntity.chargingTicks;
            if (blockEntity.chargingTicks == 0) {
                IBloodChargeable chargeable = PedestalBlockEntity.getChargeItem(blockEntity.internalStack);
                if (chargeable != null && blockEntity.bloodStored > 0) {
                    int charged = chargeable.charge(blockEntity.internalStack, blockEntity.bloodStored);
                    blockEntity.bloodStored -= Math.max(0, charged);
                }
                blockEntity.markDirtyAndUpdateClient();
            }
        } else if (blockEntity.chargingTicks == 0) {
            IBloodChargeable chargeable = PedestalBlockEntity.getChargeItem(blockEntity.internalStack);
            if (chargeable != null && chargeable.canBeCharged(blockEntity.internalStack)) {
                if (blockEntity.bloodStored < blockEntity.chargeRate) {
                    blockEntity.drainBlood();
                }
                if (blockEntity.bloodStored > 0) {
                    blockEntity.chargingTicks = 20;
                    blockEntity.markDirtyAndUpdateClient();
                } else {
                    blockEntity.chargingTicks = -40;
                }
            } else {
                blockEntity.chargingTicks = -40;
            }
        } else {
            ++blockEntity.chargingTicks;
        }
    }

    public static void clientTick(@NotNull Level level, @NotNull BlockPos pos, BlockState state, @NotNull PedestalBlockEntity blockEntity) {
        ++blockEntity.ticksExistedClient;
        if (blockEntity.chargingTicks > 0 && blockEntity.ticksExistedClient % 8 == 0) {
            PedestalBlockEntity.spawnChargedParticle(level, pos, blockEntity.rand);
        }
    }

    private void drainBlood() {
        if (this.level == null) {
            return;
        }
        FluidUtil.getFluidHandler((Level)this.level, (BlockPos)this.worldPosition.below(), (Direction)Direction.UP).ifPresent(handler -> {
            FluidStack drained = handler.drain(new FluidStack((Fluid)ModFluids.BLOOD.get(), 100), IFluidHandler.FluidAction.SIMULATE);
            if (!drained.isEmpty() && drained.getAmount() == 100) {
                drained = handler.drain(new FluidStack((Fluid)ModFluids.BLOOD.get(), 100), IFluidHandler.FluidAction.EXECUTE);
                this.bloodStored += drained.getAmount();
            }
        });
    }

    public int getChargedProgress() {
        IBloodChargeable chargeItem = PedestalBlockEntity.getChargeItem(this.internalStack);
        if (chargeItem != null) {
            return (int)(chargeItem.getChargePercentage(this.internalStack) * 10.0f);
        }
        return 0;
    }

    @Nullable
    private static IBloodChargeable getChargeItem(@NotNull ItemStack stack) {
        IBloodChargeable chargeable;
        Item item;
        return stack.isEmpty() ? null : ((item = stack.getItem()) instanceof IBloodChargeable ? (chargeable = (IBloodChargeable)item) : null);
    }

    private void markDirtyAndUpdateClient() {
        if (this.level != null) {
            super.setChanged();
            BlockState block = this.level.getBlockState(this.worldPosition);
            this.level.sendBlockUpdated(this.worldPosition, block, block, 3);
        }
    }

    private void setStack(@NotNull ItemStack stack) {
        this.chargingTicks = 0;
        if (this.internalStack.isEmpty()) {
            this.internalStack = stack;
        }
    }

    private static void spawnChargedParticle(@NotNull Level level, @NotNull BlockPos blockPos, @NotNull Random rand) {
        Vec3 pos = Vec3.upFromBottomCenterOf((Vec3i)blockPos, (double)0.8);
        ModParticles.spawnParticleClient(level, new FlyingBloodParticleOptions((int)(4.0f / (rand.nextFloat() * 0.9f + 0.1f)), true, pos.x + (double)(1.0f - rand.nextFloat()) * 0.1, pos.y + (double)(1.0f - rand.nextFloat()) * 0.2, pos.z + (double)(1.0f - rand.nextFloat()) * 0.1, VResourceLocation.mc("glitter_1")), (double)blockPos.getX() + 0.2, (double)blockPos.getY() + 0.65, (double)blockPos.getZ() + 0.2);
        ModParticles.spawnParticleClient(level, new FlyingBloodParticleOptions((int)(4.0f / (rand.nextFloat() * 0.9f + 0.1f)), true, pos.x + (double)(1.0f - rand.nextFloat()) * 0.1, pos.y + (double)(1.0f - rand.nextFloat()) * 0.2, pos.z + (double)(1.0f - rand.nextFloat()) * 0.1, VResourceLocation.mc("glitter_1")), (double)blockPos.getX() + 0.8, (double)blockPos.getY() + 0.65, (double)blockPos.getZ() + 0.2);
        ModParticles.spawnParticleClient(level, new FlyingBloodParticleOptions((int)(4.0f / (rand.nextFloat() * 0.9f + 0.1f)), true, pos.x + (double)(1.0f - rand.nextFloat()) * 0.1, pos.y + (double)(1.0f - rand.nextFloat()) * 0.2, pos.z + (double)(1.0f - rand.nextFloat()) * 0.1, VResourceLocation.mc("glitter_1")), (double)blockPos.getX() + 0.2, (double)blockPos.getY() + 0.65, (double)blockPos.getZ() + 0.8);
        ModParticles.spawnParticleClient(level, new FlyingBloodParticleOptions((int)(3.0f / (rand.nextFloat() * 0.6f + 0.4f)), true, pos.x + (double)(1.0f - rand.nextFloat()) * 0.1, pos.y + (double)(1.0f - rand.nextFloat()) * 0.2, pos.z + (double)(1.0f - rand.nextFloat()) * 0.1, VResourceLocation.mc("glitter_1")), (double)blockPos.getX() + 0.8, (double)blockPos.getY() + 0.65, (double)blockPos.getZ() + 0.8);
    }
}

