/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.vampirism.api.items;

import de.teamlapen.vampirism.api.VampirismAPI;
import de.teamlapen.vampirism.api.entity.factions.IFactionPlayerHandler;
import de.teamlapen.vampirism.api.entity.player.IFactionPlayer;
import de.teamlapen.vampirism.api.entity.player.skills.ISkill;
import de.teamlapen.vampirism.api.items.IFactionExclusiveItem;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public interface IFactionLevelItem<T extends IFactionPlayer<T>>
extends IFactionExclusiveItem {
    @Override
    default public void addFactionToolTips(@NotNull ItemStack stack, // Could not load outer class - annotation placement on inner may be incorrect
     @Nullable Item.TooltipContext worldIn, @NotNull List<Component> tooltip, TooltipFlag flagIn, @Nullable Player player) {
        ISkill requiredSkill;
        IFactionPlayerHandler playerHandler = player != null ? VampirismAPI.factionPlayerHandler(player) : null;
        IFactionExclusiveItem.super.addFactionToolTips(stack, worldIn, tooltip, flagIn, player);
        boolean correctFaction = playerHandler != null && playerHandler.isInFaction(this.getExclusiveFaction(stack));
        int minLevel = this.getMinLevel(stack);
        if (minLevel > 1) {
            tooltip.add((Component)Component.literal((String)" ").append((Component)Component.translatable((String)"text.vampirism.required_level", (Object[])new Object[]{String.valueOf(minLevel)})).withStyle(correctFaction ? ChatFormatting.DARK_GREEN : ChatFormatting.DARK_RED));
        }
        if ((requiredSkill = this.getRequiredSkill(stack)) != null) {
            tooltip.add((Component)Component.literal((String)" ").append((Component)Component.translatable((String)"text.vampirism.required_skill", (Object[])new Object[]{requiredSkill.getName()})).withStyle(correctFaction && playerHandler.getCurrentFactionPlayer().map(p -> p.getSkillHandler().isSkillEnabled(requiredSkill)).orElse(false) != false ? ChatFormatting.DARK_GREEN : ChatFormatting.DARK_RED));
        }
    }

    public int getMinLevel(@NotNull ItemStack var1);

    @Nullable
    public ISkill<T> getRequiredSkill(@NotNull ItemStack var1);
}

