/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.vampirism.api.event;

import de.teamlapen.vampirism.api.entity.player.vampire.IDrinkBloodContext;
import de.teamlapen.vampirism.api.entity.player.vampire.IVampirePlayer;
import de.teamlapen.vampirism.api.entity.vampire.IVampire;
import net.neoforged.bus.api.Event;
import org.jetbrains.annotations.NotNull;

public abstract class BloodDrinkEvent
extends Event {
    @NotNull
    private final IVampire vampire;
    private int amount;
    private float saturation;
    private final IDrinkBloodContext bloodSource;

    private BloodDrinkEvent(@NotNull IVampire vampire, int amount, float saturation, IDrinkBloodContext bloodSource) {
        this.vampire = vampire;
        this.amount = amount;
        this.saturation = saturation;
        this.bloodSource = bloodSource;
    }

    @NotNull
    public IVampire getVampire() {
        return this.vampire;
    }

    public int getAmount() {
        return this.amount;
    }

    public float getSaturation() {
        return this.saturation;
    }

    public IDrinkBloodContext getBloodSource() {
        return this.bloodSource;
    }

    public void setAmount(int amount) {
        this.amount = amount;
    }

    public void setSaturationModifier(float saturation) {
        this.saturation = saturation;
    }

    public static class EntityDrinkBloodEvent
    extends BloodDrinkEvent {
        private boolean useRemaining;

        public EntityDrinkBloodEvent(@NotNull IVampire vampire, int amount, float saturation, boolean useRemaining, IDrinkBloodContext bloodSource) {
            super(vampire, amount, saturation, bloodSource);
            this.useRemaining = useRemaining;
        }

        public boolean useRemaining() {
            return this.useRemaining;
        }

        public void setUseRemaining(boolean useRemaining) {
            this.useRemaining = useRemaining;
        }
    }

    public static class PlayerDrinkBloodEvent
    extends BloodDrinkEvent {
        private boolean useRemaining;

        public PlayerDrinkBloodEvent(@NotNull IVampirePlayer player, int amount, float saturation, boolean useRemaining, IDrinkBloodContext bloodSource) {
            super(player, amount, saturation, bloodSource);
            this.useRemaining = useRemaining;
        }

        public boolean useRemaining() {
            return this.useRemaining;
        }

        public void setUseRemaining(boolean useRemaining) {
            this.useRemaining = useRemaining;
        }
    }
}

