/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.vampirism.api.entity.player.actions;

import de.teamlapen.vampirism.api.entity.factions.IPlayableFaction;
import de.teamlapen.vampirism.api.entity.player.IFactionPlayer;
import de.teamlapen.vampirism.api.entity.player.skills.ISkill;
import de.teamlapen.vampirism.api.entity.player.skills.ISkillLike;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public interface IAction<T extends IFactionPlayer<T>>
extends ISkillLike<T> {
    public PERM canUse(T var1);

    public int getCooldown(T var1);

    @NotNull
    public Optional<IPlayableFaction<?>> getFaction();

    default public boolean matchesFaction(@Nullable IPlayableFaction<?> faction) {
        if (this.getFaction().isEmpty() && faction == null) {
            return true;
        }
        return this.getFaction().map(f -> f == faction).orElse(true);
    }

    default public MutableComponent getName() {
        return Component.translatable((String)this.getTranslationKey());
    }

    public String getTranslationKey();

    public boolean onActivated(T var1, ActivationContext var2);

    default public boolean showInSelectAction(Player player) {
        return true;
    }

    default public boolean showHudCooldown(Player player) {
        return false;
    }

    @Override
    public ISkill<T> asSkill();

    public static interface ActivationContext {
        public Optional<BlockPos> targetBlock();

        public Optional<Entity> targetEntity();
    }

    public static enum PERM {
        ALLOWED,
        DISABLED,
        NOT_UNLOCKED,
        DISALLOWED,
        COOLDOWN,
        PERMISSION_DISALLOWED;

    }
}

