/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.vampirism.api;

import de.teamlapen.vampirism.api.VampirismAttachments;
import de.teamlapen.vampirism.api.entity.IExtendedCreatureVampirism;
import de.teamlapen.vampirism.api.entity.ISundamageRegistry;
import de.teamlapen.vampirism.api.entity.IVampirismEntityRegistry;
import de.teamlapen.vampirism.api.entity.actions.IEntityActionManager;
import de.teamlapen.vampirism.api.entity.factions.IFactionPlayerHandler;
import de.teamlapen.vampirism.api.entity.factions.IFactionRegistry;
import de.teamlapen.vampirism.api.entity.player.actions.IActionManager;
import de.teamlapen.vampirism.api.entity.player.hunter.IHunterPlayer;
import de.teamlapen.vampirism.api.entity.player.skills.ISkillManager;
import de.teamlapen.vampirism.api.entity.player.vampire.IVampirePlayer;
import de.teamlapen.vampirism.api.entity.player.vampire.IVampireVisionRegistry;
import de.teamlapen.vampirism.api.general.IBloodConversionRegistry;
import de.teamlapen.vampirism.api.items.IExtendedBrewingRecipeRegistry;
import de.teamlapen.vampirism.api.settings.ISettingsProvider;
import de.teamlapen.vampirism.api.world.IFogHandler;
import de.teamlapen.vampirism.api.world.IGarlicChunkHandler;
import java.util.Optional;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;

public class VampirismAPI {
    private static boolean INIT;
    private static IFactionRegistry factionRegistry;
    private static ISundamageRegistry sundamageRegistry;
    private static IVampirismEntityRegistry entityRegistry;
    private static IVampireVisionRegistry vampireVisionRegistry;
    private static ISkillManager skillManager;
    private static IActionManager actionManager;
    private static IEntityActionManager entityActionManager;
    private static IExtendedBrewingRecipeRegistry extendedBrewingRecipeRegistry;
    private static ISettingsProvider settings;
    private static IBloodConversionRegistry bloodConversionRegistry;

    public static ISkillManager skillManager() {
        return skillManager;
    }

    public static IActionManager actionManager() {
        return actionManager;
    }

    public static IEntityActionManager entityActionManager() {
        return entityActionManager;
    }

    public static IVampireVisionRegistry vampireVisionRegistry() {
        return vampireVisionRegistry;
    }

    public static IFactionRegistry factionRegistry() {
        return factionRegistry;
    }

    public static ISundamageRegistry sundamageRegistry() {
        return sundamageRegistry;
    }

    public static IVampirismEntityRegistry entityRegistry() {
        return entityRegistry;
    }

    public static IExtendedBrewingRecipeRegistry extendedBrewingRecipeRegistry() {
        return extendedBrewingRecipeRegistry;
    }

    public static ISettingsProvider settings() {
        return settings;
    }

    public static IBloodConversionRegistry bloodConversionRegistry() {
        return bloodConversionRegistry;
    }

    @ApiStatus.Internal
    public static void setUpRegistries(IFactionRegistry factionRegistryIn, ISundamageRegistry sundamageRegistryIn, IVampirismEntityRegistry entityRegistryIn, IActionManager actionManagerIn, ISkillManager skillManagerIn, IVampireVisionRegistry vampireVisionRegistryIn, IEntityActionManager entityActionManagerIn, IExtendedBrewingRecipeRegistry extendedBrewingRecipeRegistryIn, ISettingsProvider settingsIn, IBloodConversionRegistry bloodConversionRegistryIn) {
        if (INIT) {
            throw new IllegalStateException("Vampirism API can only be setup once");
        }
        factionRegistry = factionRegistryIn;
        sundamageRegistry = sundamageRegistryIn;
        entityRegistry = entityRegistryIn;
        actionManager = actionManagerIn;
        skillManager = skillManagerIn;
        vampireVisionRegistry = vampireVisionRegistryIn;
        entityActionManager = entityActionManagerIn;
        extendedBrewingRecipeRegistry = extendedBrewingRecipeRegistryIn;
        settings = settingsIn;
        bloodConversionRegistry = bloodConversionRegistryIn;
        INIT = true;
    }

    @ApiStatus.Internal
    public static void onSetupComplete() {
        settings.syncSettingsCache();
    }

    @NotNull
    public static IFactionPlayerHandler factionPlayerHandler(@NotNull Player player) {
        return (IFactionPlayerHandler)player.getData(VampirismAttachments.FACTION_PLAYER_HANDLER);
    }

    @NotNull
    public static IVampirePlayer vampirePlayer(@NotNull Player player) {
        return (IVampirePlayer)player.getData(VampirismAttachments.VAMPIRE_PLAYER);
    }

    @NotNull
    public static IHunterPlayer hunterPlayer(@NotNull Player player) {
        return (IHunterPlayer)player.getData(VampirismAttachments.HUNTER_PLAYER);
    }

    @NotNull
    public static IExtendedCreatureVampirism extendedCreatureVampirism(@NotNull PathfinderMob creature) {
        return (IExtendedCreatureVampirism)creature.getData(VampirismAttachments.EXTENDED_CREATURE);
    }

    @NotNull
    public static IGarlicChunkHandler garlicHandler(@NotNull Level w) {
        return (IGarlicChunkHandler)w.getData(VampirismAttachments.GARLIC_HANDLER);
    }

    @NotNull
    public static IFogHandler fogHandler(@NotNull Level w) {
        return (IFogHandler)w.getData(VampirismAttachments.FOG_HANDLER);
    }

    @Deprecated
    @NotNull
    public static Optional<IFactionPlayerHandler> getFactionPlayerHandler(@NotNull Player player) {
        return Optional.of((IFactionPlayerHandler)player.getData(VampirismAttachments.FACTION_PLAYER_HANDLER));
    }

    @Deprecated
    @NotNull
    public static Optional<IVampirePlayer> getVampirePlayer(@NotNull Player player) {
        return Optional.of((IVampirePlayer)player.getData(VampirismAttachments.VAMPIRE_PLAYER));
    }

    @Deprecated
    @NotNull
    public static Optional<IHunterPlayer> getHunterPlayer(@NotNull Player player) {
        return Optional.of((IHunterPlayer)player.getData(VampirismAttachments.HUNTER_PLAYER));
    }

    @Deprecated
    @NotNull
    public static Optional<IExtendedCreatureVampirism> getExtendedCreatureVampirism(@NotNull PathfinderMob creature) {
        return Optional.of((IExtendedCreatureVampirism)creature.getData(VampirismAttachments.EXTENDED_CREATURE));
    }

    @Deprecated
    @NotNull
    public static Optional<IGarlicChunkHandler> getGarlicHandler(@NotNull Level w) {
        return Optional.of((IGarlicChunkHandler)w.getData(VampirismAttachments.GARLIC_HANDLER));
    }

    @Deprecated
    @NotNull
    public static Optional<IFogHandler> getFogHandler(@NotNull Level w) {
        return Optional.of((IFogHandler)w.getData(VampirismAttachments.FOG_HANDLER));
    }
}

