/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.vampirism.api;

import com.google.common.base.Suppliers;
import de.teamlapen.vampirism.api.util.VResourceLocation;
import java.util.Objects;
import java.util.function.Supplier;
import net.minecraft.core.Registry;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.neoforged.neoforge.registries.RegistryManager;
import net.neoforged.neoforge.registries.datamaps.DataMapType;

class APIUtil {
    APIUtil() {
    }

    static <T> Supplier<DataComponentType<T>> supplyDataComponent(ResourceLocation key) {
        return Suppliers.memoize(() -> Objects.requireNonNull((DataComponentType)BuiltInRegistries.DATA_COMPONENT_TYPE.get(key)));
    }

    static <T, Z> Supplier<DataMapType<T, Z>> supplyDataMap(ResourceKey<Registry<T>> registry, ResourceLocation key) {
        return Suppliers.memoize(() -> Objects.requireNonNull(RegistryManager.getDataMap((ResourceKey)registry, (ResourceLocation)key)));
    }

    static <T> Supplier<T> supplyRegistry(ResourceKey<T> key) {
        return Suppliers.memoize(() -> Objects.requireNonNull(BuiltInRegistries.REGISTRY.get(key)));
    }

    static <T> ResourceKey<Registry<T>> registryKey(String name) {
        return ResourceKey.createRegistryKey((ResourceLocation)VResourceLocation.mod(name));
    }
}

