/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.vampirism.advancements.critereon;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import de.teamlapen.vampirism.core.ModAdvancements;
import java.util.Optional;
import net.minecraft.advancements.Criterion;
import net.minecraft.advancements.CriterionTriggerInstance;
import net.minecraft.advancements.critereon.ContextAwarePredicate;
import net.minecraft.advancements.critereon.EntityPredicate;
import net.minecraft.advancements.critereon.SimpleCriterionTrigger;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.npc.Villager;
import net.minecraft.world.level.storage.loot.LootContext;
import org.jetbrains.annotations.NotNull;

public class CuredVampireVillagerCriterionTrigger
extends SimpleCriterionTrigger<TriggerInstance> {
    public void trigger(@NotNull ServerPlayer player, @NotNull Entity vampire, @NotNull Villager villager) {
        LootContext lootcontext = EntityPredicate.createContext((ServerPlayer)player, (Entity)vampire);
        LootContext lootcontext1 = EntityPredicate.createContext((ServerPlayer)player, (Entity)villager);
        this.trigger(player, instance -> instance.matches(lootcontext, lootcontext1));
    }

    @NotNull
    public Codec<TriggerInstance> codec() {
        return TriggerInstance.CODEC;
    }

    public record TriggerInstance(@NotNull Optional<ContextAwarePredicate> player, @NotNull Optional<ContextAwarePredicate> vampire, @NotNull Optional<ContextAwarePredicate> villager) implements SimpleCriterionTrigger.SimpleInstance
    {
        public static final Codec<TriggerInstance> CODEC = RecordCodecBuilder.create(inst -> inst.group((App)EntityPredicate.ADVANCEMENT_CODEC.optionalFieldOf("player").forGetter(TriggerInstance::player), (App)EntityPredicate.ADVANCEMENT_CODEC.optionalFieldOf("vampire").forGetter(TriggerInstance::vampire), (App)EntityPredicate.ADVANCEMENT_CODEC.optionalFieldOf("villager").forGetter(TriggerInstance::villager)).apply((Applicative)inst, TriggerInstance::new));

        private TriggerInstance() {
            this(Optional.empty(), Optional.empty(), Optional.empty());
        }

        @NotNull
        public static Criterion<TriggerInstance> any() {
            return ((CuredVampireVillagerCriterionTrigger)((Object)ModAdvancements.TRIGGER_CURED_VAMPIRE_VILLAGER.get())).createCriterion((CriterionTriggerInstance)new TriggerInstance());
        }

        public boolean matches(@NotNull LootContext vampire, @NotNull LootContext villager) {
            if (this.vampire.map(s -> !s.matches(vampire)).orElse(false).booleanValue()) {
                return false;
            }
            return this.villager.map(s -> s.matches(villager)).orElse(true);
        }
    }
}

