/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.lib.network;

import de.teamlapen.lib.HelperRegistry;
import de.teamlapen.lib.lib.storage.IAttachedSyncable;
import de.teamlapen.lib.lib.storage.ISyncable;
import de.teamlapen.lib.network.ClientboundUpdateEntityPacket;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.neoforged.neoforge.attachment.AttachmentType;
import net.neoforged.neoforge.network.handling.IPayloadContext;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class ClientPayloadHandler {
    private static final Logger LOGGER = LogManager.getLogger();
    private static final ClientPayloadHandler INSTANCE = new ClientPayloadHandler();

    public static ClientPayloadHandler getInstance() {
        return INSTANCE;
    }

    public void handleUpdateEntityPacket(ClientboundUpdateEntityPacket pkt, IPayloadContext context) {
        context.enqueueWork(() -> {
            Player player = context.player();
            Level level = player.level();
            Entity e = level.getEntity(pkt.getId());
            if (e == null) {
                LOGGER.error("Did not find entity {}", (Object)pkt.getId());
                if (pkt.isPlayerItself()) {
                    LOGGER.error("Message is meant for player itself, but id mismatch {} {}. Loading anyway.", (Object)player.getId(), (Object)pkt.getId());
                    e = player;
                }
            }
            if (e != null) {
                if (pkt.getData() != null) {
                    if (e instanceof ISyncable) {
                        ISyncable syncable = (ISyncable)e;
                        syncable.deserializeUpdateNBT((HolderLookup.Provider)player.registryAccess(), pkt.getData());
                    } else {
                        LOGGER.warn("Target entity {} does not implement ISyncable", (Object)e);
                    }
                }
                if (pkt.getAttachments() != null) {
                    for (String key : pkt.getAttachments().getAllKeys()) {
                        ClientPayloadHandler.handleCapability(e, ResourceLocation.parse((String)key), pkt.getAttachments().getCompound(key));
                    }
                }
            }
        });
    }

    private static void handleCapability(Entity e, ResourceLocation key, CompoundTag data) {
        AttachmentType cap = (AttachmentType)HelperRegistry.getSyncableEntityCaps().get((Object)key);
        if (cap == null && e instanceof Player) {
            cap = (AttachmentType)HelperRegistry.getSyncablePlayerCaps().get((Object)key);
        }
        if (cap == null) {
            LOGGER.warn("Capability with key {} is not registered in the HelperRegistry", (Object)key);
        } else {
            ((IAttachedSyncable)e.getData(cap)).deserializeUpdateNBT((HolderLookup.Provider)e.registryAccess(), data);
        }
    }
}

