/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.lib.lib.inventory;

import com.mojang.datafixers.util.Pair;
import java.util.Collection;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ContainerLevelAccess;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class InventoryContainerMenu
extends AbstractContainerMenu {
    protected final ContainerLevelAccess worldPos;
    protected final Container inventory;
    private final int size;

    public InventoryContainerMenu(MenuType<? extends InventoryContainerMenu> containerType, int id, @NotNull Inventory playerInventory, ContainerLevelAccess worldPos, @NotNull Container inventory, SelectorInfo ... selectorInfos) {
        this(containerType, id, playerInventory, worldPos, inventory, SelectorSlot::new, selectorInfos);
    }

    public InventoryContainerMenu(MenuType<? extends InventoryContainerMenu> containerType, int id, @NotNull Inventory playerInventory, ContainerLevelAccess worldPos, @NotNull Container inventory, @NotNull SelectorSlotFactory factory, SelectorInfo ... selectorInfos) {
        this(containerType, id, worldPos, inventory, selectorInfos.length);
        if (inventory.getContainerSize() < selectorInfos.length) {
            throw new IllegalArgumentException("Inventory size smaller than selector infos");
        }
        inventory.startOpen(playerInventory.player);
        for (int i = 0; i < selectorInfos.length; ++i) {
            SelectorSlot slot = factory.create(inventory, i, selectorInfos[i], arg_0 -> ((InventoryContainerMenu)this).slotsChanged(arg_0), this::isSlotEnabled);
            slot.setContainer(this);
            this.addSlot(slot);
        }
    }

    private InventoryContainerMenu(MenuType<? extends InventoryContainerMenu> containerType, int id, ContainerLevelAccess worldPos, Container inventory, int size) {
        super(containerType, id);
        this.worldPos = worldPos;
        this.inventory = inventory;
        this.size = size;
    }

    @NotNull
    public ItemStack quickMoveStack(@NotNull Player playerEntity, int index) {
        ItemStack result = ItemStack.EMPTY;
        Slot slot = (Slot)this.slots.get(index);
        if (slot != null && slot.hasItem()) {
            ItemStack slotStack = slot.getItem();
            result = slotStack.copy();
            if (index < this.size) {
                if (!this.moveItemStackTo(slotStack, this.size, 36 + this.size, false)) {
                    return ItemStack.EMPTY;
                }
            } else if (index >= this.size && index < 27 + this.size) {
                if (!this.moveItemStackTo(slotStack, 0, this.size, false) && slotStack.isEmpty()) {
                    return ItemStack.EMPTY;
                }
                if (!this.moveItemStackTo(slotStack, 27 + this.size, 36 + this.size, false)) {
                    return ItemStack.EMPTY;
                }
            } else if (index >= 27 + this.size && index < 36 + this.size && !this.moveItemStackTo(slotStack, 0, 27 + this.size, false)) {
                return ItemStack.EMPTY;
            }
            if (slotStack.isEmpty()) {
                slot.set(ItemStack.EMPTY);
            } else {
                slot.setChanged();
            }
            if (slotStack.getCount() == result.getCount()) {
                return ItemStack.EMPTY;
            }
            slot.onTake(playerEntity, slotStack);
        }
        return result;
    }

    public void removed(@NotNull Player playerIn) {
        super.removed(playerIn);
        this.inventory.stopOpen(playerIn);
    }

    public boolean stillValid(@NotNull Player playerIn) {
        return true;
    }

    protected void addPlayerSlots(@NotNull Inventory playerInventory, int baseX, int baseY) {
        int i;
        for (i = 0; i < 3; ++i) {
            for (int j = 0; j < 9; ++j) {
                this.addSlot(new Slot((Container)playerInventory, j + i * 9 + 9, baseX + j * 18, baseY + i * 18));
            }
        }
        for (i = 0; i < 9; ++i) {
            this.addSlot(new Slot((Container)playerInventory, i, baseX + i * 18, baseY + 58));
        }
    }

    protected void addPlayerSlots(@NotNull Inventory playerInventory) {
        this.addPlayerSlots(playerInventory, 8, 84);
    }

    protected boolean isSlotEnabled(int id) {
        return true;
    }

    @FunctionalInterface
    public static interface SelectorSlotFactory {
        public SelectorSlot create(Container var1, int var2, SelectorInfo var3, Consumer<Container> var4, Function<Integer, Boolean> var5);
    }

    public static class SelectorInfo {
        public final Predicate<ItemStack> predicate;
        public final int xDisplay;
        public final int yDisplay;
        public final int stackLimit;
        public final boolean inverted;
        @Nullable
        public final Pair<ResourceLocation, ResourceLocation> background;

        public SelectorInfo(Predicate<ItemStack> predicate, int x, int y, boolean inverted, int limit, @Nullable Pair<ResourceLocation, ResourceLocation> background) {
            this.predicate = predicate;
            this.xDisplay = x;
            this.yDisplay = y;
            this.stackLimit = limit;
            this.inverted = inverted;
            this.background = background;
        }

        public SelectorInfo(@NotNull Item item, int x, int y) {
            this(item, x, y, false, 64, null);
        }

        public SelectorInfo(@NotNull Item item, int x, int y, boolean inverted, int stackLimit, @Nullable Pair<ResourceLocation, ResourceLocation> background) {
            this((ItemStack itemStack) -> item.equals(itemStack.getItem()), x, y, inverted, stackLimit, background);
        }

        public SelectorInfo(@NotNull Supplier<Collection<Item>> lazyItemCollection, int x, int y, boolean inverted, int stackLimit, @Nullable Pair<ResourceLocation, ResourceLocation> background) {
            this((ItemStack itemStack) -> ((Collection)lazyItemCollection.get()).contains(itemStack.getItem()), x, y, inverted, stackLimit, background);
        }

        public SelectorInfo(@NotNull TagKey<Item> tag, int x, int y) {
            this(tag, x, y, false, 64, null);
        }

        public SelectorInfo(@NotNull TagKey<Item> tag, int x, int y, boolean inverted, int stackLimit, @Nullable Pair<ResourceLocation, ResourceLocation> background) {
            this((ItemStack itemStack) -> itemStack.is(tag), x, y, inverted, stackLimit, background);
        }

        public SelectorInfo(Predicate<ItemStack> predicate, int x, int y) {
            this(predicate, x, y, false);
        }

        public SelectorInfo(Predicate<ItemStack> predicate, int x, int y, boolean inverted) {
            this(predicate, x, y, inverted, 64, null);
        }

        public SelectorInfo(Predicate<ItemStack> predicate, int x, int y, int stackLimit, @Nullable Pair<ResourceLocation, ResourceLocation> background) {
            this(predicate, x, y, false, stackLimit, background);
        }

        public boolean validate(ItemStack s) {
            boolean result = this.predicate.test(s);
            return result != this.inverted;
        }
    }

    public static class SelectorSlot
    extends Slot {
        @NotNull
        private final SelectorInfo info;
        private final Function<Integer, Boolean> activeFunc;
        private final Consumer<Container> refreshInvFunc;
        private InventoryContainerMenu ourContainer;

        public SelectorSlot(@NotNull Container inventoryIn, int index, @NotNull SelectorInfo info, Consumer<Container> refreshInvFunc, Function<Integer, Boolean> activeFunc) {
            super(inventoryIn, index, info.xDisplay, info.yDisplay);
            this.info = info;
            this.activeFunc = activeFunc;
            this.refreshInvFunc = refreshInvFunc;
        }

        public InventoryContainerMenu getContainer() {
            return this.ourContainer;
        }

        public void setContainer(InventoryContainerMenu container) {
            this.ourContainer = container;
        }

        public int getMaxStackSize(@NotNull ItemStack stack) {
            return Math.min(stack.getMaxStackSize(), this.info.stackLimit);
        }

        public int getMaxStackSize() {
            return this.info.stackLimit;
        }

        @Nullable
        public Pair<ResourceLocation, ResourceLocation> getNoItemIcon() {
            return this.info.background;
        }

        public boolean isActive() {
            return this.activeFunc.apply(this.index);
        }

        public boolean mayPlace(@NotNull ItemStack stack) {
            return this.info.validate(stack);
        }

        public void onQuickCraft(@NotNull ItemStack oldStackIn, @NotNull ItemStack newStackIn) {
            super.onQuickCraft(oldStackIn, newStackIn);
            this.refreshInvFunc.accept(this.container);
        }
    }
}

