/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.lib.lib.data;

import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.data.PackOutput;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.block.Block;
import net.neoforged.neoforge.client.model.generators.ItemModelBuilder;
import net.neoforged.neoforge.client.model.generators.ItemModelProvider;
import net.neoforged.neoforge.client.model.generators.ModelFile;
import net.neoforged.neoforge.common.data.ExistingFileHelper;
import org.jetbrains.annotations.NotNull;

public abstract class BaseItemModelGenerator
extends ItemModelProvider {
    public BaseItemModelGenerator(@NotNull PackOutput packOutput, @NotNull String modid, @NotNull ExistingFileHelper existingFileHelper) {
        super(packOutput, modid, existingFileHelper);
    }

    public ItemModelBuilder block(Block name) {
        return this.block(name, BuiltInRegistries.BLOCK.getKey((Object)name).getPath());
    }

    public ItemModelBuilder block(Block name, String path) {
        try {
            return (ItemModelBuilder)super.withExistingParent(BuiltInRegistries.BLOCK.getKey((Object)name).getPath(), this.modid + ":block/" + path);
        }
        catch (IllegalStateException e) {
            return (ItemModelBuilder)((ItemModelBuilder)this.getBuilder(BuiltInRegistries.BLOCK.getKey((Object)name).getPath())).parent((ModelFile)new ModelFile.UncheckedModelFile(this.modid + ":block/" + path));
        }
    }

    @NotNull
    public String getName() {
        return this.modid + " Item Models";
    }

    public ItemModelBuilder item(Item item) {
        return (ItemModelBuilder)this.withExistingParent(item, this.mcLoc("item/generated")).texture("layer0", this.modid + ":item/" + BuiltInRegistries.ITEM.getKey((Object)item).getPath());
    }

    public ItemModelBuilder item(Item item, ResourceLocation ... texture) {
        return this.item(BuiltInRegistries.ITEM.getKey((Object)item).getPath(), texture);
    }

    public ItemModelBuilder item(String item, ResourceLocation ... texture) {
        ItemModelBuilder model = (ItemModelBuilder)this.withExistingParent(item, this.mcLoc("item/generated"));
        for (int i = 0; i < texture.length; ++i) {
            model.texture("layer" + i, texture[i]);
        }
        return model;
    }

    @NotNull
    public ItemModelBuilder withExistingParent(Item name, Item parent) {
        return this.withExistingParent(name, BuiltInRegistries.ITEM.getKey((Object)parent));
    }

    @NotNull
    public ItemModelBuilder withExistingParent(Block name, ResourceLocation parent) {
        return (ItemModelBuilder)super.withExistingParent(BuiltInRegistries.BLOCK.getKey((Object)name).getPath(), parent);
    }

    @NotNull
    public ItemModelBuilder withExistingParent(Item name, ResourceLocation parent) {
        return (ItemModelBuilder)super.withExistingParent(BuiltInRegistries.ITEM.getKey((Object)name).getPath(), parent);
    }
}

