/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.lib.entity;

import de.teamlapen.lib.HelperRegistry;
import de.teamlapen.lib.lib.entity.IPlayerEventListener;
import de.teamlapen.lib.lib.storage.ISyncable;
import de.teamlapen.lib.network.ClientboundUpdateEntityPacket;
import java.util.Optional;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.neoforge.attachment.AttachmentType;
import net.neoforged.neoforge.event.entity.EntityJoinLevelEvent;
import net.neoforged.neoforge.event.entity.living.LivingDeathEvent;
import net.neoforged.neoforge.event.entity.living.LivingIncomingDamageEvent;
import net.neoforged.neoforge.event.tick.EntityTickEvent;
import net.neoforged.neoforge.event.tick.PlayerTickEvent;
import org.jetbrains.annotations.NotNull;

public class EntityEventHandler {
    private final AttachmentType<IPlayerEventListener>[] listeners;

    public EntityEventHandler(AttachmentType<IPlayerEventListener>[] listeners) {
        this.listeners = listeners;
    }

    @SubscribeEvent
    public void onChangedDimension(// Could not load outer class - annotation placement on inner may be incorrect
     @NotNull PlayerEvent.PlayerChangedDimensionEvent event) {
        for (AttachmentType<IPlayerEventListener> listener : this.listeners) {
            Optional.ofNullable((IPlayerEventListener)event.getEntity().getData(listener)).ifPresent(cap -> cap.onChangedDimension((ResourceKey<Level>)event.getFrom(), (ResourceKey<Level>)event.getTo()));
        }
    }

    @SubscribeEvent
    public void onEntityJoinWorld(@NotNull EntityJoinLevelEvent event) {
        if (event.getEntity() instanceof Player) {
            for (AttachmentType<IPlayerEventListener> listener : this.listeners) {
                Optional.ofNullable((IPlayerEventListener)event.getEntity().getData(listener)).ifPresent(IPlayerEventListener::onJoinWorld);
            }
        }
    }

    @SubscribeEvent
    public void onLivingAttack(@NotNull LivingIncomingDamageEvent event) {
        if (event.getEntity() instanceof Player) {
            for (AttachmentType<IPlayerEventListener> listener : this.listeners) {
                boolean cancel = Optional.ofNullable((IPlayerEventListener)event.getEntity().getData(listener)).map(cap -> cap.onEntityAttacked(event.getSource(), event.getAmount())).orElse(false);
                if (!cancel) continue;
                event.setCanceled(true);
            }
        }
    }

    @SubscribeEvent
    public void onLivingDeath(@NotNull LivingDeathEvent event) {
        if (event.getEntity() instanceof Player) {
            for (AttachmentType<IPlayerEventListener> listener : this.listeners) {
                Optional.ofNullable((IPlayerEventListener)event.getEntity().getData(listener)).ifPresent(cap -> cap.onDeath(event.getSource()));
            }
        }
        if (event.getSource().getEntity() instanceof Player) {
            for (AttachmentType<IPlayerEventListener> listener : this.listeners) {
                Optional.ofNullable((IPlayerEventListener)event.getSource().getEntity().getData(listener)).ifPresent(cap -> cap.onEntityKilled(event.getEntity(), event.getSource()));
            }
        }
    }

    @SubscribeEvent
    public void onLivingUpdate(EntityTickEvent.Post event) {
        if (event.getEntity() instanceof Player) {
            for (AttachmentType<IPlayerEventListener> listener : this.listeners) {
                ((IPlayerEventListener)event.getEntity().getData(listener)).onUpdate();
            }
        }
    }

    @SubscribeEvent
    public void onPlayerLoggedIn(// Could not load outer class - annotation placement on inner may be incorrect
     @NotNull PlayerEvent.PlayerLoggedInEvent event) {
        for (AttachmentType<IPlayerEventListener> listener : this.listeners) {
            ((IPlayerEventListener)event.getEntity().getData(listener)).onPlayerLoggedIn();
        }
    }

    @SubscribeEvent
    public void onPlayerLoggedOut(// Could not load outer class - annotation placement on inner may be incorrect
     @NotNull PlayerEvent.PlayerLoggedOutEvent event) {
        for (AttachmentType<IPlayerEventListener> listener : this.listeners) {
            ((IPlayerEventListener)event.getEntity().getData(listener)).onPlayerLoggedOut();
        }
    }

    @SubscribeEvent
    public void onPlayerUpdate(PlayerTickEvent.Post event) {
        for (AttachmentType<IPlayerEventListener> listener : this.listeners) {
            ((IPlayerEventListener)event.getEntity().getData(listener)).onUpdatePlayer((PlayerTickEvent)event);
        }
    }

    @SubscribeEvent
    public void onStartTracking(// Could not load outer class - annotation placement on inner may be incorrect
     @NotNull PlayerEvent.StartTracking event) {
        Player player;
        ClientboundUpdateEntityPacket packet;
        if ((event.getTarget() instanceof PathfinderMob && !HelperRegistry.getSyncableEntityCaps().isEmpty() || event.getTarget() instanceof ISyncable || event.getTarget() instanceof Player && !HelperRegistry.getSyncablePlayerCaps().isEmpty()) && (packet = ClientboundUpdateEntityPacket.createJoinWorldPacket(event.getTarget())) != null && (player = event.getEntity()) instanceof ServerPlayer) {
            ServerPlayer player2 = (ServerPlayer)player;
            player2.connection.send((CustomPacketPayload)packet);
        }
    }
}

