/*
 * Decompiled with CFR 0.152.
 */
package it.hurts.octostudios.reliquified_ars_nouveau.mixin;

import com.hollingsworth.arsnouveau.common.entity.BubbleEntity;
import it.hurts.octostudios.octolib.modules.particles.OctoRenderManager;
import it.hurts.octostudios.octolib.modules.particles.RenderProvider;
import it.hurts.octostudios.octolib.modules.particles.trail.TrailProvider;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import org.spongepowered.asm.mixin.Mixin;

@Mixin(value={BubbleEntity.class})
public abstract class BubbleEntityMixin
extends Projectile
implements TrailProvider {
    protected BubbleEntityMixin(EntityType<? extends Projectile> entityType, Level level) {
        super(entityType, level);
    }

    public void onAddedToLevel() {
        super.onAddedToLevel();
        if (this.getPersistentData().getBoolean("canTrail")) {
            OctoRenderManager.registerProvider((RenderProvider)this);
        }
    }

    public Vec3 getTrailPosition(float partialTicks) {
        Vec3 entityPos = this.getPosition(1.0f);
        return new Vec3(entityPos.x, entityPos.y + (double)0.05f, entityPos.z);
    }

    public int getTrailUpdateFrequency() {
        return 1;
    }

    public boolean isTrailAlive() {
        return this.isAlive();
    }

    public boolean isTrailGrowing() {
        return this.tickCount > 2;
    }

    public int getTrailMaxLength() {
        return 15;
    }

    public int getTrailFadeInColor() {
        return -12417035;
    }

    public int getTrailFadeOutColor() {
        return -2137803027;
    }

    public double getTrailScale() {
        return 0.2f;
    }
}

