/*
 * Decompiled with CFR 0.152.
 */
package it.hurts.octostudios.reliquified_ars_nouveau.items.head;

import it.hurts.octostudios.reliquified_ars_nouveau.init.ItemRegistry;
import it.hurts.octostudios.reliquified_ars_nouveau.init.RANDataComponentRegistry;
import it.hurts.octostudios.reliquified_ars_nouveau.items.NouveauRelicItem;
import it.hurts.octostudios.reliquified_ars_nouveau.items.base.loot.LootEntries;
import it.hurts.octostudios.reliquified_ars_nouveau.network.packets.PetalsJumpPacket;
import it.hurts.sskirillss.relics.init.DataComponentRegistry;
import it.hurts.sskirillss.relics.items.relics.base.data.RelicData;
import it.hurts.sskirillss.relics.items.relics.base.data.leveling.AbilitiesData;
import it.hurts.sskirillss.relics.items.relics.base.data.leveling.AbilityData;
import it.hurts.sskirillss.relics.items.relics.base.data.leveling.LevelingData;
import it.hurts.sskirillss.relics.items.relics.base.data.leveling.LevelingSourceData;
import it.hurts.sskirillss.relics.items.relics.base.data.leveling.LevelingSourcesData;
import it.hurts.sskirillss.relics.items.relics.base.data.leveling.StatData;
import it.hurts.sskirillss.relics.items.relics.base.data.leveling.misc.GemColor;
import it.hurts.sskirillss.relics.items.relics.base.data.leveling.misc.GemShape;
import it.hurts.sskirillss.relics.items.relics.base.data.leveling.misc.UpgradeOperation;
import it.hurts.sskirillss.relics.items.relics.base.data.loot.LootData;
import it.hurts.sskirillss.relics.items.relics.base.data.loot.LootEntry;
import it.hurts.sskirillss.relics.items.relics.base.data.style.BeamsData;
import it.hurts.sskirillss.relics.items.relics.base.data.style.StyleData;
import it.hurts.sskirillss.relics.items.relics.base.data.style.TooltipData;
import it.hurts.sskirillss.relics.network.NetworkHandler;
import it.hurts.sskirillss.relics.utils.EntityUtils;
import it.hurts.sskirillss.relics.utils.MathUtils;
import it.hurts.sskirillss.relics.utils.ParticleUtils;
import java.awt.Color;
import java.util.function.Supplier;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.util.RandomSource;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.event.entity.living.LivingEvent;
import top.theillusivec4.curios.api.SlotContext;

public class WhirlisprigPetalsItem
extends NouveauRelicItem {
    public RelicData constructDefaultRelicData() {
        return RelicData.builder().abilities(AbilitiesData.builder().ability(AbilityData.builder((String)"petals").stat(StatData.builder((String)"duration").initialValue(3.0, 5.0).upgradeModifier(UpgradeOperation.MULTIPLY_BASE, 0.1).formatValue(value -> MathUtils.round((double)(value / 20.0), (int)2)).build()).build()).build()).leveling(LevelingData.builder().initialCost(100).maxLevel(10).step(100).sources(LevelingSourcesData.builder().source(LevelingSourceData.abilityBuilder((String)"petals").initialValue(1).gem(GemShape.SQUARE, GemColor.CYAN).build()).build()).build()).style(StyleData.builder().tooltip(TooltipData.builder().borderTop(-8039364).borderBottom(-8039364).textured(true).build()).beams(BeamsData.builder().startColor(-2360255).endColor(286978).build()).build()).loot(LootData.builder().entry(new LootEntry[]{LootEntries.ARS_NOUVEAU, LootEntries.ARS_NOUVEAU_LIKE}).build()).build();
    }

    public void curioTick(SlotContext slotContext, ItemStack stack) {
        block19: {
            LocalPlayer localPlayer;
            Level level;
            Player player;
            block21: {
                block20: {
                    block18: {
                        block17: {
                            block16: {
                                LivingEntity livingEntity = slotContext.entity();
                                if (!(livingEntity instanceof Player)) break block16;
                                player = (Player)livingEntity;
                                if (this.isAbilityUnlocked(stack, "petals")) break block17;
                            }
                            return;
                        }
                        double statValue = this.getActualStatValue(player, stack);
                        level = player.getCommandSenderWorld();
                        boolean isJumping = this.getToggled(stack);
                        if (level.isClientSide()) break block18;
                        if (isJumping) {
                            this.addTime(stack, 1);
                        }
                        double knowYMovement = player.getKnownMovement().y;
                        if (!WhirlisprigPetalsItem.hasSolidBlockOnRay(player, level, player.getAttributeValue(Attributes.SAFE_FALL_DISTANCE)) && !isJumping && knowYMovement <= knowYMovement * 0.6) {
                            this.setToggledSlowFall(stack, true);
                        }
                        if ((double)this.getTime(stack) >= statValue) {
                            this.setToggled(stack, false);
                        }
                        if (player.onGround() || player.isInLiquid()) {
                            this.setToggledSlowFall(stack, false);
                            this.addTime(stack, -this.getTime(stack));
                        }
                        if (!player.isShiftKeyDown()) {
                            player.fallDistance = 0.0f;
                        }
                        break block19;
                    }
                    if (!(player instanceof LocalPlayer)) break block20;
                    localPlayer = (LocalPlayer)player;
                    if (!player.isFallFlying()) break block21;
                }
                return;
            }
            RandomSource random = player.getRandom();
            Vec3 deltaMovement = player.getDeltaMovement();
            if (this.getToggledSlowFall(stack) && !localPlayer.isShiftKeyDown() && !localPlayer.getAbilities().flying) {
                player.setDeltaMovement(new Vec3(deltaMovement.x, -0.3, deltaMovement.z));
                double angle1 = (double)((float)player.tickCount * 0.3f) % (Math.PI * 2);
                double angle2 = (angle1 + Math.PI) % (Math.PI * 2);
                double radius = 0.4;
                this.renderParticle(player, radius * Math.cos(angle1), Math.sin(angle1 * 2.0) * 0.1, radius * Math.sin(angle1));
                this.renderParticle(player, radius * Math.cos(angle2), Math.sin(angle2 * 2.0) * 0.1, radius * Math.sin(angle2));
            }
            if (!this.getToggled(stack)) {
                return;
            }
            NetworkHandler.sendToServer((CustomPacketPayload)new PetalsJumpPacket(localPlayer.input.jumping));
            player.setDeltaMovement(new Vec3(deltaMovement.x, 0.4 + (double)this.getTime(stack) * 0.1, deltaMovement.z));
            for (int i = 0; i < 10; ++i) {
                double offsetX = (random.nextDouble() - 0.5) * 0.7;
                double offsetZ = (random.nextDouble() - 0.5) * 0.7;
                level.addParticle(ParticleUtils.constructSimpleSpark((Color)new Color(100 + random.nextInt(56), 200 + random.nextInt(56), 50 + random.nextInt(56)), (float)0.3f, (int)20, (float)0.7f), player.getX() + offsetX, player.getY() - 0.5, player.getZ() + offsetZ, 0.0, 0.0, 0.0);
            }
        }
    }

    public void renderParticle(Player player, double offsetX, double offsetY, double offsetZ) {
        RandomSource random = player.getRandom();
        player.getCommandSenderWorld().addParticle(ParticleUtils.constructSimpleSpark((Color)new Color(100 + random.nextInt(56), 200 + random.nextInt(56), 50 + random.nextInt(56)), (float)0.3f, (int)20, (float)0.7f), player.getX() + offsetX, player.getY() + (double)player.getBbHeight() + offsetY + 0.5, player.getZ() + offsetZ, 0.0, 0.0, 0.0);
    }

    public static boolean hasSolidBlockOnRay(Player player, Level level, double maxDistance) {
        Vec3 start = player.position();
        return level.getBlockState(level.clip(new ClipContext(start, start.subtract(0.0, maxDistance, 0.0), ClipContext.Block.COLLIDER, ClipContext.Fluid.NONE, (Entity)player)).getBlockPos()).isSolid();
    }

    public double getActualStatValue(Player player, ItemStack stack) {
        int count;
        MobEffectInstance jumpBoost;
        double statValue = this.getStatValue(stack, "petals", "duration");
        if (player.hasEffect(MobEffects.JUMP) && (jumpBoost = player.getEffect(MobEffects.JUMP)) != null) {
            statValue += (double)((jumpBoost.getAmplifier() + 1) * 4);
        }
        return statValue += (count = EntityUtils.findEquippedCurios((Entity)player, (Item)((Item)ItemRegistry.WHIRLISPRIG_PETALS.value())).size()) > 1 ? (double)(count * 4) : 0.0;
    }

    public void addTime(ItemStack stack, int val) {
        stack.set((Supplier)DataComponentRegistry.TIME, (Object)(this.getTime(stack) + val));
    }

    public int getTime(ItemStack stack) {
        return (Integer)stack.getOrDefault((Supplier)DataComponentRegistry.TIME, (Object)0);
    }

    public void setToggled(ItemStack stack, boolean val) {
        stack.set((Supplier)DataComponentRegistry.TOGGLED, (Object)val);
    }

    public boolean getToggled(ItemStack stack) {
        return (Boolean)stack.getOrDefault((Supplier)DataComponentRegistry.TOGGLED, (Object)false);
    }

    public void setToggledSlowFall(ItemStack stack, boolean val) {
        stack.set(RANDataComponentRegistry.TOGGLED_COOLDOWN, (Object)val);
    }

    public boolean getToggledSlowFall(ItemStack stack) {
        return (Boolean)stack.getOrDefault(RANDataComponentRegistry.TOGGLED_COOLDOWN, (Object)false);
    }

    @EventBusSubscriber
    public static class WhirligigPetalsEvent {
        @SubscribeEvent
        public static void onPlayerJumping(LivingEvent.LivingJumpEvent event) {
            WhirlisprigPetalsItem relic;
            LivingEntity livingEntity = event.getEntity();
            if (!(livingEntity instanceof Player)) {
                return;
            }
            Player player = (Player)livingEntity;
            ItemStack stack = EntityUtils.findEquippedCurio((Entity)player, (Item)((Item)ItemRegistry.WHIRLISPRIG_PETALS.value()));
            Item item = stack.getItem();
            if (!(item instanceof WhirlisprigPetalsItem) || !(relic = (WhirlisprigPetalsItem)item).canPlayerUseAbility(player, stack, "petals")) {
                return;
            }
            relic.setToggled(stack, true);
        }
    }
}

