/*
 * Decompiled with CFR 0.152.
 */
package it.hurts.octostudios.reliquified_ars_nouveau.items.charm;

import com.hollingsworth.arsnouveau.common.entity.BubbleEntity;
import it.hurts.octostudios.reliquified_ars_nouveau.items.NouveauRelicItem;
import it.hurts.octostudios.reliquified_ars_nouveau.items.base.loot.LootEntries;
import it.hurts.sskirillss.relics.init.DataComponentRegistry;
import it.hurts.sskirillss.relics.items.relics.base.data.RelicData;
import it.hurts.sskirillss.relics.items.relics.base.data.leveling.AbilitiesData;
import it.hurts.sskirillss.relics.items.relics.base.data.leveling.AbilityData;
import it.hurts.sskirillss.relics.items.relics.base.data.leveling.LevelingData;
import it.hurts.sskirillss.relics.items.relics.base.data.leveling.LevelingSourceData;
import it.hurts.sskirillss.relics.items.relics.base.data.leveling.LevelingSourcesData;
import it.hurts.sskirillss.relics.items.relics.base.data.leveling.StatData;
import it.hurts.sskirillss.relics.items.relics.base.data.leveling.misc.GemColor;
import it.hurts.sskirillss.relics.items.relics.base.data.leveling.misc.GemShape;
import it.hurts.sskirillss.relics.items.relics.base.data.leveling.misc.UpgradeOperation;
import it.hurts.sskirillss.relics.items.relics.base.data.loot.LootData;
import it.hurts.sskirillss.relics.items.relics.base.data.loot.LootEntry;
import it.hurts.sskirillss.relics.items.relics.base.data.style.BeamsData;
import it.hurts.sskirillss.relics.items.relics.base.data.style.StyleData;
import it.hurts.sskirillss.relics.items.relics.base.data.style.TooltipData;
import it.hurts.sskirillss.relics.utils.MathUtils;
import it.hurts.sskirillss.relics.utils.ParticleUtils;
import java.awt.Color;
import java.util.function.Supplier;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import top.theillusivec4.curios.api.SlotContext;

public class QuantumBubbleItem
extends NouveauRelicItem {
    public RelicData constructDefaultRelicData() {
        return RelicData.builder().abilities(AbilitiesData.builder().ability(AbilityData.builder((String)"stasis").stat(StatData.builder((String)"duration").initialValue(5.0, 8.0).upgradeModifier(UpgradeOperation.MULTIPLY_BASE, 0.1).formatValue(value -> MathUtils.round((double)value, (int)1)).build()).stat(StatData.builder((String)"levitation").initialValue(2.0, 4.0).upgradeModifier(UpgradeOperation.MULTIPLY_BASE, 0.1).formatValue(value -> MathUtils.round((double)value, (int)1)).build()).stat(StatData.builder((String)"cooldown").initialValue(30.0, 20.0).upgradeModifier(UpgradeOperation.MULTIPLY_BASE, -0.035).formatValue(value -> MathUtils.round((double)value, (int)1)).build()).build()).build()).style(StyleData.builder().tooltip(TooltipData.builder().borderTop(-9873575).borderBottom(-6912637).textured(true).build()).beams(BeamsData.builder().startColor(-7867665).endColor(482663).build()).build()).leveling(LevelingData.builder().initialCost(100).maxLevel(10).step(100).sources(LevelingSourcesData.builder().source(LevelingSourceData.abilityBuilder((String)"stasis").initialValue(1).gem(GemShape.SQUARE, GemColor.CYAN).build()).build()).build()).loot(LootData.builder().entry(new LootEntry[]{LootEntries.ARS_NOUVEAU, LootEntries.ARS_NOUVEAU_LIKE}).build()).build();
    }

    public void curioTick(SlotContext slotContext, ItemStack stack) {
        Player player;
        LivingEntity livingEntity = slotContext.entity();
        if (!(livingEntity instanceof Player) || (player = (Player)livingEntity).getCommandSenderWorld().isClientSide() || !this.isAbilityUnlocked(stack, "stasis")) {
            return;
        }
        ServerLevel level = (ServerLevel)player.getCommandSenderWorld();
        if (this.getTime(stack) > this.getDurationAbilities(stack) && this.getToggled(stack)) {
            this.addCooldown(stack, 1);
            if (this.getCooldown(stack) >= this.getCooldownAbilities(stack)) {
                RandomSource random = level.getRandom();
                for (int i = 0; i < 100; ++i) {
                    double angle = Math.PI * 2 * (double)i / 100.0;
                    double x = player.getX() + 1.0 * Math.cos(angle);
                    double z = player.getZ() + 1.0 * Math.sin(angle);
                    level.sendParticles(ParticleUtils.constructSimpleSpark((Color)new Color(random.nextInt(100), 100 + random.nextInt(156), 150 + random.nextInt(106)), (float)0.3f, (int)60, (float)0.95f), x, player.getY() + (double)0.1f, z, 1, 0.0, 0.1, 0.0, 0.1);
                }
                level.playSound(null, (Entity)player, SoundEvents.BUBBLE_COLUMN_UPWARDS_INSIDE, SoundSource.PLAYERS, 1.0f, 0.9f + player.getRandom().nextFloat() * 0.2f);
                this.setTime(stack, 0);
                this.setCooldown(stack, 0);
                this.setToggled(stack, false);
            }
        } else {
            if (this.getToggled(stack)) {
                this.addTime(stack, 1);
                if (player.tickCount % 15 == 0) {
                    level.playSound(null, (Entity)player, SoundEvents.BUBBLE_COLUMN_UPWARDS_AMBIENT, SoundSource.PLAYERS, 1.0f, 0.9f + player.getRandom().nextFloat() * 0.2f);
                }
                level.sendParticles((ParticleOptions)ParticleTypes.BUBBLE_POP, player.getX(), player.getY() + (double)(player.getBbHeight() / 2.0f), player.getZ(), 3, 0.5, 0.5, 0.5, 0.01);
                level.sendParticles((ParticleOptions)ParticleTypes.BUBBLE, player.getX(), player.getY() + (double)(player.getBbHeight() / 2.0f), player.getZ(), 6, 0.5, 0.5, 0.5, 0.01);
            }
            for (Projectile projectile2 : level.getEntitiesOfClass(Projectile.class, player.getBoundingBox().inflate(2.0).expandTowards(player.getKnownMovement().normalize()), projectile -> !(projectile instanceof BubbleEntity) && projectile.getVehicle() == null)) {
                if (projectile2.getOwner() != null && projectile2.getOwner().getUUID().equals(player.getUUID())) continue;
                if (projectile2 instanceof AbstractArrow) {
                    AbstractArrow abstractArrow = (AbstractArrow)projectile2;
                    if (abstractArrow.inGround) continue;
                }
                this.setToggled(stack, true);
                BubbleEntity bubble = new BubbleEntity((Level)level, (int)(this.getStatValue(stack, "stasis", "levitation") * 20.0), 0.0f);
                bubble.setPos(projectile2.getX(), projectile2.getY(), projectile2.getZ());
                bubble.setOwner((Entity)player);
                bubble.getPersistentData().putBoolean("canTrail", true);
                projectile2.setPos(bubble.position());
                projectile2.startRiding((Entity)bubble, true);
                level.addFreshEntity((Entity)bubble);
                this.spreadRelicExperience((LivingEntity)player, stack, 1);
            }
        }
    }

    public int getCooldownAbilities(ItemStack stack) {
        return (int)(this.getStatValue(stack, "stasis", "cooldown") * 20.0);
    }

    public int getDurationAbilities(ItemStack stack) {
        return (int)(this.getStatValue(stack, "stasis", "duration") * 20.0);
    }

    public void setToggled(ItemStack stack, boolean val) {
        stack.set((Supplier)DataComponentRegistry.TOGGLED, (Object)val);
    }

    public boolean getToggled(ItemStack stack) {
        return (Boolean)stack.getOrDefault((Supplier)DataComponentRegistry.TOGGLED, (Object)false);
    }

    public void addCooldown(ItemStack stack, int time) {
        this.setCooldown(stack, this.getCooldown(stack) + time);
    }

    public int getCooldown(ItemStack stack) {
        return (Integer)stack.getOrDefault((Supplier)DataComponentRegistry.COOLDOWN, (Object)0);
    }

    public void setCooldown(ItemStack stack, int val) {
        stack.set((Supplier)DataComponentRegistry.COOLDOWN, (Object)Math.max(val, 0));
    }

    public void addTime(ItemStack stack, int time) {
        this.setTime(stack, this.getTime(stack) + time);
    }

    public int getTime(ItemStack stack) {
        return (Integer)stack.getOrDefault((Supplier)DataComponentRegistry.TIME, (Object)0);
    }

    public void setTime(ItemStack stack, int val) {
        stack.set((Supplier)DataComponentRegistry.TIME, (Object)Math.max(val, 0));
    }
}

