/*
 * Decompiled with CFR 0.152.
 */
package it.hurts.octostudios.reliquified_ars_nouveau.items.charm;

import com.hollingsworth.arsnouveau.api.spell.AbstractSpellPart;
import com.hollingsworth.arsnouveau.api.spell.SpellContext;
import com.hollingsworth.arsnouveau.api.spell.SpellResolver;
import com.hollingsworth.arsnouveau.api.spell.SpellStats;
import com.hollingsworth.arsnouveau.api.spell.wrapped_caster.IWrappedCaster;
import com.hollingsworth.arsnouveau.api.spell.wrapped_caster.PlayerCaster;
import com.hollingsworth.arsnouveau.common.entity.EntityOrbitProjectile;
import com.hollingsworth.arsnouveau.common.spell.method.MethodProjectile;
import it.hurts.octostudios.reliquified_ars_nouveau.items.ScribbleRelicItem;
import it.hurts.octostudios.reliquified_ars_nouveau.items.base.loot.LootEntries;
import it.hurts.sskirillss.relics.init.DataComponentRegistry;
import it.hurts.sskirillss.relics.items.relics.base.data.RelicData;
import it.hurts.sskirillss.relics.items.relics.base.data.leveling.AbilitiesData;
import it.hurts.sskirillss.relics.items.relics.base.data.leveling.AbilityData;
import it.hurts.sskirillss.relics.items.relics.base.data.leveling.LevelingData;
import it.hurts.sskirillss.relics.items.relics.base.data.leveling.LevelingSourceData;
import it.hurts.sskirillss.relics.items.relics.base.data.leveling.LevelingSourcesData;
import it.hurts.sskirillss.relics.items.relics.base.data.leveling.StatData;
import it.hurts.sskirillss.relics.items.relics.base.data.leveling.misc.GemColor;
import it.hurts.sskirillss.relics.items.relics.base.data.leveling.misc.GemShape;
import it.hurts.sskirillss.relics.items.relics.base.data.leveling.misc.UpgradeOperation;
import it.hurts.sskirillss.relics.items.relics.base.data.loot.LootData;
import it.hurts.sskirillss.relics.items.relics.base.data.loot.LootEntry;
import it.hurts.sskirillss.relics.items.relics.base.data.style.BeamsData;
import it.hurts.sskirillss.relics.items.relics.base.data.style.StyleData;
import it.hurts.sskirillss.relics.utils.MathUtils;
import java.util.function.Supplier;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import top.theillusivec4.curios.api.SlotContext;

public class EmblemOfDevotionItem
extends ScribbleRelicItem {
    public RelicData constructDefaultRelicData() {
        return RelicData.builder().abilities(AbilitiesData.builder().ability(AbilityData.builder((String)"devotion").stat(StatData.builder((String)"periodicity").initialValue(30.0, 25.0).upgradeModifier(UpgradeOperation.MULTIPLY_BASE, -0.06).formatValue(value -> MathUtils.round((double)value, (int)1)).build()).stat(StatData.builder((String)"count").initialValue(1.0, 3.0).upgradeModifier(UpgradeOperation.ADD, 0.475).formatValue(value -> (int)MathUtils.round((double)value, (int)0)).build()).stat(StatData.builder((String)"size").initialValue(2.0, 3.0).upgradeModifier(UpgradeOperation.ADD, 0.7).formatValue(value -> (int)MathUtils.round((double)value, (int)0)).build()).build()).build()).leveling(LevelingData.builder().initialCost(100).maxLevel(10).step(100).sources(LevelingSourcesData.builder().source(LevelingSourceData.abilityBuilder((String)"devotion").initialValue(1).gem(GemShape.SQUARE, GemColor.ORANGE).build()).build()).build()).style(StyleData.builder().beams(BeamsData.builder().startColor(-1100904).endColor(12784992).build()).build()).loot(LootData.builder().entry(new LootEntry[]{LootEntries.ARS_NOUVEAU, LootEntries.ARS_NOUVEAU_LIKE}).build()).build();
    }

    public void curioTick(SlotContext slotContext, ItemStack stack) {
        Player player;
        LivingEntity livingEntity = slotContext.entity();
        if (!(livingEntity instanceof Player) || (player = (Player)livingEntity).getCommandSenderWorld().isClientSide() || !this.isAbilityUnlocked(stack, "devotion") || (double)this.getCharge(stack) >= MathUtils.round((double)this.getStatValue(stack, "devotion", "count"), (int)0)) {
            return;
        }
        Level level = player.getCommandSenderWorld();
        this.addTime(stack, 1);
        if (this.getTime(stack) >= (int)MathUtils.round((double)this.getStatValue(stack, "devotion", "periodicity"), (int)0) * 20) {
            this.addCharges(stack, 1);
            SpellContext context = new SpellContext(player.level(), this.getSpellCaster(stack).getSpell(), (LivingEntity)player, (IWrappedCaster)new PlayerCaster(player));
            SpellResolver resolver = this.getSpellCaster(stack).getSpellResolver(context, level, (LivingEntity)player, player.getUsedItemHand());
            SpellStats stats = resolver.getCastStats();
            context.setCanceled(true);
            context.setCasterTool(stack);
            EntityOrbitProjectile wardProjectile = new EntityOrbitProjectile(level, resolver.getNewResolver(resolver.spellContext.makeChildContext().withSpell(context.getRemainingSpell().mutable().add(0, (AbstractSpellPart)MethodProjectile.INSTANCE).immutable())));
            wardProjectile.setOffset(1 + this.getCharge(stack) * 40 + this.getCharge(stack) * 20);
            wardProjectile.setAccelerates((int)stats.getAccMultiplier());
            wardProjectile.setAoe((float)stats.getAoeMultiplier());
            wardProjectile.extendTimes = (int)(Math.round(this.getStatValue(stack, "devotion", "count")) + 1L) * 20;
            wardProjectile.setTotal(this.getCharge(stack));
            wardProjectile.setColor(resolver.spellContext.getColors());
            wardProjectile.setOwner((Entity)player);
            level.addFreshEntity((Entity)wardProjectile);
            this.setTime(stack, 0);
            level.playSound(null, (Entity)player, SoundEvents.ALLAY_ITEM_GIVEN, SoundSource.PLAYERS, 0.75f, 0.9f + player.getRandom().nextFloat() * 0.2f);
        }
    }

    public void onEquip(SlotContext slotContext, ItemStack prevStack, ItemStack stack) {
        Player player;
        LivingEntity livingEntity = slotContext.entity();
        if (!(livingEntity instanceof Player) || (player = (Player)livingEntity).getCommandSenderWorld().isClientSide() || prevStack.getItem() == stack.getItem() || this.getCharge(stack) < 0) {
            return;
        }
        this.setCharge(stack, 0);
        this.setTime(stack, 0);
    }

    public int getCharge(ItemStack stack) {
        return (Integer)stack.getOrDefault((Supplier)DataComponentRegistry.CHARGE, (Object)0);
    }

    public void setCharge(ItemStack stack, int charge) {
        stack.set((Supplier)DataComponentRegistry.CHARGE, (Object)Math.max(charge, 0));
    }

    public void addCharges(ItemStack stack, int charge) {
        this.setCharge(stack, this.getCharge(stack) + charge);
    }

    public void addTime(ItemStack stack, int time) {
        this.setTime(stack, this.getTime(stack) + time);
    }

    public int getTime(ItemStack stack) {
        return (Integer)stack.getOrDefault((Supplier)DataComponentRegistry.TIME, (Object)0);
    }

    public void setTime(ItemStack stack, int val) {
        stack.set((Supplier)DataComponentRegistry.TIME, (Object)Math.max(val, 0));
    }

    @Override
    public int getCountGlyphInItem(ItemStack stack) {
        return (int)Math.round(this.getStatValue(stack, "devotion", "size"));
    }
}

