/*
 * Decompiled with CFR 0.152.
 */
package it.hurts.octostudios.reliquified_ars_nouveau.items.body;

import it.hurts.octostudios.reliquified_ars_nouveau.init.ItemRegistry;
import it.hurts.octostudios.reliquified_ars_nouveau.items.NouveauRelicItem;
import it.hurts.octostudios.reliquified_ars_nouveau.items.base.loot.LootEntries;
import it.hurts.octostudios.reliquified_ars_nouveau.network.packets.WingStartFlyPacket;
import it.hurts.sskirillss.relics.init.DataComponentRegistry;
import it.hurts.sskirillss.relics.items.relics.base.data.RelicData;
import it.hurts.sskirillss.relics.items.relics.base.data.leveling.AbilitiesData;
import it.hurts.sskirillss.relics.items.relics.base.data.leveling.AbilityData;
import it.hurts.sskirillss.relics.items.relics.base.data.leveling.LevelingData;
import it.hurts.sskirillss.relics.items.relics.base.data.leveling.LevelingSourceData;
import it.hurts.sskirillss.relics.items.relics.base.data.leveling.LevelingSourcesData;
import it.hurts.sskirillss.relics.items.relics.base.data.leveling.StatData;
import it.hurts.sskirillss.relics.items.relics.base.data.leveling.misc.GemColor;
import it.hurts.sskirillss.relics.items.relics.base.data.leveling.misc.GemShape;
import it.hurts.sskirillss.relics.items.relics.base.data.leveling.misc.UpgradeOperation;
import it.hurts.sskirillss.relics.items.relics.base.data.loot.LootData;
import it.hurts.sskirillss.relics.items.relics.base.data.loot.LootEntry;
import it.hurts.sskirillss.relics.items.relics.base.data.style.BeamsData;
import it.hurts.sskirillss.relics.items.relics.base.data.style.StyleData;
import it.hurts.sskirillss.relics.items.relics.base.data.style.TooltipData;
import it.hurts.sskirillss.relics.network.NetworkHandler;
import it.hurts.sskirillss.relics.utils.EntityUtils;
import it.hurts.sskirillss.relics.utils.MathUtils;
import it.hurts.sskirillss.relics.utils.ParticleUtils;
import java.awt.Color;
import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.phys.Vec3;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.client.event.InputEvent;
import top.theillusivec4.curios.api.SlotContext;

public class WingWildStalkerItem
extends NouveauRelicItem {
    public RelicData constructDefaultRelicData() {
        return RelicData.builder().abilities(AbilitiesData.builder().ability(AbilityData.builder((String)"wings").stat(StatData.builder((String)"strength").initialValue(2.0, 4.0).upgradeModifier(UpgradeOperation.MULTIPLY_BASE, 0.1).formatValue(value -> (int)MathUtils.round((double)value, (int)0)).build()).stat(StatData.builder((String)"charges").initialValue(2.0, 3.0).upgradeModifier(UpgradeOperation.ADD, 0.65).formatValue(value -> (int)MathUtils.round((double)value, (int)0)).build()).build()).build()).leveling(LevelingData.builder().initialCost(100).maxLevel(10).step(100).sources(LevelingSourcesData.builder().source(LevelingSourceData.abilityBuilder((String)"wings").initialValue(1).gem(GemShape.SQUARE, GemColor.CYAN).build()).build()).build()).style(StyleData.builder().tooltip(TooltipData.builder().borderTop(-8039364).borderBottom(-8039364).textured(true).build()).beams(BeamsData.builder().startColor(-2153433).endColor(8461342).build()).build()).loot(LootData.builder().entry(new LootEntry[]{LootEntries.ARS_NOUVEAU, LootEntries.ARS_NOUVEAU_LIKE}).build()).build();
    }

    public void curioTick(SlotContext slotContext, ItemStack stack) {
        Player player;
        LivingEntity livingEntity = slotContext.entity();
        if (!(livingEntity instanceof Player) || (player = (Player)livingEntity).getCommandSenderWorld().isClientSide()) {
            return;
        }
        ItemStack stackFirst = (ItemStack)EntityUtils.findEquippedCurios((Entity)player, (Item)((Item)ItemRegistry.WING_OF_TH_WILD_STALKER.value())).getFirst();
        if (stackFirst.getItem() != stack.getItem()) {
            return;
        }
        if (player.isInLiquid() && player.isFallFlying()) {
            player.stopFallFlying();
        }
        if (player.isFallFlying() && player.tickCount % 20 == 0) {
            this.spreadRelicExperience((LivingEntity)player, stack, 1);
        }
        if (player.getKnownMovement().length() >= 2.0 && player.isFallFlying()) {
            RandomSource random = player.getRandom();
            double width = (double)player.getBbWidth() / 2.0;
            float height = player.getBbHeight();
            for (int i = 0; i < 30; ++i) {
                double offsetX = (random.nextDouble() - 0.5) * width * 2.0;
                double offsetY = random.nextDouble() * (double)height;
                double offsetZ = (random.nextDouble() - 0.5) * width * 2.0;
                ((ServerLevel)player.getCommandSenderWorld()).sendParticles(ParticleUtils.constructSimpleSpark((Color)new Color(150 + random.nextInt(106), random.nextInt(50), random.nextInt(50), random.nextInt(100 + random.nextInt(156))), (float)0.3f, (int)20, (float)0.95f), player.getX() + offsetX, player.getY() - 0.5 + offsetY, player.getZ() + offsetZ, 1, 0.1, 0.1, 0.1, 0.1);
            }
        }
    }

    public int getActualStatValue(ItemStack stack, String stat) {
        return (int)MathUtils.round((double)this.getStatValue(stack, "wings", stat), (int)0);
    }

    public int getCharge(ItemStack stack) {
        return (Integer)stack.getOrDefault((Supplier)DataComponentRegistry.CHARGE, (Object)0);
    }

    public void setCharge(ItemStack stack, int charge) {
        stack.set((Supplier)DataComponentRegistry.CHARGE, (Object)Math.max(charge, 0));
    }

    public void consumeCharge(ItemStack stack, int charge) {
        this.setCharge(stack, this.getCharge(stack) - charge);
    }

    @EventBusSubscriber(value={Dist.CLIENT})
    public static class WingWildStalkerClientEvent {
        @SubscribeEvent
        public static void onClientTick(InputEvent.Key event) {
            WingWildStalkerItem relic;
            Minecraft minecraft = Minecraft.getInstance();
            LocalPlayer player = minecraft.player;
            if (player == null || minecraft.screen != null || event.getAction() != 1 || event.getKey() != minecraft.options.keyJump.getKey().getValue() || player.isInLiquid() || EntityUtils.findEquippedCurios((Entity)player, (Item)((Item)ItemRegistry.WING_OF_TH_WILD_STALKER.value())).isEmpty() || player.mayFly()) {
                return;
            }
            ItemStack stackFirst = (ItemStack)EntityUtils.findEquippedCurios((Entity)player, (Item)((Item)ItemRegistry.WING_OF_TH_WILD_STALKER.value())).getFirst();
            Item item = stackFirst.getItem();
            if (!(item instanceof WingWildStalkerItem) || !(relic = (WingWildStalkerItem)item).isAbilityUnlocked(stackFirst, "wings")) {
                return;
            }
            Vec3 deltaMovement = player.getDeltaMovement();
            if (!player.isFallFlying() && !player.onGround()) {
                NetworkHandler.sendToServer((CustomPacketPayload)new WingStartFlyPacket(true));
                player.setDeltaMovement(deltaMovement.add(player.getLookAngle()).add(0.0, 0.6, 0.0));
                player.playSound(SoundEvents.ENDER_DRAGON_FLAP, 1.0f, 0.9f + player.getRandom().nextFloat() * 0.2f);
            } else if (relic.getCharge(stackFirst) > 0 && player.isFallFlying()) {
                player.setDeltaMovement(player.getDeltaMovement().add(player.getLookAngle().normalize().scale(relic.getStatValue(stackFirst, "wings", "strength") * (double)0.2f)));
                NetworkHandler.sendToServer((CustomPacketPayload)new WingStartFlyPacket(false));
                player.playSound(SoundEvents.ENDER_DRAGON_FLAP, 1.0f, 0.9f + player.getRandom().nextFloat() * 0.2f);
            }
        }
    }
}

