/*
 * Decompiled with CFR 0.152.
 */
package it.hurts.octostudios.reliquified_ars_nouveau.items.back;

import com.hollingsworth.arsnouveau.common.entity.EntityChimeraProjectile;
import it.hurts.octostudios.reliquified_ars_nouveau.init.ItemRegistry;
import it.hurts.octostudios.reliquified_ars_nouveau.items.NouveauRelicItem;
import it.hurts.octostudios.reliquified_ars_nouveau.items.base.loot.LootEntries;
import it.hurts.sskirillss.relics.init.DataComponentRegistry;
import it.hurts.sskirillss.relics.items.relics.base.data.RelicData;
import it.hurts.sskirillss.relics.items.relics.base.data.leveling.AbilitiesData;
import it.hurts.sskirillss.relics.items.relics.base.data.leveling.AbilityData;
import it.hurts.sskirillss.relics.items.relics.base.data.leveling.LevelingData;
import it.hurts.sskirillss.relics.items.relics.base.data.leveling.LevelingSourceData;
import it.hurts.sskirillss.relics.items.relics.base.data.leveling.LevelingSourcesData;
import it.hurts.sskirillss.relics.items.relics.base.data.leveling.StatData;
import it.hurts.sskirillss.relics.items.relics.base.data.leveling.misc.GemColor;
import it.hurts.sskirillss.relics.items.relics.base.data.leveling.misc.GemShape;
import it.hurts.sskirillss.relics.items.relics.base.data.leveling.misc.UpgradeOperation;
import it.hurts.sskirillss.relics.items.relics.base.data.loot.LootData;
import it.hurts.sskirillss.relics.items.relics.base.data.loot.LootEntry;
import it.hurts.sskirillss.relics.items.relics.base.data.style.BeamsData;
import it.hurts.sskirillss.relics.items.relics.base.data.style.StyleData;
import it.hurts.sskirillss.relics.items.relics.base.data.style.TooltipData;
import it.hurts.sskirillss.relics.utils.EntityUtils;
import it.hurts.sskirillss.relics.utils.MathUtils;
import it.hurts.sskirillss.relics.utils.ParticleUtils;
import java.awt.Color;
import java.util.function.Supplier;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.event.entity.living.LivingDamageEvent;
import net.neoforged.neoforge.event.entity.living.LivingDeathEvent;
import top.theillusivec4.curios.api.SlotContext;

public class SpikedCloakItem
extends NouveauRelicItem {
    public RelicData constructDefaultRelicData() {
        return RelicData.builder().abilities(AbilitiesData.builder().ability(AbilityData.builder((String)"spikes").stat(StatData.builder((String)"threshold").initialValue(0.1, 0.3).upgradeModifier(UpgradeOperation.MULTIPLY_BASE, 0.1).formatValue(value -> (int)MathUtils.round((double)(value * 100.0), (int)0)).build()).stat(StatData.builder((String)"damage").initialValue(2.0, 5.0).upgradeModifier(UpgradeOperation.MULTIPLY_BASE, 0.2).formatValue(value -> (int)MathUtils.round((double)value, (int)0)).build()).stat(StatData.builder((String)"time").initialValue(8.0, 12.0).upgradeModifier(UpgradeOperation.MULTIPLY_BASE, 0.15).formatValue(value -> (int)MathUtils.round((double)value, (int)0)).build()).build()).build()).leveling(LevelingData.builder().initialCost(100).maxLevel(10).step(100).sources(LevelingSourcesData.builder().source(LevelingSourceData.abilityBuilder((String)"spikes").initialValue(1).gem(GemShape.SQUARE, GemColor.YELLOW).build()).build()).build()).style(StyleData.builder().tooltip(TooltipData.builder().borderTop(-8039364).borderBottom(-8039364).textured(true).build()).beams(BeamsData.builder().startColor(-3256784).endColor(8851774).build()).build()).loot(LootData.builder().entry(new LootEntry[]{LootEntries.ARS_NOUVEAU, LootEntries.ARS_NOUVEAU_LIKE}).build()).build();
    }

    public void curioTick(SlotContext slotContext, ItemStack stack) {
        Player player;
        LivingEntity livingEntity = slotContext.entity();
        if (!(livingEntity instanceof Player) || (player = (Player)livingEntity).getCommandSenderWorld().isClientSide() || !this.isAbilityUnlocked(stack, "spikes")) {
            return;
        }
        if (this.getTime(stack) > 0) {
            this.consumeTime(stack, 1);
        }
        if (this.getTime(stack) <= 0) {
            this.setCount(stack, 1);
        }
        if (this.getCharges(stack) >= this.getActualActivatedHP(player, stack)) {
            ServerLevel level = (ServerLevel)player.getCommandSenderWorld();
            RandomSource random = player.getRandom();
            for (int i = 0; i < 35; ++i) {
                float modifier = 0.5f;
                EntityChimeraProjectile spike = new EntityChimeraProjectile((Level)level);
                spike.setPos(player.getX(), player.getY(), player.getZ());
                spike.setOwner((Entity)player);
                spike.setDeltaMovement((double)(MathUtils.randomFloat((RandomSource)random) * modifier), (double)(random.nextFloat() * modifier + 0.25f), (double)(MathUtils.randomFloat((RandomSource)random) * modifier));
                level.addFreshEntity((Entity)spike);
            }
            this.spreadRelicExperience((LivingEntity)player, stack, 1);
            this.setCharges(stack, 0);
            this.setTime(stack, (int)MathUtils.round((double)this.getStatValue(stack, "spikes", "time"), (int)0) * 20);
            if (this.getTime(stack) > 0) {
                this.addCount(stack, 1);
                player.getCommandSenderWorld().playSound(null, (Entity)player, SoundEvents.CAMEL_SADDLE, SoundSource.PLAYERS, 1.0f, 0.9f + player.getRandom().nextFloat() * 0.2f);
            }
            ((ServerLevel)player.getCommandSenderWorld()).sendParticles(ParticleUtils.constructSimpleSpark((Color)new Color(150 + random.nextInt(100), 100 + random.nextInt(80), 50 + random.nextInt(50)), (float)0.2f, (int)20, (float)0.85f), player.getX(), player.getY(), player.getZ(), 50, 0.5, 1.0, 0.5, 0.1);
        }
    }

    public int getActualActivatedHP(Player player, ItemStack stack) {
        return (int)((double)player.getMaxHealth() * (1.0 - this.getStatValue(stack, "spikes", "threshold")));
    }

    public int getCharges(ItemStack stack) {
        return (Integer)stack.getOrDefault((Supplier)DataComponentRegistry.CHARGE, (Object)0);
    }

    public void setCharges(ItemStack stack, int amount) {
        stack.set((Supplier)DataComponentRegistry.CHARGE, (Object)Math.max(amount, 0));
    }

    public void addCharges(ItemStack stack, int amount) {
        this.setCharges(stack, this.getCharges(stack) + amount);
    }

    public int getCount(ItemStack stack) {
        return (Integer)stack.getOrDefault((Supplier)DataComponentRegistry.COUNT, (Object)1);
    }

    public void setCount(ItemStack stack, int amount) {
        stack.set((Supplier)DataComponentRegistry.COUNT, (Object)Math.max(amount, 1));
    }

    public void addCount(ItemStack stack, int amount) {
        this.setCount(stack, this.getCount(stack) + amount);
    }

    public int getTime(ItemStack stack) {
        return (Integer)stack.getOrDefault((Supplier)DataComponentRegistry.TIME, (Object)0);
    }

    public void setTime(ItemStack stack, int amount) {
        stack.set((Supplier)DataComponentRegistry.TIME, (Object)Math.max(amount, 0));
    }

    public void consumeTime(ItemStack stack, int amount) {
        this.setTime(stack, this.getTime(stack) - amount);
    }

    @EventBusSubscriber
    public static class SpikedCloakEvent {
        @SubscribeEvent
        public static void onLivingDeath(LivingDeathEvent event) {
            SpikedCloakItem relic;
            Player player;
            LivingEntity livingEntity = event.getEntity();
            if (!(livingEntity instanceof Player) || (player = (Player)livingEntity).getCommandSenderWorld().isClientSide()) {
                return;
            }
            ItemStack stack = EntityUtils.findEquippedCurio((Entity)player, (Item)((Item)ItemRegistry.SPIKED_CLOAK.value()));
            Item item = stack.getItem();
            if (!(item instanceof SpikedCloakItem) || !(relic = (SpikedCloakItem)item).isAbilityUnlocked(stack, "spikes")) {
                return;
            }
            relic.setCharges(stack, 0);
        }

        @SubscribeEvent
        public static void onInjuredEntity(LivingDamageEvent.Pre event) {
            SpikedCloakItem relic;
            Player player;
            LivingEntity livingEntity = event.getEntity();
            if (!(livingEntity instanceof Player) || (player = (Player)livingEntity).getCommandSenderWorld().isClientSide()) {
                return;
            }
            ItemStack stack = EntityUtils.findEquippedCurio((Entity)player, (Item)((Item)ItemRegistry.SPIKED_CLOAK.value()));
            Item item = stack.getItem();
            if (!(item instanceof SpikedCloakItem) || !(relic = (SpikedCloakItem)item).isAbilityUnlocked(stack, "spikes")) {
                return;
            }
            relic.addCharges(stack, (int)event.getNewDamage());
        }
    }
}

