/*
 * Decompiled with CFR 0.152.
 */
package it.hurts.octostudios.reliquified_ars_nouveau.items.back;

import com.hollingsworth.arsnouveau.common.entity.EntityDummy;
import it.hurts.octostudios.reliquified_ars_nouveau.init.ItemRegistry;
import it.hurts.octostudios.reliquified_ars_nouveau.init.RANDataComponentRegistry;
import it.hurts.octostudios.reliquified_ars_nouveau.items.NouveauRelicItem;
import it.hurts.octostudios.reliquified_ars_nouveau.items.base.loot.LootEntries;
import it.hurts.sskirillss.relics.items.relics.base.data.RelicData;
import it.hurts.sskirillss.relics.items.relics.base.data.leveling.AbilitiesData;
import it.hurts.sskirillss.relics.items.relics.base.data.leveling.AbilityData;
import it.hurts.sskirillss.relics.items.relics.base.data.leveling.LevelingData;
import it.hurts.sskirillss.relics.items.relics.base.data.leveling.LevelingSourceData;
import it.hurts.sskirillss.relics.items.relics.base.data.leveling.LevelingSourcesData;
import it.hurts.sskirillss.relics.items.relics.base.data.leveling.StatData;
import it.hurts.sskirillss.relics.items.relics.base.data.leveling.misc.GemColor;
import it.hurts.sskirillss.relics.items.relics.base.data.leveling.misc.GemShape;
import it.hurts.sskirillss.relics.items.relics.base.data.leveling.misc.UpgradeOperation;
import it.hurts.sskirillss.relics.items.relics.base.data.loot.LootData;
import it.hurts.sskirillss.relics.items.relics.base.data.loot.LootEntry;
import it.hurts.sskirillss.relics.items.relics.base.data.style.BeamsData;
import it.hurts.sskirillss.relics.items.relics.base.data.style.StyleData;
import it.hurts.sskirillss.relics.utils.EntityUtils;
import it.hurts.sskirillss.relics.utils.MathUtils;
import it.hurts.sskirillss.relics.utils.ParticleUtils;
import java.awt.Color;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.UUID;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.event.entity.living.LivingDamageEvent;
import net.neoforged.neoforge.event.entity.living.LivingDeathEvent;
import top.theillusivec4.curios.api.SlotContext;

public class IllusionistsMantleItem
extends NouveauRelicItem {
    public RelicData constructDefaultRelicData() {
        return RelicData.builder().abilities(AbilitiesData.builder().ability(AbilityData.builder((String)"illusion").stat(StatData.builder((String)"chance").initialValue(0.1, 0.15).upgradeModifier(UpgradeOperation.MULTIPLY_BASE, 0.1).formatValue(value -> (int)MathUtils.round((double)(value * 100.0), (int)0)).build()).stat(StatData.builder((String)"duration").initialValue(5.0, 10.0).upgradeModifier(UpgradeOperation.MULTIPLY_BASE, 0.1).formatValue(value -> (int)MathUtils.round((double)value, (int)1)).build()).build()).build()).style(StyleData.builder().beams(BeamsData.builder().startColor(-7396913).endColor(4920971).build()).build()).leveling(LevelingData.builder().initialCost(100).maxLevel(10).step(100).sources(LevelingSourcesData.builder().source(LevelingSourceData.abilityBuilder((String)"illusion").initialValue(1).gem(GemShape.SQUARE, GemColor.CYAN).build()).build()).build()).loot(LootData.builder().entry(new LootEntry[]{LootEntries.ARS_NOUVEAU, LootEntries.ARS_NOUVEAU_LIKE}).build()).build();
    }

    public void onEquip(SlotContext slotContext, ItemStack prevStack, ItemStack stack) {
        if (!(slotContext.entity() instanceof Player) || prevStack.getItem() == stack.getItem() || this.getEntities(stack).isEmpty()) {
            return;
        }
        this.setEntities(stack, new ArrayList<UUID>());
    }

    public void addEntities(ItemStack stack, UUID uuid) {
        ArrayList<UUID> array = new ArrayList<UUID>(this.getEntities(stack));
        array.add(uuid);
        this.setEntities(stack, array);
    }

    public void removeEntities(ItemStack stack, UUID uuid) {
        ArrayList<UUID> array = new ArrayList<UUID>(this.getEntities(stack));
        array.remove(uuid);
        this.setEntities(stack, array);
    }

    public void setEntities(ItemStack stack, List<UUID> list) {
        stack.set(RANDataComponentRegistry.WOLVES, list);
    }

    public List<UUID> getEntities(ItemStack stack) {
        return (List)stack.getOrDefault(RANDataComponentRegistry.WOLVES, new ArrayList());
    }

    @EventBusSubscriber
    public static class IllusionistsMantleEvent {
        @SubscribeEvent
        public static void onDeathPlayer(LivingDeathEvent event) {
            IllusionistsMantleItem relic;
            Player player;
            LivingEntity livingEntity = event.getEntity();
            if (!(livingEntity instanceof Player) || (player = (Player)livingEntity).getCommandSenderWorld().isClientSide()) {
                return;
            }
            ItemStack stack = EntityUtils.findEquippedCurio((Entity)player, (Item)((Item)ItemRegistry.ILLUSIONISTS_MANTLE.value()));
            Item item = stack.getItem();
            if (!(item instanceof IllusionistsMantleItem) || (relic = (IllusionistsMantleItem)item).getEntities(stack).isEmpty()) {
                return;
            }
            ServerLevel level = (ServerLevel)player.getCommandSenderWorld();
            Optional<EntityDummy> illusion = relic.getEntities(stack).stream().map(arg_0 -> ((ServerLevel)level).getEntity(arg_0)).filter(Objects::nonNull).map(entity -> (EntityDummy)entity).max(Comparator.comparingDouble(entity -> entity.distanceToSqr((Entity)player)));
            if (illusion.isEmpty()) {
                return;
            }
            event.setCanceled(true);
            Vec3 positionIllusion = illusion.get().position();
            illusion.get().discard();
            EntityDummy illusionSecond = new EntityDummy((Level)level);
            illusionSecond.ticksLeft = 200;
            illusionSecond.setPos(player.getX(), player.getY(), player.getZ());
            illusionSecond.setOwnerID(player.getUUID());
            level.addFreshEntity((Entity)illusionSecond);
            illusionSecond.kill();
            player.setHealth(2.0f);
            player.teleportTo(positionIllusion.x(), positionIllusion.y, positionIllusion.z);
        }

        @SubscribeEvent
        public static void onInjuredEntity(LivingDamageEvent.Post event) {
            IllusionistsMantleItem relic;
            LivingEntity attacker;
            Player player;
            block6: {
                block5: {
                    LivingEntity livingEntity = event.getEntity();
                    if (!(livingEntity instanceof Player)) break block5;
                    player = (Player)livingEntity;
                    livingEntity = event.getSource().getEntity();
                    if (!(livingEntity instanceof LivingEntity)) break block5;
                    attacker = livingEntity;
                    if (!player.getCommandSenderWorld().isClientSide()) break block6;
                }
                return;
            }
            ItemStack stack = EntityUtils.findEquippedCurio((Entity)player, (Item)((Item)ItemRegistry.ILLUSIONISTS_MANTLE.value()));
            RandomSource random = player.getRandom();
            ServerLevel level = (ServerLevel)player.getCommandSenderWorld();
            Item item = stack.getItem();
            if (!(item instanceof IllusionistsMantleItem) || !(relic = (IllusionistsMantleItem)item).isAbilityUnlocked(stack, "illusion") || relic.getStatValue(stack, "illusion", "chance") < (double)random.nextFloat()) {
                return;
            }
            Vec3 spawnPos = attacker.position().subtract(attacker.getLookAngle().normalize().scale(3.0));
            for (int i = 0; i < 10 && level.getBlockState(new BlockPos((int)spawnPos.x, (int)spawnPos.y, (int)spawnPos.z).above()).isSolid(); ++i) {
                spawnPos = spawnPos.add(0.0, 1.0, 0.0);
            }
            EntityDummy illusion = new EntityDummy((Level)level);
            illusion.ticksLeft = (int)Math.round(relic.getStatValue(stack, "illusion", "duration") * 20.0);
            illusion.setPos(spawnPos.x, spawnPos.y, spawnPos.z);
            illusion.setOwnerID(player.getUUID());
            illusion.getPersistentData().putBoolean("SpawnedFromRelic", true);
            level.addFreshEntity((Entity)illusion);
            level.sendParticles(ParticleUtils.constructSimpleSpark((Color)new Color(50 + random.nextInt(50), 150 + random.nextInt(106), 200 + random.nextInt(56)), (float)0.3f, (int)60, (float)0.95f), illusion.getX(), illusion.getY() + 0.4, illusion.getZ(), 15, 0.1, 0.1, 0.1, 0.1);
            relic.addEntities(stack, illusion.getUUID());
            relic.spreadRelicExperience((LivingEntity)player, stack, 1);
        }
    }
}

