/*
 * Decompiled with CFR 0.152.
 */
package it.hurts.octostudios.reliquified_ars_nouveau.items.back;

import com.google.common.collect.Lists;
import com.hollingsworth.arsnouveau.common.capability.ManaCap;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import it.hurts.octostudios.reliquified_ars_nouveau.init.ItemRegistry;
import it.hurts.octostudios.reliquified_ars_nouveau.items.NouveauRelicItem;
import it.hurts.octostudios.reliquified_ars_nouveau.items.base.loot.LootEntries;
import it.hurts.sskirillss.relics.client.models.items.CurioModel;
import it.hurts.sskirillss.relics.init.DataComponentRegistry;
import it.hurts.sskirillss.relics.items.relics.base.IRenderableCurio;
import it.hurts.sskirillss.relics.items.relics.base.data.RelicData;
import it.hurts.sskirillss.relics.items.relics.base.data.leveling.AbilitiesData;
import it.hurts.sskirillss.relics.items.relics.base.data.leveling.AbilityData;
import it.hurts.sskirillss.relics.items.relics.base.data.leveling.LevelingData;
import it.hurts.sskirillss.relics.items.relics.base.data.leveling.LevelingSourceData;
import it.hurts.sskirillss.relics.items.relics.base.data.leveling.LevelingSourcesData;
import it.hurts.sskirillss.relics.items.relics.base.data.leveling.StatData;
import it.hurts.sskirillss.relics.items.relics.base.data.leveling.misc.GemColor;
import it.hurts.sskirillss.relics.items.relics.base.data.leveling.misc.GemShape;
import it.hurts.sskirillss.relics.items.relics.base.data.leveling.misc.UpgradeOperation;
import it.hurts.sskirillss.relics.items.relics.base.data.loot.LootData;
import it.hurts.sskirillss.relics.items.relics.base.data.loot.LootEntry;
import it.hurts.sskirillss.relics.items.relics.base.data.style.BeamsData;
import it.hurts.sskirillss.relics.items.relics.base.data.style.StyleData;
import it.hurts.sskirillss.relics.items.relics.base.data.style.TooltipData;
import it.hurts.sskirillss.relics.utils.EntityUtils;
import it.hurts.sskirillss.relics.utils.MathUtils;
import it.hurts.sskirillss.relics.utils.ParticleUtils;
import java.awt.Color;
import java.util.List;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.model.HumanoidModel;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.ItemRenderer;
import net.minecraft.client.renderer.entity.RenderLayerParent;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.event.entity.living.ArmorHurtEvent;
import net.neoforged.neoforge.event.entity.living.LivingDamageEvent;
import net.neoforged.neoforge.event.entity.living.LivingDeathEvent;
import top.theillusivec4.curios.api.SlotContext;
import top.theillusivec4.curios.api.client.ICurioRenderer;

public class CloakOfConcealmentItem
extends NouveauRelicItem
implements IRenderableCurio {
    public RelicData constructDefaultRelicData() {
        return RelicData.builder().abilities(AbilitiesData.builder().ability(AbilityData.builder((String)"absorption").stat(StatData.builder((String)"absorbing").initialValue(200.0, 100.0).upgradeModifier(UpgradeOperation.MULTIPLY_BASE, -0.05).formatValue(value -> (int)MathUtils.round((double)(value / 2.0), (int)0)).build()).stat(StatData.builder((String)"cooldown").initialValue(60.0, 30.0).upgradeModifier(UpgradeOperation.MULTIPLY_BASE, -0.065).formatValue(value -> (int)MathUtils.round((double)value, (int)1)).build()).build()).build()).style(StyleData.builder().tooltip(TooltipData.builder().borderTop(-15699833).borderBottom(-10012636).textured(true).build()).beams(BeamsData.builder().startColor(-856560).endColor(539236).build()).build()).leveling(LevelingData.builder().initialCost(100).maxLevel(10).step(100).sources(LevelingSourcesData.builder().source(LevelingSourceData.abilityBuilder((String)"absorption").initialValue(1).gem(GemShape.SQUARE, GemColor.CYAN).build()).build()).build()).loot(LootData.builder().entry(new LootEntry[]{LootEntries.ARS_NOUVEAU, LootEntries.ARS_NOUVEAU_LIKE}).build()).build();
    }

    public void curioTick(SlotContext slotContext, ItemStack stack) {
        Player player;
        LivingEntity livingEntity = slotContext.entity();
        if (!(livingEntity instanceof Player) || (player = (Player)livingEntity).getCommandSenderWorld().isClientSide()) {
            return;
        }
        if (!this.getToggled(stack) && player.tickCount % 20 == 0) {
            this.addTime(stack, 1);
        }
        if (new ManaCap((LivingEntity)player).getCurrentMana() <= 3.0 || this.getTime(stack) > 0) {
            this.setToggled(stack, false);
        }
        if ((double)this.getTime(stack) >= this.getStatValue(stack, "absorption", "cooldown")) {
            this.setToggled(stack, true);
            this.setTime(stack, 0);
            Level level = player.getCommandSenderWorld();
            float height = player.getBbHeight();
            RandomSource random = level.getRandom();
            for (double angle = 0.0; angle < 360.0; angle += 60.0) {
                double rad = Math.toRadians(angle);
                Vec3 lineDirection = new Vec3(Math.cos(rad), 0.0, Math.sin(rad));
                for (double t = -1.0; t <= 1.0; t += 0.08) {
                    Vec3 centerParticlePos = player.position().add(lineDirection.scale(1.0)).add(lineDirection.scale((1.0 - t * t * 2.0) * (double)player.getBbWidth() * 0.8)).add(0.0, (double)(height / 2.0f) + t * (double)height * 0.8, 0.0);
                    CloakOfConcealmentItem.spawnParticle((ServerLevel)level, centerParticlePos, new Color(150 + random.nextInt(50), 50 + random.nextInt(50), 100 + random.nextInt(50)));
                }
            }
            level.playSound(null, (Entity)player, SoundEvents.PUFFER_FISH_DEATH, SoundSource.PLAYERS, 1.0f, 0.9f + random.nextFloat() * 0.2f);
        }
    }

    public void addTime(ItemStack stack, int time) {
        this.setTime(stack, this.getTime(stack) + time);
    }

    public void setTime(ItemStack stack, int time) {
        stack.set((Supplier)DataComponentRegistry.TIME, (Object)Math.max(time, 0));
    }

    public int getTime(ItemStack stack) {
        return (Integer)stack.getOrDefault((Supplier)DataComponentRegistry.TIME, (Object)0);
    }

    public void setToggled(ItemStack stack, boolean val) {
        stack.set((Supplier)DataComponentRegistry.TOGGLED, (Object)val);
    }

    public boolean getToggled(ItemStack stack) {
        return (Boolean)stack.getOrDefault((Supplier)DataComponentRegistry.TOGGLED, (Object)true);
    }

    private static void spawnParticle(ServerLevel level, Vec3 pos, Color color) {
        level.sendParticles(ParticleUtils.constructSimpleSpark((Color)color, (float)0.35f, (int)40, (float)0.9f), pos.x, pos.y, pos.z, 1, 0.01, 0.01, 0.01, 0.01);
    }

    @OnlyIn(value=Dist.CLIENT)
    public <T extends LivingEntity, M extends EntityModel<T>> void render(ItemStack stack, SlotContext slotContext, PoseStack matrixStack, RenderLayerParent<T, M> renderLayerParent, MultiBufferSource renderTypeBuffer, int light, float limbSwing, float limbSwingAmount, float partialTicks, float ageInTicks, float netHeadYaw, float headPitch) {
        CurioModel model = this.getModel(stack);
        matrixStack.pushPose();
        LivingEntity entity = slotContext.entity();
        model.prepareMobModel(entity, limbSwing, limbSwingAmount, partialTicks);
        model.setupAnim(entity, limbSwing, limbSwingAmount, ageInTicks, netHeadYaw, headPitch);
        ICurioRenderer.followBodyRotations((LivingEntity)entity, (HumanoidModel[])new HumanoidModel[]{model});
        VertexConsumer vertexconsumer = ItemRenderer.getArmorFoilBuffer((MultiBufferSource)renderTypeBuffer, (RenderType)RenderType.armorCutoutNoCull((ResourceLocation)this.getTexture(stack)), (boolean)stack.hasFoil());
        model.renderToBuffer(matrixStack, vertexconsumer, light, OverlayTexture.NO_OVERLAY);
        matrixStack.popPose();
    }

    @OnlyIn(value=Dist.CLIENT)
    public LayerDefinition constructLayerDefinition() {
        MeshDefinition mesh = HumanoidModel.createMesh((CubeDeformation)new CubeDeformation(0.4f), (float)0.0f);
        PartDefinition partdefinition = mesh.getRoot();
        PartDefinition bone = partdefinition.addOrReplaceChild("bone", CubeListBuilder.create(), PartPose.offset((float)8.0f, (float)24.0f, (float)-8.0f));
        PartDefinition left_arm = partdefinition.addOrReplaceChild("left_arm", CubeListBuilder.create().texOffs(26, 0).addBox(-1.0f, -2.0f, -2.0f, 4.0f, 12.0f, 4.0f, new CubeDeformation(0.3f)), PartPose.offset((float)-3.0f, (float)-22.0f, (float)8.0f));
        PartDefinition right_arm = partdefinition.addOrReplaceChild("right_arm", CubeListBuilder.create().texOffs(24, 23).addBox(-3.0f, -2.0f, -2.0f, 4.0f, 12.0f, 4.0f, new CubeDeformation(0.3f)), PartPose.offset((float)-13.0f, (float)-22.0f, (float)8.0f));
        PartDefinition head = partdefinition.addOrReplaceChild("head", CubeListBuilder.create(), PartPose.offset((float)-8.0f, (float)-24.0f, (float)8.0f));
        PartDefinition cube_r1 = head.addOrReplaceChild("cube_r1", CubeListBuilder.create().texOffs(0, 23).addBox(-2.5f, 0.0f, -3.0f, 7.0f, 3.0f, 5.0f, new CubeDeformation(0.05f)), PartPose.offsetAndRotation((float)-1.0f, (float)0.8087f, (float)5.1381f, (float)-0.7854f, (float)0.0f, (float)0.0f));
        PartDefinition body = partdefinition.addOrReplaceChild("body", CubeListBuilder.create().texOffs(26, 16).addBox(-4.5f, 0.0f, -3.0f, 9.0f, 2.0f, 0.0f, new CubeDeformation(0.005f)).texOffs(30, 18).addBox(4.5f, 0.0f, -3.0f, 0.0f, 2.0f, 2.0f, new CubeDeformation(0.005f)).texOffs(26, 18).addBox(-4.5f, 0.0f, -3.0f, 0.0f, 2.0f, 2.0f, new CubeDeformation(0.005f)).texOffs(0, 0).addBox(-4.5f, 0.0f, -1.0f, 9.0f, 19.0f, 4.0f, new CubeDeformation(0.0f)), PartPose.offset((float)-8.0f, (float)-24.0f, (float)8.001f));
        return LayerDefinition.create((MeshDefinition)mesh, (int)64, (int)64);
    }

    public List<String> headParts() {
        return Lists.newArrayList((Object[])new String[]{"head"});
    }

    public List<String> bodyParts() {
        return Lists.newArrayList((Object[])new String[]{"right_arm", "left_arm", "body"});
    }

    @EventBusSubscriber
    public static class CloakOfConcealmentItemEvent {
        @SubscribeEvent
        public static void onLivingDeath(LivingDeathEvent event) {
            CloakOfConcealmentItem relic;
            Player player;
            LivingEntity livingEntity = event.getEntity();
            if (!(livingEntity instanceof Player) || (player = (Player)livingEntity).getCommandSenderWorld().isClientSide()) {
                return;
            }
            ItemStack stack = EntityUtils.findEquippedCurio((Entity)player, (Item)((Item)ItemRegistry.CLOAK_OF_CONCEALMENT.value()));
            Item item = stack.getItem();
            if (!(item instanceof CloakOfConcealmentItem) || !(relic = (CloakOfConcealmentItem)item).isAbilityUnlocked(stack, "absorption")) {
                return;
            }
            relic.setTime(stack, 0);
            relic.setToggled(stack, true);
        }

        @SubscribeEvent
        public static void onArmorHurt(ArmorHurtEvent event) {
            CloakOfConcealmentItem relic;
            Player player;
            LivingEntity livingEntity = event.getEntity();
            if (!(livingEntity instanceof Player) || (player = (Player)livingEntity).getCommandSenderWorld().isClientSide()) {
                return;
            }
            ItemStack stack = EntityUtils.findEquippedCurio((Entity)player, (Item)((Item)ItemRegistry.CLOAK_OF_CONCEALMENT.value()));
            Item item = stack.getItem();
            if (!(item instanceof CloakOfConcealmentItem && (relic = (CloakOfConcealmentItem)item).isAbilityUnlocked(stack, "absorption") && relic.getToggled(stack))) {
                return;
            }
            event.setCanceled(true);
        }

        @SubscribeEvent
        public static void onInjuredEntity(LivingDamageEvent.Pre event) {
            CloakOfConcealmentItem relic;
            Player player;
            LivingEntity livingEntity = event.getEntity();
            if (!(livingEntity instanceof Player) || (player = (Player)livingEntity).getCommandSenderWorld().isClientSide()) {
                return;
            }
            ItemStack stack = EntityUtils.findEquippedCurio((Entity)player, (Item)((Item)ItemRegistry.CLOAK_OF_CONCEALMENT.value()));
            Item item = stack.getItem();
            if (!(item instanceof CloakOfConcealmentItem && (relic = (CloakOfConcealmentItem)item).isAbilityUnlocked(stack, "absorption") && relic.getToggled(stack))) {
                return;
            }
            ManaCap mana = new ManaCap((LivingEntity)player);
            double statValue = MathUtils.round((double)relic.getStatValue(stack, "absorption", "absorbing"), (int)0);
            if (mana.getCurrentMana() < statValue / 2.0) {
                return;
            }
            float damage = event.getNewDamage();
            double absorbanceDamage = Math.min((double)damage, mana.getCurrentMana() * 2.0 / statValue);
            mana.removeMana(absorbanceDamage * (statValue / 2.0));
            event.setNewDamage((float)((double)damage - absorbanceDamage));
            CloakOfConcealmentItemEvent.spawnBarrierParticles(player, event.getSource().getEntity(), (ServerLevel)player.getCommandSenderWorld());
            if (damage >= 3.0f) {
                relic.spreadRelicExperience((LivingEntity)player, stack, 1);
            }
        }

        public static void spawnBarrierParticles(Player player, @Nullable Entity attacker, ServerLevel level) {
            Vec3 playerPos = player.position();
            float width = player.getBbWidth();
            float height = player.getBbHeight();
            RandomSource random = level.getRandom();
            Color color = new Color(100 + random.nextInt(50), 50 + random.nextInt(50), 150 + random.nextInt(50));
            if (attacker != null) {
                Vec3 attackDirection = attacker.getPosition(1.0f).subtract(playerPos).normalize();
                Vec3 perpendicularDirection = new Vec3(-attackDirection.z, 0.0, attackDirection.x).normalize().scale(0.4);
                for (double t = -1.0; t <= 1.0; t += 0.08) {
                    Vec3 centerParticlePos = playerPos.add(attackDirection.scale(1.0 - t * t * 2.0 * (double)width * 0.8)).add(0.0, (double)(height / 2.0f) + t * (double)height + 0.8, 0.0);
                    CloakOfConcealmentItem.spawnParticle(level, centerParticlePos, color);
                    if (!(Math.abs(t) <= 0.7)) continue;
                    CloakOfConcealmentItem.spawnParticle(level, centerParticlePos.add(perpendicularDirection), color);
                    CloakOfConcealmentItem.spawnParticle(level, centerParticlePos.subtract(perpendicularDirection), color);
                }
            } else {
                for (double angle = 0.0; angle < 360.0; angle += 60.0) {
                    double rad = Math.toRadians(angle);
                    Vec3 lineDirection = new Vec3(Math.cos(rad), 0.0, Math.sin(rad));
                    for (double t = -1.0; t <= 1.0; t += 0.08) {
                        Vec3 centerParticlePos = playerPos.add(lineDirection.scale(1.0)).add(lineDirection.scale(1.0 - t * t * 2.0 * (double)width * 0.8)).add(0.0, (double)(height / 2.0f) + t * (double)height + 0.8, 0.0);
                        CloakOfConcealmentItem.spawnParticle(level, centerParticlePos, color);
                    }
                }
            }
        }
    }
}

