/*
 * Decompiled with CFR 0.152.
 */
package it.hurts.octostudios.reliquified_ars_nouveau.entities;

import com.hollingsworth.arsnouveau.client.particle.GlowParticleData;
import com.hollingsworth.arsnouveau.client.particle.ParticleColor;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.entity.projectile.ThrowableProjectile;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.Vec3;

public class MagicShellEntity
extends ThrowableProjectile {
    private static final EntityDataAccessor<Float> DAMAGE = SynchedEntityData.defineId(MagicShellEntity.class, (EntityDataSerializer)EntityDataSerializers.FLOAT);

    public MagicShellEntity(EntityType<? extends ThrowableProjectile> entityType, Level level) {
        super(entityType, level);
        this.setNoGravity(true);
    }

    public void tick() {
        double targetSpeed;
        Entity entity;
        super.tick();
        Level level = this.getCommandSenderWorld();
        double deltaX = this.getX() - this.xo;
        double deltaY = this.getY() - this.yo;
        double deltaZ = this.getZ() - this.zo;
        for (float coeff = 0.0f; coeff <= 1.0f; coeff += 0.2f) {
            level.addParticle(GlowParticleData.createData((ParticleColor)new ParticleColor(255, 25, 180)), true, this.xo + deltaX * (double)coeff, this.yo + deltaY * (double)coeff + (double)(this.getBbHeight() / 2.0f), this.zo + deltaZ * (double)coeff, (double)(0.0125f * (this.random.nextFloat() - 0.5f)), (double)(0.0125f * (this.random.nextFloat() - 0.5f)), (double)(0.0125f * (this.random.nextFloat() - 0.5f)));
        }
        if (level.isClientSide()) {
            return;
        }
        CompoundTag persistentData = this.getPersistentData();
        if (this.tickCount >= 300) {
            return;
        }
        Vec3 targetVec = Vec3.ZERO;
        boolean curveFactor = true;
        if (persistentData.contains("TargetUUID") && (entity = ((ServerLevel)level).getEntity(persistentData.getUUID("TargetUUID"))) instanceof Projectile) {
            Projectile projectileTarget = (Projectile)entity;
            targetVec = projectileTarget.position();
            targetSpeed = projectileTarget.getDeltaMovement().length() * 0.8;
        } else {
            curveFactor = false;
            targetSpeed = 0.9f;
            if (persistentData.contains("HitEntity")) {
                LivingEntity targetEntity;
                Entity entity2 = ((ServerLevel)level).getEntity(persistentData.getUUID("HitEntity"));
                if (!(entity2 instanceof LivingEntity) || !(targetEntity = (LivingEntity)entity2).isAlive()) {
                    this.discard();
                    return;
                }
                targetVec = targetEntity.position();
            }
            if (persistentData.contains("HitPosX") && persistentData.contains("HitPosY") && persistentData.contains("HitPosZ")) {
                double hitX = persistentData.getDouble("HitPosX");
                double hitY = persistentData.getDouble("HitPosY");
                double hitZ = persistentData.getDouble("HitPosZ");
                targetVec = new Vec3(hitX, hitY, hitZ);
            }
        }
        Vec3 toTarget = targetVec.subtract(this.position());
        Vec3 directionToTarget = toTarget.normalize();
        int bowIndex = persistentData.getInt("BowIndex");
        int time = this.tickCount + bowIndex * 20;
        Vec3 perpendicular1 = directionToTarget.cross(new Vec3(0.0, 1.0, 0.0)).normalize();
        Vec3 perpendicular2 = directionToTarget.cross(perpendicular1).normalize();
        double curveAmount = Math.min(1.0, toTarget.length() / 10.0) * (double)curveFactor;
        Vec3 spiralOffset = perpendicular1.scale(Math.sin((double)time * 0.1 + (double)bowIndex) * 0.4 * curveAmount).add(perpendicular2.scale(Math.cos((double)time * 0.12 + (double)bowIndex) * 0.4 * curveAmount));
        this.setDeltaMovement(directionToTarget.add(spiralOffset).normalize().scale(targetSpeed));
    }

    protected void onHitEntity(EntityHitResult result) {
        LivingEntity target;
        Level level;
        block3: {
            block2: {
                super.onHitEntity(result);
                level = this.getCommandSenderWorld();
                Entity entity = result.getEntity();
                if (!(entity instanceof LivingEntity)) break block2;
                target = (LivingEntity)entity;
                if (!level.isClientSide()) break block3;
            }
            return;
        }
        target.invulnerableTime = 0;
        target.hurt(level.damageSources().thrown((Entity)this, this.getOwner()), this.getDamage());
        this.discard();
    }

    protected void onHitBlock(BlockHitResult result) {
        super.onHitBlock(result);
        CompoundTag persistentData = this.getPersistentData();
        Vec3 currentPosition = this.position();
        if (persistentData.contains("HitPosX") && persistentData.contains("HitPosY") && persistentData.contains("HitPosZ")) {
            double hitX = persistentData.getDouble("HitPosX");
            double hitY = persistentData.getDouble("HitPosY");
            double hitZ = persistentData.getDouble("HitPosZ");
            Vec3 vec3 = new Vec3(hitX, hitY, hitZ);
            if (currentPosition.distanceTo(vec3) <= 0.5) {
                this.discard();
            }
        }
    }

    protected void defineSynchedData(SynchedEntityData.Builder builder) {
        builder.define(DAMAGE, (Object)Float.valueOf(0.0f));
    }

    public void addAdditionalSaveData(CompoundTag tag) {
        super.addAdditionalSaveData(tag);
        tag.putFloat("damage", this.getDamage());
    }

    public void readAdditionalSaveData(CompoundTag tag) {
        super.readAdditionalSaveData(tag);
        this.setDamage(tag.getFloat("damage"));
    }

    public void setDamage(float heal) {
        this.getEntityData().set(DAMAGE, (Object)Float.valueOf(heal));
    }

    public float getDamage() {
        return ((Float)this.getEntityData().get(DAMAGE)).floatValue();
    }
}

