/*
 * Decompiled with CFR 0.152.
 */
package it.hurts.octostudios.rarcompat.items.charm;

import artifacts.registry.ModItems;
import it.hurts.octostudios.rarcompat.items.WearableRelicItem;
import it.hurts.sskirillss.relics.items.relics.base.data.RelicAttributeModifier;
import it.hurts.sskirillss.relics.items.relics.base.data.RelicData;
import it.hurts.sskirillss.relics.items.relics.base.data.leveling.AbilitiesData;
import it.hurts.sskirillss.relics.items.relics.base.data.leveling.AbilityData;
import it.hurts.sskirillss.relics.items.relics.base.data.leveling.LevelingData;
import it.hurts.sskirillss.relics.items.relics.base.data.leveling.LevelingSourceData;
import it.hurts.sskirillss.relics.items.relics.base.data.leveling.LevelingSourcesData;
import it.hurts.sskirillss.relics.items.relics.base.data.leveling.StatData;
import it.hurts.sskirillss.relics.items.relics.base.data.leveling.misc.GemColor;
import it.hurts.sskirillss.relics.items.relics.base.data.leveling.misc.GemShape;
import it.hurts.sskirillss.relics.items.relics.base.data.leveling.misc.UpgradeOperation;
import it.hurts.sskirillss.relics.items.relics.base.data.loot.LootData;
import it.hurts.sskirillss.relics.items.relics.base.data.loot.LootEntry;
import it.hurts.sskirillss.relics.items.relics.base.data.loot.misc.LootEntries;
import it.hurts.sskirillss.relics.items.relics.base.data.research.ResearchData;
import it.hurts.sskirillss.relics.items.relics.base.data.style.BeamsData;
import it.hurts.sskirillss.relics.items.relics.base.data.style.StyleData;
import it.hurts.sskirillss.relics.items.relics.base.data.style.TooltipData;
import it.hurts.sskirillss.relics.utils.EntityUtils;
import it.hurts.sskirillss.relics.utils.MathUtils;
import net.minecraft.core.Holder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.event.entity.living.LivingHealEvent;
import top.theillusivec4.curios.api.SlotContext;

public class CrystalHeartItem
extends WearableRelicItem {
    public RelicData constructDefaultRelicData() {
        return RelicData.builder().abilities(AbilitiesData.builder().ability(AbilityData.builder((String)"heart").stat(StatData.builder((String)"amount").initialValue(2.0, 6.0).upgradeModifier(UpgradeOperation.MULTIPLY_BASE, 0.2).formatValue(value -> (int)MathUtils.round((double)value, (int)1)).build()).research(ResearchData.builder().star(0, 6, 12).star(1, 16, 12).star(2, 11, 22).link(0, 1).link(1, 2).link(2, 0).link(1, 0).build()).build()).build()).style(StyleData.builder().tooltip(TooltipData.builder().borderTop(-1435881).borderBottom(-8585216).build()).beams(BeamsData.builder().startColor(-2751484).endColor(0xF26F6F).build()).build()).leveling(LevelingData.builder().initialCost(100).maxLevel(10).step(100).sources(LevelingSourcesData.builder().source(LevelingSourceData.abilityBuilder((String)"heart").initialValue(1).gem(GemShape.SQUARE, GemColor.ORANGE).build()).build()).build()).loot(LootData.builder().entry(new LootEntry[]{LootEntries.CAVE, LootEntries.MINESHAFT}).build()).build();
    }

    public RelicAttributeModifier getRelicAttributeModifiers(ItemStack stack) {
        if (!this.isAbilityUnlocked(stack, "heart")) {
            return super.getRelicAttributeModifiers(stack);
        }
        return RelicAttributeModifier.builder().attribute(new RelicAttributeModifier.Modifier(Attributes.MAX_HEALTH, (float)this.getStatValue(stack, "heart", "amount"), AttributeModifier.Operation.ADD_VALUE)).build();
    }

    public void onUnequip(SlotContext slotContext, ItemStack newStack, ItemStack stack) {
        Player player;
        block3: {
            block2: {
                LivingEntity livingEntity = slotContext.entity();
                if (!(livingEntity instanceof Player)) break block2;
                player = (Player)livingEntity;
                if (newStack.getItem() != stack.getItem()) break block3;
            }
            return;
        }
        EntityUtils.removeAttribute((LivingEntity)player, (ItemStack)stack, (Holder)Attributes.MAX_HEALTH, (AttributeModifier.Operation)AttributeModifier.Operation.ADD_VALUE);
    }

    @EventBusSubscriber
    public static class CrystalHeartEvent {
        @SubscribeEvent
        public static void onLivingHealEvent(LivingHealEvent event) {
            CrystalHeartItem relic;
            LivingEntity livingEntity = event.getEntity();
            if (!(livingEntity instanceof Player)) {
                return;
            }
            Player player = (Player)livingEntity;
            ItemStack stack = EntityUtils.findEquippedCurio((Entity)event.getEntity(), (Item)((Item)ModItems.CRYSTAL_HEART.value()));
            Item item = stack.getItem();
            if (!(item instanceof CrystalHeartItem) || !(relic = (CrystalHeartItem)item).isAbilityUnlocked(stack, "heart")) {
                return;
            }
            float maxHealth = player.getMaxHealth();
            if ((double)player.getRandom().nextFloat() <= Math.max(0.1, (double)((maxHealth - player.getHealth()) / maxHealth))) {
                relic.spreadRelicExperience((LivingEntity)player, stack, 1);
            }
        }
    }
}

