/*
 * Decompiled with CFR 0.152.
 */
package it.hurts.octostudios.rarcompat.items.bracelet;

import artifacts.registry.ModItems;
import it.hurts.octostudios.rarcompat.items.WearableRelicItem;
import it.hurts.sskirillss.relics.items.relics.base.data.RelicData;
import it.hurts.sskirillss.relics.items.relics.base.data.leveling.AbilitiesData;
import it.hurts.sskirillss.relics.items.relics.base.data.leveling.AbilityData;
import it.hurts.sskirillss.relics.items.relics.base.data.leveling.LevelingData;
import it.hurts.sskirillss.relics.items.relics.base.data.leveling.LevelingSourceData;
import it.hurts.sskirillss.relics.items.relics.base.data.leveling.LevelingSourcesData;
import it.hurts.sskirillss.relics.items.relics.base.data.leveling.StatData;
import it.hurts.sskirillss.relics.items.relics.base.data.leveling.misc.GemColor;
import it.hurts.sskirillss.relics.items.relics.base.data.leveling.misc.GemShape;
import it.hurts.sskirillss.relics.items.relics.base.data.leveling.misc.UpgradeOperation;
import it.hurts.sskirillss.relics.items.relics.base.data.loot.LootData;
import it.hurts.sskirillss.relics.items.relics.base.data.loot.LootEntry;
import it.hurts.sskirillss.relics.items.relics.base.data.loot.misc.LootEntries;
import it.hurts.sskirillss.relics.items.relics.base.data.research.ResearchData;
import it.hurts.sskirillss.relics.items.relics.base.data.style.BeamsData;
import it.hurts.sskirillss.relics.items.relics.base.data.style.StyleData;
import it.hurts.sskirillss.relics.items.relics.base.data.style.TooltipData;
import it.hurts.sskirillss.relics.utils.EntityUtils;
import it.hurts.sskirillss.relics.utils.MathUtils;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.food.FoodData;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.event.entity.player.PlayerEvent;
import net.neoforged.neoforge.event.level.BlockEvent;

public class OnionRingItem
extends WearableRelicItem {
    public RelicData constructDefaultRelicData() {
        return RelicData.builder().abilities(AbilitiesData.builder().ability(AbilityData.builder((String)"onion").stat(StatData.builder((String)"amount").initialValue(0.01, 0.015).upgradeModifier(UpgradeOperation.MULTIPLY_BASE, 0.2).formatValue(value -> MathUtils.round((double)(value * 100.0), (int)1)).build()).research(ResearchData.builder().star(0, 11, 25).star(1, 5, 21).star(2, 3, 14).star(3, 5, 7).star(4, 11, 4).star(5, 17, 7).star(6, 19, 14).star(7, 17, 21).star(8, 6, 11).star(9, 11, 10).star(10, 16, 11).link(0, 1).link(1, 2).link(2, 3).link(3, 4).link(4, 5).link(5, 6).link(6, 7).link(7, 0).link(0, 9).link(8, 9).link(9, 10).link(2, 8).link(10, 6).build()).build()).ability(AbilityData.builder((String)"saturation").requiredLevel(5).stat(StatData.builder((String)"chance").initialValue(0.05, 0.15).upgradeModifier(UpgradeOperation.MULTIPLY_BASE, 0.1).formatValue(value -> MathUtils.round((double)(value * 100.0), (int)1)).build()).build()).build()).style(StyleData.builder().tooltip(TooltipData.builder().borderTop(-1014486).borderBottom(-7126255).build()).beams(BeamsData.builder().startColor(-216479).endColor(7352070).build()).build()).leveling(LevelingData.builder().initialCost(100).maxLevel(15).step(100).sources(LevelingSourcesData.builder().source(LevelingSourceData.abilityBuilder((String)"onion").initialValue(1).gem(GemShape.SQUARE, GemColor.YELLOW).build()).source(LevelingSourceData.abilityBuilder((String)"saturation").initialValue(1).gem(GemShape.SQUARE, GemColor.YELLOW).build()).build()).build()).loot(LootData.builder().entry(new LootEntry[]{LootEntries.CAVE, LootEntries.MINESHAFT}).build()).build();
    }

    @EventBusSubscriber
    public static class OnionRingEvent {
        @SubscribeEvent
        public static void onBreakSpeed(PlayerEvent.BreakSpeed event) {
            OnionRingItem relic;
            Player player = event.getEntity();
            ItemStack stack = EntityUtils.findEquippedCurio((Entity)player, (Item)((Item)ModItems.ONION_RING.value()));
            Item item = stack.getItem();
            if (!(item instanceof OnionRingItem) || !(relic = (OnionRingItem)item).isAbilityUnlocked(stack, "onion")) {
                return;
            }
            int currentHunger = player.getFoodData().getFoodLevel();
            double modifier = relic.getStatValue(stack, "onion", "amount");
            event.setNewSpeed((float)((double)event.getNewSpeed() + (double)event.getNewSpeed() * ((double)currentHunger * modifier)));
        }

        @SubscribeEvent
        public static void onBlockDestroy(BlockEvent.BreakEvent event) {
            Player player = event.getPlayer();
            ItemStack stack = EntityUtils.findEquippedCurio((Entity)player, (Item)((Item)ModItems.ONION_RING.value()));
            Item item = stack.getItem();
            if (!(item instanceof OnionRingItem)) {
                return;
            }
            OnionRingItem relic = (OnionRingItem)item;
            RandomSource random = player.getRandom();
            if (relic.isAbilityUnlocked(stack, "onion") && (double)event.getState().getDestroySpeed((BlockGetter)player.level(), player.blockPosition()) >= 0.5 && (double)player.getFoodData().getFoodLevel() / 20.0 >= random.nextDouble()) {
                relic.spreadRelicExperience((LivingEntity)player, stack, 1);
            }
            FoodData footData = player.getFoodData();
            if (relic.isAbilityUnlocked(stack, "saturation") && random.nextDouble() <= relic.getStatValue(stack, "saturation", "chance") && footData.needsFood()) {
                footData.add(1, 0.5f);
                relic.spreadRelicExperience((LivingEntity)player, stack, 1);
            }
        }
    }
}

