/*
 * Decompiled with CFR 0.152.
 */
package com.gametechbc.gametechbcsspellbooks.spells.holy;

import com.gametechbc.gametechbcsspellbooks.api.spells.GSSpellAnimations;
import com.gametechbc.gametechbcsspellbooks.init.GSEffects;
import com.gametechbc.gametechbcsspellbooks.init.GSSounds;
import com.gametechbc.spelllib.particle.AdvancedCylinderParticleManager;
import com.gametechbc.spelllib.particle.ParticleDirection;
import io.redspace.ironsspellbooks.api.config.DefaultConfig;
import io.redspace.ironsspellbooks.api.magic.MagicData;
import io.redspace.ironsspellbooks.api.registry.AttributeRegistry;
import io.redspace.ironsspellbooks.api.registry.SchoolRegistry;
import io.redspace.ironsspellbooks.api.spells.AbstractSpell;
import io.redspace.ironsspellbooks.api.spells.AutoSpellConfig;
import io.redspace.ironsspellbooks.api.spells.CastSource;
import io.redspace.ironsspellbooks.api.spells.CastType;
import io.redspace.ironsspellbooks.api.spells.SchoolType;
import io.redspace.ironsspellbooks.api.spells.SpellRarity;
import io.redspace.ironsspellbooks.api.util.AnimationHolder;
import io.redspace.ironsspellbooks.api.util.CameraShakeData;
import io.redspace.ironsspellbooks.api.util.CameraShakeManager;
import io.redspace.ironsspellbooks.api.util.Utils;
import io.redspace.ironsspellbooks.capabilities.magic.MagicManager;
import io.redspace.ironsspellbooks.capabilities.magic.RecastInstance;
import io.redspace.ironsspellbooks.damage.DamageSources;
import io.redspace.ironsspellbooks.particle.BlastwaveParticleOptions;
import io.redspace.ironsspellbooks.util.ParticleHelper;
import java.util.List;
import java.util.Optional;
import net.minecraft.core.Holder;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;

@AutoSpellConfig
public class NullflareSpell
extends AbstractSpell {
    private final ResourceLocation spellId = new ResourceLocation("gametechbcs_spellbooks", "nullflare");
    private final DefaultConfig defaultConfig = new DefaultConfig().setMinRarity(SpellRarity.COMMON).setSchoolResource(SchoolRegistry.HOLY_RESOURCE).setMaxLevel(5).setCooldownSeconds(30.0).build();

    public NullflareSpell() {
        this.manaCostPerLevel = 50;
        this.baseSpellPower = 1;
        this.spellPowerPerLevel = 1;
        this.castTime = 16;
        this.baseManaCost = 60;
    }

    public CastType getCastType() {
        return CastType.LONG;
    }

    public DefaultConfig getDefaultConfig() {
        return this.defaultConfig;
    }

    public ResourceLocation getSpellResource() {
        return this.spellId;
    }

    public AnimationHolder getCastStartAnimation() {
        return GSSpellAnimations.NULLFLARE_START;
    }

    public AnimationHolder getCastFinishAnimation() {
        return GSSpellAnimations.NULLFLARE_FINISH;
    }

    public Optional<SoundEvent> getCastStartSound() {
        return Optional.of((SoundEvent)GSSounds.NULLFLARE_TWO.get());
    }

    public Optional<SoundEvent> getCastFinishSound() {
        return Optional.empty();
    }

    public int getRecastCount(int spellLevel, LivingEntity caster) {
        return 5;
    }

    public boolean stopSoundOnCancel() {
        return true;
    }

    public void onCast(Level level, int spellLevel, LivingEntity caster, CastSource castSource, MagicData playerMagicData) {
        boolean isCrouching;
        float radius = this.getRange(spellLevel);
        int duration = (int)this.getEffectDuration();
        CameraShakeManager.addCameraShake((CameraShakeData)new CameraShakeData(15, caster.position(), radius));
        if (!playerMagicData.getPlayerRecasts().hasRecastForSpell(this.getSpellId())) {
            playerMagicData.getPlayerRecasts().addRecast(new RecastInstance(this.getSpellId(), spellLevel, this.getRecastCount(spellLevel, caster), 300, castSource, null), playerMagicData);
        }
        if (isCrouching = caster.isCrouching()) {
            MagicManager.spawnParticles((Level)level, (ParticleOptions)new BlastwaveParticleOptions(((SchoolType)SchoolRegistry.FIRE.get()).getTargetingColor(), radius), (double)caster.getX(), (double)(caster.getY() + (double)0.165f), (double)caster.getZ(), (int)1, (double)0.0, (double)0.0, (double)0.0, (double)0.0, (boolean)true);
        } else {
            MagicManager.spawnParticles((Level)level, (ParticleOptions)new BlastwaveParticleOptions(((SchoolType)SchoolRegistry.ICE.get()).getTargetingColor(), radius), (double)caster.getX(), (double)(caster.getY() + (double)0.165f), (double)caster.getZ(), (int)1, (double)0.0, (double)0.0, (double)0.0, (double)0.0, (boolean)true);
        }
        level.getEntities((Entity)caster, caster.getBoundingBox().inflate((double)radius, 4.0, (double)radius), target -> !DamageSources.isFriendlyFireBetween((Entity)target, (Entity)caster)).forEach(target -> {
            LivingEntity livingEntity;
            if (target instanceof LivingEntity && (livingEntity = (LivingEntity)target).distanceToSqr((Entity)caster) < (double)(radius * radius)) {
                float baseDamage = this.getDamage(spellLevel, caster);
                if (isCrouching) {
                    MobEffectInstance fireEffect;
                    MobEffectInstance iceEffect = livingEntity.getEffect(GSEffects.NULLFLARE_ICE);
                    if (iceEffect != null) {
                        AdvancedCylinderParticleManager.spawnParticles((Level)level, (Vec3)caster.position(), (int)15, (ParticleOptions)ParticleTypes.CAMPFIRE_COSY_SMOKE, (ParticleDirection)ParticleDirection.OUTWARD, (double)2.0, (double)2.0, (double)0.0, (double)0.0, (double)0.0, (double)1.5, (boolean)false);
                        MagicManager.spawnParticles((Level)level, (ParticleOptions)ParticleHelper.EMBERS, (double)livingEntity.getX(), (double)(livingEntity.getY() + 1.0), (double)livingEntity.getZ(), (int)30, (double)0.0, (double)0.0, (double)0.0, (double)0.3, (boolean)false);
                        livingEntity.removeEffect(GSEffects.NULLFLARE_ICE);
                        int amplifier = iceEffect.getAmplifier();
                        double fireSpellPower = caster.getAttributeValue((Holder)AttributeRegistry.FIRE_SPELL_POWER);
                        double scaledDamage = (double)baseDamage * fireSpellPower * (1.0 + 0.85 * (double)amplifier);
                        DamageSources.applyDamage((Entity)livingEntity, (float)((float)scaledDamage), (DamageSource)this.getDamageSource((Entity)caster));
                    }
                    if ((fireEffect = livingEntity.getEffect(GSEffects.NULLFLARE_FIRE)) != null) {
                        livingEntity.addEffect(new MobEffectInstance(GSEffects.NULLFLARE_FIRE, duration, fireEffect.getAmplifier() + 1));
                    } else {
                        livingEntity.addEffect(new MobEffectInstance(GSEffects.NULLFLARE_FIRE, duration, 0));
                    }
                } else {
                    MobEffectInstance iceEffect;
                    MobEffectInstance fireEffect = livingEntity.getEffect(GSEffects.NULLFLARE_FIRE);
                    if (fireEffect != null) {
                        AdvancedCylinderParticleManager.spawnParticles((Level)level, (Vec3)caster.position(), (int)15, (ParticleOptions)ParticleTypes.CAMPFIRE_COSY_SMOKE, (ParticleDirection)ParticleDirection.OUTWARD, (double)2.0, (double)2.0, (double)0.0, (double)0.0, (double)0.0, (double)1.5, (boolean)false);
                        MagicManager.spawnParticles((Level)level, (ParticleOptions)ParticleHelper.EMBERS, (double)livingEntity.getX(), (double)(livingEntity.getY() + 1.0), (double)livingEntity.getZ(), (int)30, (double)0.0, (double)0.0, (double)0.0, (double)0.3, (boolean)false);
                        livingEntity.removeEffect(GSEffects.NULLFLARE_FIRE);
                        int amplifier = fireEffect.getAmplifier();
                        double iceSpellPower = caster.getAttributeValue((Holder)AttributeRegistry.ICE_SPELL_POWER);
                        double scaledDamage = (double)baseDamage * iceSpellPower * (1.0 + 0.85 * (double)amplifier);
                        DamageSources.applyDamage((Entity)livingEntity, (float)((float)scaledDamage), (DamageSource)this.getDamageSource((Entity)caster));
                    }
                    if ((iceEffect = livingEntity.getEffect(GSEffects.NULLFLARE_ICE)) != null) {
                        livingEntity.addEffect(new MobEffectInstance(GSEffects.NULLFLARE_ICE, duration, iceEffect.getAmplifier() + 1));
                    } else {
                        livingEntity.addEffect(new MobEffectInstance(GSEffects.NULLFLARE_ICE, duration, 0));
                    }
                }
            }
        });
        super.onCast(level, spellLevel, caster, castSource, playerMagicData);
    }

    private float getDamage(int spellLevel, LivingEntity caster) {
        float spellPower = this.getSpellPower(spellLevel, (Entity)caster);
        return 5.0f + spellPower * 4.5f;
    }

    private String getFireDamageText(int spellLevel, LivingEntity caster) {
        if (caster != null) {
            float baseDamage = this.getDamage(spellLevel, caster);
            double fireSpellPower = caster.getAttributes().hasAttribute((Holder)AttributeRegistry.FIRE_SPELL_POWER) ? caster.getAttributeValue((Holder)AttributeRegistry.FIRE_SPELL_POWER) : 1.0;
            float finalDamage = (float)((double)baseDamage * fireSpellPower);
            String baseDamageText = Utils.stringTruncation((double)baseDamage, (int)1);
            String finalDamageText = Utils.stringTruncation((double)finalDamage, (int)1);
            if (fireSpellPower > 1.0) {
                return String.format("%s -> %s", baseDamageText, finalDamageText);
            }
            return baseDamageText;
        }
        return Utils.stringTruncation((double)this.getDamage(spellLevel, caster), (int)1);
    }

    private String getIceDamageText(int spellLevel, LivingEntity caster) {
        if (caster != null) {
            float baseDamage = this.getDamage(spellLevel, caster);
            double iceSpellPower = caster.getAttributes().hasAttribute((Holder)AttributeRegistry.ICE_SPELL_POWER) ? caster.getAttributeValue((Holder)AttributeRegistry.ICE_SPELL_POWER) : 1.0;
            float finalDamage = (float)((double)baseDamage * iceSpellPower);
            String baseDamageText = Utils.stringTruncation((double)baseDamage, (int)1);
            String finalDamageText = Utils.stringTruncation((double)finalDamage, (int)1);
            if (iceSpellPower > 1.0) {
                return String.format("%s -> %s", baseDamageText, finalDamageText);
            }
            return baseDamageText;
        }
        return Utils.stringTruncation((double)this.getDamage(spellLevel, caster), (int)1);
    }

    private float getRange(int spellLevel) {
        return 2.0f + (float)spellLevel * 2.0f;
    }

    private float getEffectDuration() {
        return 200.0f;
    }

    public List<MutableComponent> getUniqueInfo(int spellLevel, LivingEntity caster) {
        return List.of(Component.translatable((String)"ui.gametechbcs_spellbooks.nullflare_blast"), Component.translatable((String)"ui.gametechbcs_spellbooks.nullflare_blast_fire_damage", (Object[])new Object[]{this.getFireDamageText(spellLevel, caster)}), Component.translatable((String)"ui.gametechbcs_spellbooks.nullflare_blast_ice_damage", (Object[])new Object[]{this.getIceDamageText(spellLevel, caster)}), Component.translatable((String)"ui.gametechbcs_spellbooks.radius", (Object[])new Object[]{Utils.stringTruncation((double)this.getRange(spellLevel), (int)2)}), Component.translatable((String)"ui.gametechbcs_spellbooks.nullflare_blast.stacks"), Component.literal((String)"\u00a79GTBC's Spellbooks"));
    }
}

