/*
 * Decompiled with CFR 0.152.
 */
package com.gametechbc.gametechbcsspellbooks.spells.holy;

import com.gametechbc.gametechbcsspellbooks.api.spells.GSSpellAnimations;
import com.gametechbc.gametechbcsspellbooks.init.GSSounds;
import com.gametechbc.gametechbcsspellbooks.util.GSDamageTypes;
import com.gametechbc.gametechbcsspellbooks.util.GSTags;
import com.gametechbc.spelllib.particle.CylinderParticleManager;
import com.gametechbc.spelllib.particle.ParticleDirection;
import io.redspace.ironsspellbooks.api.config.DefaultConfig;
import io.redspace.ironsspellbooks.api.entity.IMagicEntity;
import io.redspace.ironsspellbooks.api.magic.MagicData;
import io.redspace.ironsspellbooks.api.registry.SchoolRegistry;
import io.redspace.ironsspellbooks.api.spells.AbstractSpell;
import io.redspace.ironsspellbooks.api.spells.AutoSpellConfig;
import io.redspace.ironsspellbooks.api.spells.CastSource;
import io.redspace.ironsspellbooks.api.spells.CastType;
import io.redspace.ironsspellbooks.api.spells.SchoolType;
import io.redspace.ironsspellbooks.api.spells.SpellRarity;
import io.redspace.ironsspellbooks.api.util.AnimationHolder;
import io.redspace.ironsspellbooks.api.util.CameraShakeData;
import io.redspace.ironsspellbooks.api.util.CameraShakeManager;
import io.redspace.ironsspellbooks.api.util.Utils;
import io.redspace.ironsspellbooks.capabilities.magic.MagicManager;
import io.redspace.ironsspellbooks.capabilities.magic.RecastResult;
import io.redspace.ironsspellbooks.entity.mobs.AntiMagicSusceptible;
import io.redspace.ironsspellbooks.entity.mobs.IMagicSummon;
import io.redspace.ironsspellbooks.particle.BlastwaveParticleOptions;
import io.redspace.ironsspellbooks.particle.ShockwaveParticleOptions;
import io.redspace.ironsspellbooks.util.ParticleHelper;
import java.util.List;
import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.core.Holder;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientboundSetActionBarTextPacket;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectCategory;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.TamableAnimal;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;

@AutoSpellConfig
public class BanishSpell
extends AbstractSpell {
    private final ResourceLocation spellId = new ResourceLocation("gametechbcs_spellbooks", "banish");
    private final DefaultConfig defaultConfig = new DefaultConfig().setMinRarity(SpellRarity.RARE).setSchoolResource(SchoolRegistry.HOLY_RESOURCE).setMaxLevel(3).setCooldownSeconds(90.0).build();

    public BanishSpell() {
        this.manaCostPerLevel = 50;
        this.baseSpellPower = 1;
        this.spellPowerPerLevel = 1;
        this.castTime = 39;
        this.baseManaCost = 100;
    }

    public CastType getCastType() {
        return CastType.LONG;
    }

    public DefaultConfig getDefaultConfig() {
        return this.defaultConfig;
    }

    public ResourceLocation getSpellResource() {
        return this.spellId;
    }

    public Optional<SoundEvent> getCastStartSound() {
        return Optional.of((SoundEvent)GSSounds.BANISH_CHARGE.get());
    }

    public Optional<SoundEvent> getCastFinishSound() {
        return Optional.of((SoundEvent)GSSounds.BANISH_CAST.get());
    }

    public boolean stopSoundOnCancel() {
        return true;
    }

    public AnimationHolder getCastStartAnimation() {
        return GSSpellAnimations.BANISH_CHARGE;
    }

    public AnimationHolder getCastFinishAnimation() {
        return GSSpellAnimations.BANISH_FINISH;
    }

    public boolean canBeInterrupted(@Nullable Player player) {
        return false;
    }

    public int getEffectiveCastTime(int spellLevel, @Nullable LivingEntity entity) {
        return this.getCastTime(spellLevel);
    }

    public void onServerPreCast(Level level, int spellLevel, LivingEntity entity, @Nullable MagicData playerMagicData) {
        double radius = this.getRange(spellLevel);
        MutableComponent message = Component.translatable((String)"spell.gametechbcs_spellbooks.banish.message.precast").withStyle(ChatFormatting.YELLOW);
        level.getEntitiesOfClass(ServerPlayer.class, entity.getBoundingBox().inflate(radius)).forEach(arg_0 -> BanishSpell.lambda$onServerPreCast$0((Component)message, arg_0));
        MagicManager.spawnParticles((Level)level, (ParticleOptions)new ShockwaveParticleOptions(((SchoolType)SchoolRegistry.HOLY.get()).getTargetingColor(), -3.0f, true), (double)entity.getX(), (double)entity.getY(), (double)entity.getZ(), (int)1, (double)0.0, (double)0.0, (double)0.0, (double)0.0, (boolean)true);
        super.onServerPreCast(level, spellLevel, entity, playerMagicData);
    }

    public void onServerCastTick(Level level, int spellLevel, LivingEntity entity, @Nullable MagicData playerMagicData) {
        float radius = this.getRange(spellLevel);
        CylinderParticleManager.spawnParticles((Level)level, (LivingEntity)entity, (int)(5 * spellLevel), (ParticleOptions)ParticleHelper.CLEANSE_PARTICLE, (ParticleDirection)ParticleDirection.UPWARD, (double)radius, (double)(3 * spellLevel), (double)-1.0);
        CameraShakeManager.addCameraShake((CameraShakeData)new CameraShakeData(15, entity.position(), radius));
        super.onServerCastTick(level, spellLevel, entity, playerMagicData);
    }

    public void onCast(Level level, int spellLevel, LivingEntity caster, CastSource castSource, MagicData playerMagicData) {
        float radius = this.getRange(spellLevel);
        float healingAmount = this.getHealAmount(spellLevel, caster);
        MagicManager.spawnParticles((Level)level, (ParticleOptions)new BlastwaveParticleOptions(((SchoolType)SchoolRegistry.HOLY.get()).getTargetingColor(), radius), (double)caster.getX(), (double)(caster.getY() + (double)0.165f), (double)caster.getZ(), (int)1, (double)0.0, (double)0.0, (double)0.0, (double)0.0, (boolean)true);
        CameraShakeManager.addCameraShake((CameraShakeData)new CameraShakeData(15, caster.position(), radius));
        MutableComponent message = Component.translatable((String)"spell.gametechbcs_spellbooks.banish.message.postcast").withStyle(ChatFormatting.RED);
        level.getEntitiesOfClass(ServerPlayer.class, caster.getBoundingBox().inflate((double)radius)).forEach(arg_0 -> BanishSpell.lambda$onCast$1((Component)message, arg_0));
        level.getEntitiesOfClass(LivingEntity.class, caster.getBoundingBox().inflate((double)radius)).forEach(entity -> {
            if (this.isAlly(caster, (LivingEntity)entity)) {
                entity.heal(healingAmount);
            }
        });
        List<Holder> casterEffects = caster.getActiveEffects().stream().map(MobEffectInstance::getEffect).filter(holder -> ((MobEffect)holder.value()).getCategory() == MobEffectCategory.HARMFUL).filter(holder -> !holder.is(GSTags.BANISH_IMMUNE)).toList();
        casterEffects.forEach(arg_0 -> ((LivingEntity)caster).removeEffect(arg_0));
        Holder.Reference damageTypeHolder = level.registryAccess().registryOrThrow(Registries.DAMAGE_TYPE).getHolderOrThrow(GSDamageTypes.BANISH);
        DamageSource customDamageSource = new DamageSource((Holder)damageTypeHolder);
        level.getEntitiesOfClass(LivingEntity.class, caster.getBoundingBox().inflate((double)radius)).forEach(entity -> {
            if (entity != caster) {
                List<Holder> entityEffects = entity.getActiveEffects().stream().map(MobEffectInstance::getEffect).filter(holder -> ((MobEffect)holder.value()).getCategory() == MobEffectCategory.BENEFICIAL).filter(holder -> !holder.is(GSTags.BANISH_IMMUNE)).toList();
                entityEffects.forEach(arg_0 -> ((LivingEntity)entity).removeEffect(arg_0));
                if (entity.getType().is(GSTags.BANISH_INSTAKILLS)) {
                    entity.remove(Entity.RemovalReason.KILLED);
                } else if (entity.getType().is(GSTags.BANISHABLE_ENTITY)) {
                    entity.hurt(customDamageSource, Float.MAX_VALUE);
                }
                if (entity instanceof AntiMagicSusceptible) {
                    AntiMagicSusceptible antiMagicSusceptible = (AntiMagicSusceptible)entity;
                    if (antiMagicSusceptible instanceof IMagicSummon) {
                        IMagicSummon summon = (IMagicSummon)antiMagicSusceptible;
                        if (summon.getSummoner() == caster) {
                            Mob mob;
                            if (summon instanceof Mob && (mob = (Mob)summon).getTarget() == null) {
                                antiMagicSusceptible.onAntiMagic(playerMagicData);
                            }
                        } else {
                            antiMagicSusceptible.onAntiMagic(playerMagicData);
                        }
                    } else {
                        antiMagicSusceptible.onAntiMagic(playerMagicData);
                    }
                } else if (entity instanceof ServerPlayer) {
                    ServerPlayer serverPlayer = (ServerPlayer)entity;
                    Utils.serverSideCancelCast((ServerPlayer)serverPlayer, (boolean)true);
                    MagicData.getPlayerMagicData((LivingEntity)serverPlayer).getPlayerRecasts().removeAll(RecastResult.COUNTERSPELL);
                } else if (entity instanceof IMagicEntity) {
                    IMagicEntity abstractSpellCastingMob = (IMagicEntity)entity;
                    abstractSpellCastingMob.cancelCast();
                }
            }
        });
        super.onCast(level, spellLevel, caster, castSource, playerMagicData);
    }

    public List<MutableComponent> getUniqueInfo(int spellLevel, LivingEntity caster) {
        float range = this.getRange(spellLevel);
        float healAmount = this.getHealAmount(spellLevel, caster);
        return List.of(Component.translatable((String)"ui.gametechbcs_spellbooks.radius", (Object[])new Object[]{Utils.stringTruncation((double)range, (int)2)}), Component.translatable((String)"ui.gametechbcs_spellbooks.heal", (Object[])new Object[]{Utils.stringTruncation((double)healAmount, (int)2)}), Component.literal((String)"\u00a79GTBC's Spellbooks"));
    }

    private float getRange(int spellLevel) {
        return spellLevel * 4;
    }

    private float getHealAmount(int spellLevel, LivingEntity caster) {
        return 4.0f + this.getSpellPower(spellLevel, (Entity)caster) * 4.0f;
    }

    private boolean isAlly(LivingEntity caster, LivingEntity target) {
        TamableAnimal tamable;
        return target == caster || target instanceof TamableAnimal && (tamable = (TamableAnimal)target).isTame() && tamable.getOwner() == caster;
    }

    private static /* synthetic */ void lambda$onCast$1(Component message, ServerPlayer player) {
        player.connection.send((Packet)new ClientboundSetActionBarTextPacket(message));
    }

    private static /* synthetic */ void lambda$onServerPreCast$0(Component message, ServerPlayer player) {
        player.connection.send((Packet)new ClientboundSetActionBarTextPacket(message));
    }
}

