/*
 * Decompiled with CFR 0.152.
 */
package com.gametechbc.gametechbcsspellbooks.spells.fire;

import com.gametechbc.gametechbcsspellbooks.api.spells.GSSpellAnimations;
import com.gametechbc.gametechbcsspellbooks.init.GSEffects;
import com.gametechbc.spelllib.particle.ParticleDirection;
import com.gametechbc.spelllib.particle.SphereParticleManager;
import io.redspace.ironsspellbooks.api.config.DefaultConfig;
import io.redspace.ironsspellbooks.api.magic.MagicData;
import io.redspace.ironsspellbooks.api.registry.SchoolRegistry;
import io.redspace.ironsspellbooks.api.spells.AbstractSpell;
import io.redspace.ironsspellbooks.api.spells.AutoSpellConfig;
import io.redspace.ironsspellbooks.api.spells.CastSource;
import io.redspace.ironsspellbooks.api.spells.CastType;
import io.redspace.ironsspellbooks.api.spells.SchoolType;
import io.redspace.ironsspellbooks.api.spells.SpellRarity;
import io.redspace.ironsspellbooks.api.util.AnimationHolder;
import io.redspace.ironsspellbooks.api.util.CameraShakeData;
import io.redspace.ironsspellbooks.api.util.CameraShakeManager;
import io.redspace.ironsspellbooks.api.util.Utils;
import io.redspace.ironsspellbooks.capabilities.magic.MagicManager;
import io.redspace.ironsspellbooks.particle.BlastwaveParticleOptions;
import io.redspace.ironsspellbooks.registries.SoundRegistry;
import io.redspace.ironsspellbooks.util.ParticleHelper;
import java.util.List;
import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.Level;

@AutoSpellConfig
public class MeteorStormSpell
extends AbstractSpell {
    private final ResourceLocation spellId = new ResourceLocation("gametechbcs_spellbooks", "meteor_storm");
    private final DefaultConfig defaultConfig = new DefaultConfig().setMinRarity(SpellRarity.UNCOMMON).setSchoolResource(SchoolRegistry.FIRE_RESOURCE).setMaxLevel(6).setCooldownSeconds(90.0).build();

    public MeteorStormSpell() {
        this.manaCostPerLevel = 30;
        this.baseSpellPower = 1;
        this.spellPowerPerLevel = 1;
        this.castTime = 15;
        this.baseManaCost = 50;
    }

    public CastType getCastType() {
        return CastType.LONG;
    }

    public DefaultConfig getDefaultConfig() {
        return this.defaultConfig;
    }

    public ResourceLocation getSpellResource() {
        return this.spellId;
    }

    public Optional<SoundEvent> getCastStartSound() {
        return Optional.of((SoundEvent)SoundRegistry.FIRE_CAST.get());
    }

    public Optional<SoundEvent> getCastFinishSound() {
        return Optional.of(SoundEvents.DRAGON_FIREBALL_EXPLODE);
    }

    public AnimationHolder getCastStartAnimation() {
        return GSSpellAnimations.METEOR_STORM_CAST;
    }

    public AnimationHolder getCastFinishAnimation() {
        return AnimationHolder.pass();
    }

    public int getEffectiveCastTime(int spellLevel, @Nullable LivingEntity entity) {
        return this.getCastTime(spellLevel);
    }

    public void onCast(Level level, int spellLevel, LivingEntity entity, CastSource castSource, MagicData playerMagicData) {
        int duration = this.getDuration(spellLevel);
        int damage = this.getDamage(entity, spellLevel);
        if (!entity.hasEffect(GSEffects.METEOR_STORM)) {
            entity.addEffect(new MobEffectInstance(GSEffects.METEOR_STORM, duration, damage, false, true));
        }
        MagicManager.spawnParticles((Level)level, (ParticleOptions)new BlastwaveParticleOptions(((SchoolType)SchoolRegistry.FIRE.get()).getTargetingColor(), 1.0f), (double)entity.getX(), (double)(entity.getY() + (double)0.165f), (double)entity.getZ(), (int)1, (double)0.0, (double)0.0, (double)0.0, (double)0.0, (boolean)true);
        SphereParticleManager.spawnParticles((Level)level, (LivingEntity)entity, (int)60, (ParticleOptions)ParticleHelper.FIRE, (ParticleDirection)ParticleDirection.OUTWARD, (double)3.5);
        CameraShakeManager.addCameraShake((CameraShakeData)new CameraShakeData(20, entity.position(), 26.0f));
        super.onCast(level, spellLevel, entity, castSource, playerMagicData);
    }

    public int getDuration(int spellLevel) {
        return 160 + spellLevel * 60;
    }

    public int getDamage(LivingEntity caster, int spellLevel) {
        return (int)(3.0 + (double)(this.getSpellPower(spellLevel, (Entity)caster) * 2.0f));
    }

    public List<MutableComponent> getUniqueInfo(int spellLevel, LivingEntity caster) {
        int damage = this.getDamage(caster, spellLevel);
        int duration = this.getDuration(spellLevel);
        return List.of(Component.translatable((String)"ui.gametechbcs_spellbooks.damage", (Object[])new Object[]{Utils.stringTruncation((double)damage, (int)1)}), Component.translatable((String)"ui.gametechbcs_spellbooks.radius", (Object[])new Object[]{Utils.stringTruncation((double)24.0, (int)2)}), Component.translatable((String)"ui.gametechbcs_spellbooks.meteor_storm_duration", (Object[])new Object[]{Utils.timeFromTicks((float)duration, (int)2)}), Component.literal((String)"\u00a79GTBC's Spellbooks"));
    }
}

