/*
 * Decompiled with CFR 0.152.
 */
package com.gametechbc.gametechbcsspellbooks.entity.spells;

import com.gametechbc.gametechbcsspellbooks.init.GSEffects;
import com.gametechbc.gametechbcsspellbooks.init.GSEntities;
import com.gametechbc.gametechbcsspellbooks.util.GSDamageTypes;
import io.redspace.ironsspellbooks.capabilities.magic.MagicManager;
import io.redspace.ironsspellbooks.damage.DamageSources;
import io.redspace.ironsspellbooks.entity.spells.AoeEntity;
import io.redspace.ironsspellbooks.particle.BlastwaveParticleOptions;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import org.joml.Vector3f;

public class BlackoutAntiMagicField
extends AoeEntity {
    private DamageSource movementDamageSource;
    private final Map<LivingEntity, Vec3> entityLastPositions = new HashMap<LivingEntity, Vec3>();
    private float damage = 2.0f;

    public BlackoutAntiMagicField(EntityType<? extends Projectile> pEntityType, Level pLevel) {
        super(pEntityType, pLevel);
    }

    public BlackoutAntiMagicField(Level level) {
        this((EntityType<? extends Projectile>)((EntityType)GSEntities.BLACKOUT_ANTI_MAGIC_FIELD.get()), level);
    }

    public void applyEffect(LivingEntity target) {
        target.addEffect(new MobEffectInstance(GSEffects.BLACKOUT, 60, 0, false, false, false));
    }

    public void tick() {
        super.tick();
        if (!this.level().isClientSide && this.tickCount % 20 == 0) {
            MagicManager.spawnParticles((Level)this.level(), (ParticleOptions)new BlastwaveParticleOptions(new Vector3f(0.1f, 0.1f, 0.1f), this.getRadius()), (double)this.getX(), (double)(this.getY() + (double)0.165f), (double)this.getZ(), (int)1, (double)0.0, (double)0.0, (double)0.0, (double)0.0, (boolean)true);
            for (LivingEntity entity2 : this.getEntitiesInsideRadius(LivingEntity.class)) {
                Vec3 lastPos;
                if (entity2 == this.getOwner()) continue;
                Vec3 currentPos = entity2.position();
                if (!currentPos.equals((Object)(lastPos = this.entityLastPositions.getOrDefault(entity2, currentPos)))) {
                    if (this.movementDamageSource == null) {
                        this.movementDamageSource = new DamageSource(DamageSources.getHolderFromResource((Entity)entity2, GSDamageTypes.BLACKOUT), (Entity)this, this.getOwner());
                    }
                    DamageSources.ignoreNextKnockback((LivingEntity)entity2);
                    entity2.hurt(this.movementDamageSource, this.damage);
                }
                this.entityLastPositions.put(entity2, currentPos);
            }
            this.entityLastPositions.keySet().removeIf(entity -> !this.isInsideRadius(entity.position()));
        }
    }

    public float getParticleCount() {
        return 1.2f * this.getRadius();
    }

    protected float particleYOffset() {
        return 0.25f;
    }

    protected float getParticleSpeedModifier() {
        return 1.4f;
    }

    public Optional<ParticleOptions> getParticle() {
        return Optional.of(ParticleTypes.SMOKE);
    }

    private <T extends Entity> List<T> getEntitiesInsideRadius(Class<T> entityType) {
        return this.level().getEntitiesOfClass(entityType, this.getBoundingBox());
    }

    private boolean isInsideRadius(Vec3 position) {
        return position.distanceTo(this.position()) <= (double)this.getRadius();
    }

    public float getDamage() {
        return this.damage;
    }

    public void setMovementDamage(float damage) {
        this.damage = damage;
    }

    protected void addAdditionalSaveData(CompoundTag tag) {
        super.addAdditionalSaveData(tag);
        tag.putFloat("Damage", this.damage);
    }

    protected void readAdditionalSaveData(CompoundTag tag) {
        super.readAdditionalSaveData(tag);
        if (tag.contains("Damage")) {
            this.damage = tag.getFloat("Damage");
        }
    }
}

