/*
 * Decompiled with CFR 0.152.
 */
package com.gametechbc.gametechbcsspellbooks.effects.Reversal;

import com.gametechbc.gametechbcsspellbooks.init.GSEffects;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.projectile.Projectile;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.event.entity.living.LivingDamageEvent;
import net.neoforged.neoforge.event.entity.living.LivingKnockBackEvent;

@EventBusSubscriber(modid="gametechbcs_spellbooks")
public class ReversalEffectHandler {
    private static final Map<UUID, Float> storedDamageMap = new HashMap<UUID, Float>();
    private static final Map<UUID, Projectile> lastProjectileHitMap = new HashMap<UUID, Projectile>();

    @SubscribeEvent
    public static void onLivingDamagePre(LivingDamageEvent.Pre event) {
        LivingEntity entity = event.getEntity();
        if (entity.hasEffect(GSEffects.REVERSAL)) {
            float damage = event.getNewDamage();
            ReversalEffectHandler.storeDamage(entity, damage);
            Entity entity2 = event.getSource().getDirectEntity();
            if (entity2 instanceof Projectile) {
                Projectile projectile = (Projectile)entity2;
                ReversalEffectHandler.storeLastProjectileHit(entity, projectile);
                entity.removeEffect(GSEffects.REVERSAL);
            }
            entity.setDeltaMovement(0.0, 0.0, 0.0);
            entity.hurtMarked = false;
            entity.setNoActionTime(10);
            event.setNewDamage(0.0f);
        }
    }

    @SubscribeEvent
    public static void onLivingKnockBack(LivingKnockBackEvent event) {
        LivingEntity entity = event.getEntity();
        if (entity.hasEffect(GSEffects.REVERSAL)) {
            event.setCanceled(true);
        }
    }

    public static void storeDamage(LivingEntity entity, float damage) {
        storedDamageMap.put(entity.getUUID(), Float.valueOf(storedDamageMap.getOrDefault(entity.getUUID(), Float.valueOf(0.0f)).floatValue() + damage));
    }

    public static float getStoredDamage(LivingEntity entity) {
        return storedDamageMap.getOrDefault(entity.getUUID(), Float.valueOf(0.0f)).floatValue();
    }

    public static void clearStoredDamage(LivingEntity entity) {
        storedDamageMap.remove(entity.getUUID());
    }

    public static void storeLastProjectileHit(LivingEntity entity, Projectile projectile) {
        lastProjectileHitMap.put(entity.getUUID(), projectile);
    }

    public static Projectile getLastProjectileHit(LivingEntity entity) {
        return lastProjectileHitMap.get(entity.getUUID());
    }

    public static void clearLastProjectileHit(LivingEntity entity) {
        lastProjectileHitMap.remove(entity.getUUID());
    }
}

